/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * SCR2 specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_CONTACT_RDSCR2_CMD_H
#define PHHALHW_CONTACT_RDSCR2_CMD_H

#include <ph_Status.h>
#include <phhalHwContact.h>

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR2

/** \defgroup phhalHwContact_RdScr2_Cmd Commands
* \brief Supported Scr2 Contactbased commands.
* @{
*/

/**
* \brief Configure the trigger in/output
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHwContact_RdScr2_Cmd_Trigger(
    phhalHwContact_RdScr2_DataParams_t * pDataParams,
    uint8_t bTriggerPort,
    uint32_t dwConfig,
    float64_t dValue
    );

/**
* \brief Configure trigger sensitiv exchange
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHwContact_RdScr2_Cmd_ConfigTriggeredExchange(
    phhalHwContact_RdScr2_DataParams_t * pDataParams,
    uint8_t bTriggerPort,
    uint32_t dwHwInterface,
    uint32_t dwTriggerMode
    );

/**
* \brief Resets all TDA blocks. All triggers are deactivated.
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHwContact_RdScr2_Cmd_TdaClearTriggers(
    phhalHwContact_RdScr2_DataParams_t * pDataParams
    );

/**
* \brief Configures a TDA block.
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHwContact_RdScr2_Cmd_TdaSetTrigger(
    phhalHwContact_RdScr2_DataParams_t * pDataParams,
    uint32_t dwTriggerSelect,
    uint32_t dwTriggerSource,
    uint32_t dwTriggerDelay,
    uint32_t dwTriggerAction
    );

/**
* \brief Starts a previously defined TDA sequence.
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHwContact_RdScr2_Cmd_TdaStart(
    phhalHwContact_RdScr2_DataParams_t * pDataParams,
    uint32_t dwTimeoutUs,
    uint32_t dwAbortConditions
    );

/**
* \brief Stops a TDA sequence.
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHwContact_RdScr2_Cmd_TdaStop(
    phhalHwContact_RdScr2_DataParams_t * pDataParams
    );

/**
* \brief Retrieves the current state of TDA blocks.
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions.
*/
phStatus_t phhalHwContact_RdScr2_Cmd_TdaGetStatus(
    phhalHwContact_RdScr2_DataParams_t * pDataParams,
    uint32_t * pTdaStatus
    );
/** @} */
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR2 */

#ifdef __cplusplus
} /* Extern C */
#endif

#endif /* PHHALHW_CONTACT_RDSCR2_CMD_H */
