/*
 * Copyright 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Mp300 specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLSTEPPER_WACHLER_CMD_H
#define PHDLSTEPPER_WACHLER_CMD_H


#include <ph_Status.h>
#include <phdlStepper.h>

/**
* \brief Checks if the current movement is done, or the robots still moves
* \return Status code
* \retval #PH_ERR_SUCCESS Command successfully executed
* \retval Other Invalid parameters or conditions - the error status is returned by the underlayed functions. If the parameters are correct the function
*/
phStatus_t phdlStepper_Wachler_Cmd_WaitUntilMoveFinished(
                                                         phdlStepper_Wachler_DataParams_t * pDataParams                      /**< [In] Pointer to this layer's parameter structure. */
                                                         );
#endif /* PHDLSTEPPER_WACHLER_CMD_H */
