/*
 * Copyright 2016, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef PH_EXAMPLE_MIFARE_PRIME_NTAG_H
#define PH_EXAMPLE_MIFARE_PRIME_NTAG_H
#define EXIT 	                1
#define AUTHENTICATE            2
#define AUTHENTICATEISO
#define AUTHENTICATEAES         4
#define CHANGEKEYSETTINGS       5
#define GETKEYSETTINGS          6
#define CHANGEKEY               7
#define GETKEYVERSION           8
#define CREATEAPPLICATION       9
#define DELETEAPPLICATION       10
#define GETAPPLICATIONIDS       11
#define SELECTAPPLICATION       13
#define FORMATPICC              14
#define GETVERSION              15
#define FREEMEM                 16
#define SETCONFIGURATION        17
#define GETCARDUID              18
#define GETFILEIDS              19
#define GETISOFILEIDS           20
#define GETFILESETTINGS         21
#define CHANGEFILESETTINGS      22
#define CREATESTDDATAFILE       23
#define CREATEBACKUPDATAFILE    24
#define CREATEVALUEFILE         25
#define CREATELINEARRECORDFILE  26
#define CREATECYCLICRECORDFILE  27
#define DELETEFILE              28
#define READDATA                29
#define WRITEDATA               30
#define GETVALUE                31
#define CREDIT                  32
#define DEBIT                   33
#define LIMITEDCREDIT           34
#define CLEARRECORDFILE         37
#define COMMITTRANSACTION       38
#define ABORTTRANSACTION        39
#define ISOSELECTFILE           40
#define ISOREADBINARY           41
#define ISOUPDATEBINARY         42
#define ISOREADRECORDS          43
#define ISOAPPENDRECORD         45
#define ISOGETCHALLENGE         46
#define ISOEXTERNALAUTHENTICATE 47
#define ISOINTERNALAUTHENTICATE 48
#define ISOAUTHENTICATE         49

#define PHAL_MFDFEV2_UNUSED_VARIABLE(x)  {for( ( x ) = ( x ) ; ( x ) != ( x ) ; );}
#define PHAL_MFDFEV2_UNUSED_ARRAY(x)  {for( ( (x)[0] ) = ( (x)[0] ) ; ( (x)[0] ) != ( (x)[0] ) ; );}

/**
 * Standard Header
 */
#ifdef _WIN32
#pragma warning(push)           /* PRQA S 3116 */
#pragma warning(disable:4001)   /* PRQA S 3116 */
#endif
#include <crtdbg.h>
#include <memory.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#ifdef _WIN32
#pragma warning(pop)            /* PRQA S 3116 */
#endif

#endif /* PH_EXAMPLE_MIFARE_PRIME_NTAG_H */
