/*
 * Copyright 2013, 2015, 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Example Source for Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

/**
 * Header
 */
#include "Example-Rc663_ICodeSLI.h"
int __cdecl main(int argc, char *argv[])
{
    /* ******************************************************************************* */
    /* DECLARATION */
    /* ******************************************************************************* */
    /* data parameter storage */
    phbalReg_SerialWin_DataParams_t balSerial;
    phhalHw_Rc663_DataParams_t      halReader;
    phpalSli15693_Sw_DataParams_t   palSli;
	phalICode_Sw_DataParams_t		alICode;

    /* common variables */
    uint8_t bIndex;
    char * pArgument;
    phStatus_t status;

    /* variables used by the BAL copmonent */
    uint8_t * pComPort = (uint8_t*)"COM4";

    /* variables used by the HAL component */
    uint8_t bHalBufferReader[256];

    /* variables used by the PAL component */
    uint8_t bOption, bFlags, bAfi;
    uint8_t pMask[PHPAL_SLI15693_UID_LENGTH], bMaskLength;
    uint8_t bDsfid, pUid[PHPAL_SLI15693_UID_LENGTH];
    uint8_t bRxLength, bMoreCardsAvaliable;

    uint8_t  bBlockNo;
    uint16_t wNoOfBlocks;
    uint8_t  bUidLength;
    uint8_t  pData[PHAL_ICODE_BLOCK_SIZE * 28];
    uint16_t wDataLength;

    /* variables used by the AL (ICode) component */
    uint8_t pOriginalData[PHAL_ICODE_BLOCK_SIZE];
    uint8_t** ppData = (uint8_t**)&pData;


    /* ******************************************************************************* */
    /* INITIALISATION */
    /* ******************************************************************************* */
    /* iterate through all arguments */
    for (bIndex = 0; bIndex < (uint8_t)argc; ++bIndex);
    {
        /* Retrive next argument */
        pArgument = argv[bIndex];

        /* */
        /* Insert argument handling here */
        /* */
    }

    /* initialise the 'bus abstraction layer' BAL: */
    /* use the serial interface */
    status = phbalReg_SerialWin_Init(&balSerial, sizeof(phbalReg_SerialWin_DataParams_t), 0, NULL);
    CHECK_SUCCESS(status);

    status = phbalReg_SetPort(&balSerial, pComPort);
    CHECK_SUCCESS(status);

    /* initialise the 'hardware abstraction layer' HAL: */
    /* use the RC663 Reader IC, glue it together with the BAL component */
    status = phhalHw_Rc663_Init(
        &halReader,
        sizeof(phhalHw_Rc663_DataParams_t),
        &balSerial,
        NULL,
        bHalBufferReader,
        sizeof(bHalBufferReader),
        bHalBufferReader,
        sizeof(bHalBufferReader));
    CHECK_SUCCESS(status);

    /* initialise the 'protocol abstraction layer' PAL: */
    /* use the the Sli15693 protocol. */
    status = phpalSli15693_Sw_Init(&palSli, sizeof(palSli), &halReader);
    CHECK_SUCCESS(status);

    /* initialise the 'application layer' AL: */
    /* use the ISO15693 application, glue it together with the PAL component */
    status = phalICode_Sw_Init(&alICode, sizeof(alICode), &palSli, NULL, NULL, NULL);

    status = phbalReg_OpenPort(&balSerial);
    CHECK_SUCCESS(status);

    /* set the PCs baud rate to 115200 */
    status = phbalReg_SetConfig(&balSerial, PHBAL_REG_SERIALWIN_CONFIG_BITRATE, PHBAL_REG_SERIALWIN_VALUE_BITRATE_115200);
    CHECK_SUCCESS(status);

    /* On some machines the RS232 physical interface jitters when the port is opened. For that case, */
    /* send a dummy command in order to the resynchronise the interface. */
    phhalHw_WriteRegister(&halReader, 0x37, 0xFF);

    /* Configure HAL for Sli15693 tags */
    status = phhalHw_ApplyProtocolSettings(&halReader, PHHAL_HW_CARDTYPE_ISO15693);
    CHECK_SUCCESS(status);

    /* ******************************************************************************* */
    /* CARD COMMUNICATION */
    /* ******************************************************************************* */
    /* Switch on the field */
    status = phhalHw_FieldReset(&halReader);
    CHECK_SUCCESS(status);

    /* Activate card */
    bOption = PHPAL_SLI15693_ACTIVATE_ADDRESSED;
    bFlags =  PHPAL_SLI15693_FLAG_NBSLOTS | PHPAL_SLI15693_FLAG_DATA_RATE;
    bAfi = 0xFF; /* Application Family: 0xFF --> all Applications */
    bMaskLength = 0;
    status = phpalSli15693_ActivateCard(&palSli, bOption, bFlags,
                                        bAfi, pMask, bMaskLength,
                                        &bDsfid, pUid, &bMoreCardsAvaliable);
    printf("phpalSli15693_ActivateCard:  %04X\n", status);

    if(PH_ERR_SUCCESS == status)
    {
        status = phpalSli15693_GetSerialNo(&palSli, pUid, &bRxLength);
        printf("phpalSli15693_GetSerialNo:   %04X\nUID: ", status);
        printBufferHex(pUid, bRxLength);

        if(bRxLength == PHPAL_SLI15693_UID_LENGTH)
        {
            memcpy(pMask, pUid, PHPAL_SLI15693_UID_LENGTH);
            bMaskLength = PHPAL_SLI15693_UID_LENGTH * 8;
        }

        /* Sli Inventory Read (PAL) */
        bFlags = 0x32;
        bAfi = 0x00;
        bBlockNo = 0;
        wNoOfBlocks = 28;
        status = phpalSli15693_InventoryRead(&palSli, bFlags, bAfi, pMask, bMaskLength,
                                              bBlockNo, wNoOfBlocks,
                                              pUid, &bUidLength,
                                              pData, &wDataLength);
        printf("phpalSli15693_InventoryRead: %04X\n", status);

        if(PH_ERR_SUCCESS == status)
        {
            printf("Block Data, %3d bytes:\n", wDataLength);
            for(bIndex = 0; bIndex < wNoOfBlocks; bIndex++)
            {
                printf("Block %2d: ",bIndex);
                printBufferHex(pData+(bIndex*PHPAL_SLI15693_BLOCK_LENGTH),
                                    (uint8_t)PHPAL_SLI15693_BLOCK_LENGTH);
            }
        }

        /* Store the blocks Data in pOriginalData, then write the block, read it back and
           restore it finally. */

        /* Write one block (AL) */
        bOption = PHAL_ICODE_OPTION_DEFAULT;
        bBlockNo = 10;

        status = phalICode_ReadSingleBlock(&alICode, bOption, bBlockNo, ppData, &wDataLength);
        CHECK_SUCCESS(status);
        memcpy(pOriginalData, (uint8_t*)*ppData, wDataLength);

        memcpy(pData, "\xAB\xCD\xEF\xBA", 4);
        wDataLength = 4;
        status = phalICode_WriteSingleBlock(&alICode, bOption, bBlockNo, pData, (uint8_t) wDataLength);
        printf("phalI15693_WriteSingleBlock:          %04X\n", status);
        if(PH_ERR_SUCCESS == status)
        {
            printf("Wrote Block %2d with data Data: ", bBlockNo);
            printBufferHex(pData, (uint8_t)wDataLength);
        }

        /* Read one block (AL) */
        status = phalICode_ReadSingleBlock(&alICode, bOption, bBlockNo, ppData, &wDataLength);
        printf("phalI15693_ReadSingleBlock:          %04X\n", status);


        if(PH_ERR_SUCCESS == status)
        {
            printf("Block %2d Data, %3d bytes:\n", bBlockNo, wDataLength);
            printBufferHex((uint8_t*)*ppData, (uint8_t)wDataLength);
        }

        status = phalICode_WriteSingleBlock(&alICode, bOption, bBlockNo, pOriginalData, (uint8_t) wDataLength);
        CHECK_SUCCESS(status);
    }


    status = phbalReg_ClosePort(&balSerial);
    fprintf(stdout, "\n press any key to exit\n");
    _getch();
    return 0;
}

/**
 * Helper functions
 */
void printBufferHex(uint8_t * pBuffer, uint8_t bLength)
{
    uint8_t bIndex;

    for (bIndex = 0; bIndex < bLength; ++bIndex)
    {
        printf("%02X ", pBuffer[bIndex]);
    }
    printf("\n");
}