/*
 * Copyright 2024 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef PH_EXAMPLE_RD71X_SAMAV3_H
#define PH_EXAMPLE_RD71X_SAMAV3_H

/* Reader Library Headers */

#include <phCidManager.h>
#include <phKeyStore.h>
#include <phCryptoRng.h>
#include <phCryptoSym.h>

#include <phbalReg.h>

#include <phhalHw.h>
#include <phhalHw_DUT_Cmd.h>
#include <phhalHw_Rd710_Cmd.h>

#include <phpalI14443p3a.h>
#include <phpalI14443p4a.h>
#include <phpalI14443p4.h>
#include <phpalMifare.h>
#include <phpalSli15693.h>

#include <phalMfdf.h>

/* Standard Header */
#ifdef _WIN32
#pragma warning(push)           /* PRQA S 3116 */
#pragma warning(disable:4001)   /* PRQA S 3116 */
#endif

#include <memory.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>

#ifdef _WIN32
#pragma warning(pop)            /* PRQA S 3116 */
#endif

#define PCSC_READER_P2_S_CONTACTLESS_NAME       "NXP Pegoda S CL 0 0"
#define PCSC_READER_P2_S_CONTACTLESS_NAME_EXT   "NXP Pegoda N CL 0 0"

#define PCSC_READER_P2_S_CONTACT_NAME           "NXP Pegoda S 0 0"
#define PCSC_READER_P2_S_CONTACT_NAME_EXT       "Broadcom Corp Contacted SmartCard 0"
#define PCSC_READER_P2_X_NAME                   "NXP Pegoda X 0 0"

#define PL_CODE_FILE                            "PL_CODE_APP4.hex"

#define KEY_TYPE_DESFire4                       0x00
#define KEY_TYPE_ISO_TDEA16                     0x08
#define KEY_TYPE_MIFARE                         0x10
#define KEY_TYPE_AES128                         0x20
#define KEY_TYPE_ISO_TDEA32                     0x30
#define KEY_TYPE_AES128_LRP                     0x40

#define KEY_CLASS_HOST                          0x00
#define KEY_CLASS_PICC                          0x01
#define KEY_CLASS_OFFLINE_CRYPTO                0x04
#define KEY_CLASS_OFFLINE_UPLOAD                0x05


#define SAM_MASTER_KEY                          0x00
#define SAM_UNLOCK_PL_KEY                       0xF0


#define SAM_MASTER_KEY_ADDRESS                  0
#define SAM_MASTER_KEY_VERSION                  0

#define LOCK_UNLOCK_KEY_ADDRESS                 1
#define LOCK_UNLOCK_KEY_VERSION                 0

#define OFFLINE_CRYPTO_KEY_ADDRESS              2
#define OFFLINE_CRYPTO_KEY_VERSION              0

#define OFFLINE_UPLOAD_KEY_ADDRESS              3
#define OFFLINE_UPLOAD_KEY_VERSION              0

#define PICC_AES128_KEY_ADDRESS                 4
#define PICC_AES128_KEY_VERSION                 0

#define PICC_AES128_KEY_ADDRESS_NEW             5
#define PICC_AES128_KEY_VERSION_NEW             0

#define PICC_DESFIRE4_KEY_ADDRESS               6
#define PICC_DESFIRE4_KEY_VERSION               0

#define PICC_DESFIRE4_KEY_ADDRESS_NEW           7
#define PICC_DESFIRE4_KEY_VERSION_NEW           0

#define PICC_MIFARE_KEY_ADDRESS                 8
#define PICC_MIFARE_KEY_VERSION                 0

#define PICC_MFUL_2K3DES_KEY_ADDRESS            9
#define PICC_MFUL_2K3DES_KEY_VERSION            0

#define PICC_MFUL_AES_KEY_ADDRESS               10
#define PICC_MFUL_AES_KEY_VERSION               0

#define SAM_HOST_PL_KEY_ADDRESS                 11
#define SAM_HOST_PL_KEY_VERSION                 0

#define UNLOCK_PL_KEY_ADDRESS                   12
#define UNLOCK_PL_KEY_VERSION                   0

#define ISO_TDEA_32_KEY_ADDRESS                 13
#define ISO_TDEA_32_KEY_VERSION                 0

#define RAM_KEY_ADDRESS                         0xE0
#define RAM_KEY_VERSION                         0

/* Macros for switching between ISO14443 layer 3 or layer 4. ---------------------------------------------------*/
#define ISO14443_L3                             0x00
#define ISO14443_L4                             0x01
#define ISO15693                                0x02

/* Macros MIFARE Plus command exchanges. -----------------------------------------------------------------------*/
#define MFP_COMBINED_READ_READ                  0x00
#define MFP_COMBINED_READ_GET_VERSION           0x01
#define MFP_EV0_SECURE_MESSAGING                0x00
#define MFP_EV1_SECURE_MESSAGING                0x01

/* Macros MIFARE DESFire command exchanges. --------------------------------------------------------------------*/
#define MFD_AUTH_TYPE_D40                       0x00
#define MFD_AUTH_TYPE_EV2_FIRST                 0x80
#define MFD_AUTH_TYPE_EV2_NON_FIRST             0xC0
#define MFD_KEYTYPE_DES                         0x00
#define MFD_KEYTYPE_AES                         0x80
#define MFD_AUTH_TYPE_EV2                       0x00
#define MFD_AUTH_TYPE_LRP                       0x01

/* Macros MIFARE Ultralight command exchanges. -----------------------------------------------------------------*/
#define MFUL_AUTH_CLASSIC                       0x00
#define MFUL_AUTH_EV1                           0x01

/* Macros NTAG 42x DNA command exchanges. ----------------------------------------------------------------------*/
#define NTAG_42X_DNA_CFS_NO_SDM                 0x00
#define NTAG_42X_DNA_CFS_SDM                    0x40

#define CHECK_SUCCESS(Status)                                                                                                               \
    if ( ( (Status) & PH_ERR_MASK ) != PH_ERR_SUCCESS )                                                                                     \
    {                                                                                                                                       \
        return (Status);                                                                                                                    \
    }

#define CHECK_SUCCESS_PRINT(Status)                                                                                                         \
    if ( ( (Status) & PH_ERR_MASK ) != PH_ERR_SUCCESS )                                                                                     \
    {                                                                                                                                       \
        printf ( "\n\n" );                                                                                                                  \
        printf ( "An error occurred: (0x%04X)\n", (Status) );                                                                               \
                                                                                                                                            \
        return (Status);                                                                                                                    \
    }

#define CHECK_SUCCESS_CHAINING(Status)                                                                                                      \
    if ( ( (Status) & PH_ERR_MASK ) != PH_ERR_SUCCESS_CHAINING )                                                                            \
    {                                                                                                                                       \
        printf ( "\n\n" );                                                                                                                  \
        printf ( "An error occurred: (0x%04X)\n", (Status) );                                                                               \
        _getch ();                                                                                                                          \
        return (Status);                                                                                                                    \
    }

#define CHECK_SUCCESS_PICC(ActualStatus, ExpectedStatus)                                                                                    \
    if ( (ActualStatus) != (ExpectedStatus) )                                                                                               \
    {                                                                                                                                       \
        printf ( "\n\n" );                                                                                                                  \
        printf ( "Picc Exchange failed. Expected 0x%02X as PICC status but observed 0x%02X\n", ExpectedStatus, ActualStatus );              \
        return (ActualStatus);                                                                                                              \
    }

#define CHECK_SUCCESS_PICC_EXTENDED(ActualStatus, ExpectedStatus)                                                                           \
    if ( (ActualStatus) != (ExpectedStatus) )                                                                                               \
    {                                                                                                                                       \
        printf ( "\n\n" );                                                                                                                  \
        printf ( "Picc Exchange failed. Expected 0x%04X as PICC status but observed 0x%04X\n", ExpectedStatus, ActualStatus );              \
        return (ActualStatus);                                                                                                              \
    }

#define CHECK_SUCCESS_TAG(Status, Error)                                                                                                    \
    if ( (Status) != PH_ERR_SUCCESS )                                                                                                       \
    {                                                                                                                                       \
        printf ( "\n\n" );                                                                                                                  \
        printf ( "Tag Exchange failed. Expected SUCCESS as Tag status but observed 0x%02X\n", Error );                                      \
        return (Status);                                                                                                                    \
    }

#define CHECK_SUCCESS_EXPECTED(ActualStatus, ExpectedStatus)                                                                                \
    if ( (ActualStatus) != (ExpectedStatus) )                                                                                               \
    {                                                                                                                                       \
        printf ( "\n\n" );                                                                                                                  \
        printf ( "Failed. Expected 0x%04X as status but observed 0x%04X\n", ExpectedStatus, ActualStatus );                                 \
        return (ActualStatus);                                                                                                              \
    }                                                                                                                                       \
    else                                                                                                                                    \
        printf ( "Passed. Expected 0x%04X as status and observed 0x%04X\n", ExpectedStatus, ActualStatus );

#define TO_STRING(Data)         ( (Data) == S_MODE ) ? "S Mode" : "X Mode"

#define EXIT_IF_REQUESTED(Option) if ( ( dwChoice == 'x' ) || ( dwChoice == 'X' ) )  exit ( 0 );

enum ReaderMode { NONE = 0x00, S_MODE = 0x01, X_MODE_RC523 = 0x02 };
enum Demo { HOST_AUTHENTICATION = 1, LOCK_UNLOCK, GET_VERSION, ACTIVATE_OFFLINE, LOAD_INIT_VECTOR, KILL_AUTHENTICATION, SELECT_APPLICATION,
            GET_RANDOM, SLEEP, GET_KEY_ENTRY, CHANGE_KEY_ENTRY, GET_KUC_ENTRY, CHANGE_KUC_ENTRY, DUMP_SESSION_KEY, DUMP_SECRET_KEY,
            GENERATE_VERIFY_MAC, ENCIPHER_DECIPHER_DATA, ENCIPHER_DECIPHER_DATA_OFFLINE, DESFIRE, PLUS, CLASSIC, ULTRALIGHT,
            ISO_IEC_29167, TMAC, SDM, PROGRAMMABLE_LOGIC };

phKeyStore_Sw_DataParams_t stKeystoreSw;
phKeyStore_SamAV3_DataParams_t stKeystoreSAM;

phbalReg_PcscWin_DataParams_t stBal_Pcsc_ContactLess;
phbalReg_PcscWin_DataParams_t stBal_Pcsc_Contact;
phbalReg_SerialWin_DataParams_t stBal_Serial;
phbalReg_Sam_DataParams_t stBal_Sam;

phhalHw_Rd710_DataParams_t stHal_Rd710;
phhalHw_DUT_DataParams_t stHal_DUT;
phhalHw_SamAV3_DataParams_t stHal_SamAv3;

phCryptoSym_Sw_DataParams_t stCryptoEnc1;
phCryptoSym_Sw_DataParams_t stCryptoMAC1;

void * pBal_Generic = NULL;
void * pHal_Generic = NULL;

void * pPalIso14443_3A_Generic = NULL;
void * pPalIso14443_4A_Generic = NULL;
void * pPalIso14443_4_Generic = NULL;
void * pPalMifare_Generic = NULL;

void * pPalIso15693 = NULL;

enum ReaderMode eReaderMode = NONE;

uint8_t bCommMode = 0;

uint8_t aUid[10];
uint8_t bUid_Len = 0;
uint8_t aCmdBuf[70];
uint16_t wCmdLen = 0;

uint8_t * pPicc_Response = NULL;
uint16_t wPicc_RespLen = 0;

uint8_t * pSam_Response = NULL;
uint16_t wSam_RespLen = 0;

uint8_t bPiccErrCode = 0;
uint8_t aPICCError[2];
uint8_t bPiccErrLen = 0;

uint8_t aMFUL_Password[4];
uint8_t aMFUL_Pack[2];

uint8_t aTMC[4];
uint8_t aTMV[8];
uint8_t aTMI[256];
uint8_t bTMI_Len = 0;
uint8_t aEncTMRI[16];

uint8_t aHostAuthKey[] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

uint8_t aDESFire4Key[] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
uint8_t aDESFire4Key1[] = { 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08 };

uint8_t aAESKey[] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
uint8_t aAESKey1[] = { 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10 };

uint8_t aClassicKey[] = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0x80, 0x69, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF };

uint8_t aPLKey[] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
uint8_t aPLUploadKey[] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F };
uint8_t aOfflineUploadKey[] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

uint8_t aMFUL_2K3DES_Key[] = { 0x49, 0x45, 0x4D, 0x4B, 0x41, 0x45, 0x52, 0x42, 0x21, 0x4E, 0x41, 0x43, 0x55, 0x4F, 0x59, 0x46 };
uint8_t aMFUL_AES_Key[] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

uint8_t aDivInput[] = { 0xA7, 0x38, 0x73, 0xBF, 0x58, 0x0A, 0x6C, 0x60, 0x4D, 0x3D, 0x16, 0x46, 0x0F, 0x80, 0xC0, 0xBD,
                                            0x0D, 0x78, 0x48, 0xDA, 0x67, 0xCF, 0x87, 0xDA, 0x83, 0x79, 0x00, 0xC5, 0xEB, 0xE5, 0x32 };

uint8_t PICC_DF_NAME_DFL[] = { 0xD2, 0x76, 0x00, 0x00, 0x85, 0x01, 0x00 };
uint8_t APP_DF_NAME_DFL[] = { 0xA0, 0x00, 0x00, 0x03, 0x96, 0x56, 0x43, 0x41, 0x03, 0xF0, 0x15, 0x40, 0x00, 0x00, 0x00, 0x0B };
uint8_t APP_ISO_FILE_ID_DFL[] = { 0x01, 0xDF };
uint8_t STD_DATA_FILE_256_DFL = 0x00;
uint8_t TMAC_FILE_DFL = 0x0F;

uint8_t PICC_DF_NAME_NTAG42X[] = { 0xD2, 0x76, 0x00, 0x00, 0x85, 0x01, 0x00 };
uint8_t APP_DF_NAME_NTAG42X[] = { 0xD2, 0x76, 0x00, 0x00, 0x85, 0x01, 0x01 };
uint8_t APP_ISO_FILE_ID_NTAG42X[] = { 0x10, 0xE1 };
uint8_t STD_DATA_FILE_256_NTAG42X = 0x02;
uint8_t aPICCDataOffset[3] = { 0x00, 0x00, 0x00 };
uint8_t aSDMMACInputOffset[3] = { 0x00, 0x00, 0x00 };
uint8_t aSDMENCOffset[3] = { 0x60, 0x00, 0x00 };
uint8_t aSDMENCLen[3] = { 0x20, 0x00, 0x00 };
uint8_t aSDMMACOffset[3] = { 0xF0, 0x00, 0x00 };
uint8_t aSDMReadCtrLimit[3] = { 0xFF, 0xFF, 0xFF };
uint8_t aSDMReadCtr[3] = { 0x00, 0x00, 0x00 };

void PrintData ( uint8_t* pBuffer, uint32_t dwLength, char* pFormat, char* pSpecialChar );
phStatus_t IncludeDemo_Version ( uint8_t bSamVer );
phStatus_t IncludeDemo_Reader ( enum ReaderMode eMode );
void Reverse ( uint8_t * pData, uint16_t wLength );
void ConvertAscii_Hex ( uint8_t * pInput, uint32_t dwInLen, uint8_t * pOutString );

phStatus_t ActivateCard ( uint8_t bIsoLayer );

phStatus_t MFD_Format ();
phStatus_t MFD_Authenticate ( uint8_t bAuthType, uint8_t bKeyNo, uint8_t bKeyVer );
phStatus_t MFD_ChangeKey ( uint8_t bCurKeyNo, uint8_t bCurKeyVer, uint8_t bNewKeyNo, uint8_t bNewKeyVer );
phStatus_t MFD_GetVersion ();
phStatus_t MFD_CreateSelectApplication ( uint8_t bKeyType, uint8_t * pAID );
phStatus_t MFD_CreateFile ();
phStatus_t MFD_Write ();
phStatus_t MFD_Read ();

phStatus_t PRIME_TMAC ( uint8_t bAuthType );
phStatus_t PRIME_SDM ( uint8_t bAuthType );
phStatus_t PRIME_Iso7816Wrap ( uint8_t bLePresent, uint8_t * pPlainData, uint16_t * pDataLen );
phStatus_t PRIME_ISOSelect ( uint8_t* pISOFileID, uint8_t bISOFileID_Len, uint8_t* pDFName, uint8_t bDFName_Len, uint8_t bSelector );
phStatus_t PRIME_Authenticate ( uint8_t bAuthType, uint8_t bKeyNoCard, uint8_t bKeyNo, uint8_t bKeyVer );
phStatus_t PRIME_Write ();
phStatus_t PRIME_Read ( uint8_t bFileNo );
phStatus_t PRIME_CommitReaderID ();
phStatus_t PRIME_DecryptReaderID ( uint8_t bAuthType );
phStatus_t PRIME_CommitTransaction ();
phStatus_t PRIME_CalculateTMV ( uint8_t bAuthType );
phStatus_t PRIME_ChangeFileSettings ( uint8_t bType );
phStatus_t PRIME_DecryptSDMPICCData ( uint8_t bAuthType );
phStatus_t PRIME_DecryptSDMENCFileData ( uint8_t bAuthType );
phStatus_t PRIME_CalculateSDMMAC ( uint8_t bAuthType );

phStatus_t MFP_Authenticate ( uint8_t bSMMode, uint8_t bKeyNo, uint8_t bKeyVer );
phStatus_t MFP_ChangeKey ( uint8_t bKeyNo, uint8_t bKeyVer );
phStatus_t MFP_Write ();
phStatus_t MFP_Read ( uint8_t bCmdType );

phStatus_t MFC_Authenticate ();
phStatus_t MFC_Write ();
phStatus_t MFC_Read ();

phStatus_t MFUL_Authenticate ( uint8_t bULCProduct );
phStatus_t MFUL_UpdateDiversifiedPassword ();
phStatus_t MFUL_RevertPassword ();

phStatus_t ICODE_AuthenticateTAM ();
phStatus_t ICODE_AuthenticateMAM ();

phStatus_t PL_DetectFileSize ( FILE ** ppFile, uint16_t * pFileSize );
phStatus_t PL_ExtractPLCode ( FILE ** ppFile, uint8_t * pPLCode, uint16_t * pPLCodeLen );

phStatus_t Demo_HostAuthentication ();
phStatus_t Demo_LockUnlock ();

phStatus_t Demo_GetVersion ();
phStatus_t Demo_ActivateOfflineKey ();
phStatus_t Demo_LoadInitVector ();
phStatus_t Demo_KillAuthentication ();
phStatus_t Demo_SelectApplication ();
phStatus_t Demo_GetRandom ();
phStatus_t Demo_Sleep ();

phStatus_t Demo_GetKeyEntry ( uint8_t bKeyNo, uint8_t bDisplayContents );
phStatus_t Demo_ChangeKeyEntry ( uint8_t bKeyNo, uint8_t bKeyType, uint8_t bKeyClass, uint8_t *pKey, uint32_t dwKeyLen, uint8_t bDisplayContents );
phStatus_t Demo_GetKUCEntry ( uint8_t bDisplayContents );
phStatus_t Demo_ChangeKUCEntry ();
phStatus_t Demo_DumpSessionKey ();
phStatus_t Demo_DumpSecretKey ();
phStatus_t Demo_GenerateVerifyMAC ();
phStatus_t Demo_EncipherDecipherData ();
phStatus_t Demo_EncipherDecipherDataOffline ();

phStatus_t Demo_MIFARE_DESFireEV2 ();
phStatus_t Demo_MIFARE_PlusEV1 ();
phStatus_t Demo_MIFARE_Classic ();
phStatus_t Demo_MIFARE_Ultralight ();
phStatus_t Demo_ISO_IEC29167 ();
phStatus_t Demo_TransactionMAC ( uint32_t dwFeature );
phStatus_t Demo_SecureDynamicMessaging ( uint32_t dwFeature );

phStatus_t Demo_ProgrammableLogic ();

#endif /* PH_EXAMPLE_RD71X_SAMAV3_H */
