/*
 * Copyright 2013 - 2018, 2020, 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Example Source for MIFARE Plus EVx.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef EXAMPLE_MFPEVX_H
#define EXAMPLE_MFPEVX_H

/* Reader Library Headers. */
#include <phbalReg.h>
#include <phhalHw.h>

#include <phpalI14443p3a.h>
#include <phpalI14443p4a.h>
#include <phpalI14443p4.h>
#include <phCidManager.h>

#include <phKeyStore.h>
#include <phCryptoRng.h>
#include <phCryptoSym.h>
#include <phCryptoASym.h>

#include <phpalMifare.h>
#include <phalMfpEVx.h>
#include <phalVca.h>
#include "../../intfs/phTMIUtils.h"

/* Standard Header. */
#include <crtdbg.h>
#include <memory.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>

/* Macros for various EEProm memory size for MFPEv1. ---------------------------------------------------------- */
#define EEPROM_2KB                              0x00U   /**< 2kB EEProm memory size */
#define EEPROM_4KB                              0x01U   /**< 4kB EEProm memory size */

/* Macros for switching between ISO14443 layer 3 or layer 4. ---------------------------------------------------*/
#define ISO14443_L3                             0x00    /* Option for ISO14443 Layer 3 protocol. */
#define ISO14443_L4                             0x01    /* Option for ISO14443 Layer 4 protocol. */

#define MIFARE_KEYTYPE_A                        0x0A    /**< MIFARE KeyType for key A. */
#define MIFARE_KEYTYPE_B                        0x0B    /**< MIFARE KeyType for key B. */

#define ENCRYPTED_OFF                           0x00    /**< Plain */
#define ENCRYPTED_ON                            0x01    /**< Encrypted */
#define MAC_RESPONSE_OFF                        0x00    /**< No MAC on response */
#define MAC_RESPONSE_ON                         0x01    /**< MAC on response */
#define MAC_COMMAND_OFF                         0x00    /**< No MAC on command*/
#define MAC_COMMAND_ON                          0x01    /**< MAC on command ON*/

#define FOLLOWING_AUTH                          0x00    /**< Following Authentication */
#define FIRST_AUTH                              0x01    /**< First Authentication */

#define SECURITY_LEVEL_0                        0x01    /* Option for Security level 0. */
#define SECURITY_LEVEL_1                        0x02    /* Option for Security level 1. */
#define SECURITY_LEVEL_3                        0x04    /* Option for Security level 3. */

#define SECURITY_LEVEL_1_MIFARE                 0x00    /* Option for MIFARE mode in Security level 1. */
#define SECURITY_LEVEL_1_MFP                    0x01    /* Option for MFP mode in Security level 1. */
#define SECURITY_LEVEL_3_MFP                    0x02    /* Option for MFP mode in Security level 1. */

#define VCA_AUTH_RND_LEN                        36      /* Size of the Virtual Card and Proximity Check Random numbers */

#define EV0_SECURE_MESSAGING                    0x00
#define EV1_SECURE_MESSAGING                    0x01

#define PCSC_READER_NO_SAM_NAME "NXP Pegoda N CL 0 0"   /* Pegoda 2 reader name with no SAM support. */

/* PICC key address. -------------------------------------------------------------------------------------------*/
#define CARD_MASTER_KEY                         0x9000  /* Card Master key address */
#define CARD_CONFIGURATION_KEY                  0x9001  /* Card Configuration key address */
#define LEVEL_3_SWITCH_KEY                      0x9003  /* Level 3 Switch key address */
#define SL_1_CARD_AUTHENTICATION_KEY            0x9004  /* SL1 Card Authentication key address */
#define LEVEL_3_SECTOR_SWITCH_KEY               0x9006  /* Level 3 Sector Switch key address */
#define L1_L3_MIX_SECTOR_SWITCH_KEY             0x9007  /* Level 1, Level 3 Mix Sector Switch key address */

#define VC_PROXIMITY_KEY                        0xA001  /* Proximity key address.*/
#define VC_SELECT_ENC_KEY                       0xA080  /* VC Select key address for encryption. */
#define VC_SELECT_MAC_KEY                       0xA081  /* VC Select key address for MACing. */

#define ORIGINALITY_KEY_1                       0x8000  /* Originality key 1. */

#define MFP_CONFIGURATION_BLOCK                 0xB000  /* MFP Configuration Block address */
#define VCIID                                   0xB001  /* Virtual Card InstallationIdentifier. */
#define ATSBLOCK                                0xB002  /* ATS Block address */
#define FIELD_CONFIGURATION_BLOCK               0xB003  /* Field Configuration Block address */
#define ANTI_TEARING_CONFIGURATION_BLOCK        0xB004  /* Anti-Tearing Configuration Block address */

#define TMAC_KEY_1                              0xC000  /* TMAC key 1.*/
#define TMAC_CONFIG_KEY_1                       0xC001  /* TMAC configuration key 1.*/
#define TMAC_BLOCK_1                            0xC002  /* TMAC block 1. */
#define TMAC_COMMIT_READER_ID_1                 0xC003  /* TMAC commit reader ID block 1.*/
#define TMAC_CONFIG_BLOCK_1_0                   0xC004  /* TMAC config block 1.0 */
#define TMAC_CONFIG_BLOCK_1_1                   0xC005  /* TMAC config block 1.1 */

#define PHYSICAL_AES_START_ADDRESS              0x4000  /* Physical start address of AES key location */

/* Software KeyStore key address location. ---------------------------------------------------------------------*/
#define CARD_MASTER_KEY_ADDRESS                 0x00    /* Card Master key address in KeyStore */
#define CARD_MASTER_KEY_VERSION                 0x00    /* Card Master key version in KeyStore */

#define CARD_CONFIGURATION_KEY_ADDRESS          0x01    /* Card Configuration key address in KeyStore */
#define CARD_CONFIGURATION_KEY_VERSION          0x00    /* Card Configuration key version in KeyStore */

#define LEVEL_3_SWITCH_KEY_ADDRESS              0x02    /* Level 3 Switch key address in KeyStore */
#define LEVEL_3_SWITCH_KEY_VERSION              0x00    /* Level 3 Switch key version in KeyStore */

#define SL_1_CARD_AUTH_KEY_ADDRESS              0x03    /* Security Level 1 card auth key address in KeyStore */
#define SL_1_CARD_AUTH_KEY_VERSION              0x00    /* Security Level 1 card auth key version in KeyStore */

#define LEVEL_3_SECTOR_SWITCH_KEY_ADDRESS       0x04    /* Level 3 sector switch key address in KeyStore */
#define LEVEL_3_SECTOR_SWITCH_KEY_VERSION       0x00    /* Level 3 sector switch key version in KeyStore */

#define L1_L3_MIX_SECTOR_SWITCH_KEY_ADDRESS     0x05    /* Level 1, Level 3 mix sector switch key address in KeyStore */
#define L1_L3_MIX_SECTOR_SWITCH_KEY_VERSION     0x00    /* Level 1, Level 3 mix sector switch key version in KeyStore */

#define IC_UPGRADE_KEY_ADDRESS                  0x06    /* IC Upgrade key address in KeyStore */
#define IC_UPGRADE_KEY_VERSION                  0x00    /* IC Upgrade key version in KeyStore */

#define VC_PROXIMITY_KEY_ADDRESS                0x07    /* VC Proximity key address in KeyStore */
#define VC_PROXIMITY_KEY_VERSION                0x00    /* VC Proximity key version in KeyStore */

#define VC_SELECT_ENC_KEY_ADDRESS               0x08    /* VC Select ENC key address in KeyStore */
#define VC_SELECT_ENC_KEY_VERSION               0x00    /* VC Select ENC key version in KeyStore */

#define VC_SELECT_MAC_KEY_ADDRESS               0x09    /* VC Select MAC key address in KeyStore */
#define VC_SELECT_MAC_KEY_VERSION               0x00    /* VC Select MAC key version in KeyStore */

#define TMAC_KEY_1_ADDRESS                      0x0A    /* TMAC key 1 address in KeyStore */
#define TMAC_KEY_1_VERSION                      0x00    /* TMAC key 1 version in KeyStore */

#define TMAC_CONFIG_KEY_1_ADDRESS               0x0B    /* TMAC configuration key 1 address in KeyStore */
#define TMAC_CONFIG_KEY_1_VERSION               0x00    /* TMAC configuration key 1 version in KeyStore */

#define ORIGINALITY_KEY_1_ADDRESS               0x0C    /* Originality key 1 address in KeyStore */
#define ORIGINALITY_KEY_1_VERSION               0x00    /* Originality key 1 version in KeyStore */

#define MIFARE_KEY_ADDRESS_FF                   0x0D    /* MIFARE key address in KeyStore */
#define MIFARE_KEY_VERSION_FF                   0x00    /* MIFARE key version in KeyStore */

#define AES_KEY_ADDRESS                         0x0E    /* AES key address in KeyStore */
#define AES_KEY_VERSION                         0x00    /* AES key version in KeyStore */

#define CHECK_SUCCESS(Status)                                                                           \
if ((Status) != PH_ERR_SUCCESS)                                                                         \
{                                                                                                       \
    printf("\n\n");                                                                                     \
    printf("An error occurred: (0x%04X)\n", (Status));                                                  \
    printf("Pressing any key will exit the demo.\n");                                                   \
    _getch();                                                                                           \
    return 0;                                                                                           \
}

#define CHECK_SUCCESS_BREAK(Status)                                                                     \
    if ( (Status) != PH_ERR_SUCCESS )                                                                   \
    {                                                                                                   \
        printf ( "\n\n" );                                                                              \
        printf ( "An error occurred: (0x%04X)\n", (Status) );                                           \
                                                                                                        \
        break;                                                                                          \
    }

#define EXIT_IF_REQUESTED(Option) if ( ( (Option) == 'x' ) || ( (Option) == 'X' ) )  exit ( 0 );

#define UNUSED_VARIABLE(x)  {for( ( x ) = ( x ) ; ( x ) != ( x ) ; );}
#define UNUSED_ARRAY(x)  {for( ( (x)[0] ) = ( (x)[0] ) ; ( (x)[0] ) != ( (x)[0] ) ; );}

enum ReaderMode { NONE = 0, RD70X, RD710, SIMULATOR };
enum Demo
{
    PERSONALIZATION = 1, SL1_MFC, SL1_MFC_TMAC, SL1_SL3_MIXED, SL1_MFP_TMAC, SL3_SWITCH, SL3_EV0_SM, SL3_EV1_SM, SL3_TMAC,
    SL1_SL3_ISO7816, SL1_SL3_ISO7816_EXTENDED, ORIGINALITY_CHECK, GET_VERSION, VIRTUAL_CARD, PROXIMITY_CHECK,
    UID_PERSONALIZATION, TEARING_PROOF_TRANSFER, MULIPLE_BLOCK_READ
};

/* PICC and software KeyStore key values. ----------------------------------------------------------------------*/
uint8_t gaCardMasterKey[]               = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
uint8_t gaCardConfigKey[]               = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
uint8_t gaLevel3SwitchKey[]             = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
uint8_t gaSL1CardAuthKey[]              = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
uint8_t gaLevel3SectorSwitchKey[]       = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
uint8_t gaLevel13SMixSectorSwitchKey[]  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
uint8_t gaIcUpgradeKey[]                = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

uint8_t gaVcProximityKey[]              = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
uint8_t gaVcSelectEncKey[]              = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
uint8_t gaVcSelectMacKey[]              = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

uint8_t gaMfpCongifBlock[]              = { 0x00, 0x0F, 0x00, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
uint8_t gaVCIID[]                       = { 0xA0, 0x00, 0x00, 0x03, 0x96, 0x56, 0x43, 0x41, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF };
uint8_t gaATSBlock[]                    = { 0x0C, 0x78, 0x77, 0x80, 0x02, 0xC1, 0x05, 0x2F, 0x2F, 0x01, 0xBC, 0xD6, 0x00, 0x00, 0x32, 0xBF };
uint8_t gaFieldConfigBlock[]            = { 0x00, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
uint8_t gaAntiTearingConfigBlock[]      = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF };

uint8_t gaTMAC_Key_1[]                  = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
uint8_t gaTMAC_ConfigKey_1[]            = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
uint8_t gaTMAC_Block_1[]                = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
uint8_t gaTMAC_Commit_Reader_ID_1[]     = { 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01 };
uint8_t gaTMAC_Config_Block_1_0[]       = { 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

uint8_t gaMifare_SectorKey_FF[]         = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0x80, 0x69, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF };
uint8_t gaAES_SectorKey_FF[]            = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

/* These values are with respect to the simulator. If card is used then these values should be changed. */
uint8_t gaOriginalityKey1[]             = { 0x8D, 0xDF, 0xF1, 0x51, 0xA6, 0xEF, 0x6A, 0x7F, 0xE6, 0xD0, 0x33, 0x3A, 0x42, 0xBE, 0x21, 0xEE };

uint8_t gaValueBlock[]                  = { 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF };

/* Public Key */
uint8_t gaPublicKey[]                   = { 0x04, 0x44, 0x09, 0xAD, 0xC4, 0x2F, 0x91, 0xA8, 0x39, 0x40, 0x66, 0xBA, 0x83, 0xD8, 0x72, 0xFB,
                                            0x1D, 0x16, 0x80, 0x37, 0x34, 0xE9, 0x11, 0x17, 0x04, 0x12, 0xDD, 0xF8, 0xBA, 0xD1, 0xA4, 0xDA,
                                            0xDF, 0xD0, 0x41, 0x62, 0x91, 0xAF, 0xE1, 0xC7, 0x48, 0x25, 0x39, 0x25, 0xDA, 0x39, 0xA5, 0xF3,
                                            0x9A, 0x1C, 0x55, 0x7F, 0xFA, 0xCD, 0x34, 0xC6, 0x2E };

/* Context for RdLib components. -------------------------------------------------------------------------------*/
void* pHal_Generic;                                 /* Pointer for Hal component to be assigned. */

phpalI14443p3a_Sw_DataParams_t stI14443p3a;         /* PAL-ISO14443P3A parameter structure */
phpalI14443p4a_Sw_DataParams_t stI14443p4a;         /* PAL-ISO14443P4A parameter structure */
phpalI14443p4_Sw_DataParams_t stI14443p4;           /* ISO14443-4 parameter structure */

phKeyStore_Sw_DataParams_t stKeyStore;              /* KeyStore parameter structure */
phCryptoASym_mBedTLS_DataParams_t stCryptoASym;     /* Crypto parameter structure for ASymmetric operations */

phpalMifare_Sw_DataParams_t stMifare;               /* PAL-MIFARE parameter structure */
phalMfpEVx_Sw_DataParams_t stMfpEVx;                /* MIFARE Plus EVX parameter structure */
phalVca_Sw_DataParams_t stVca;                      /* VCA Software parameter structure */

phTMIUtils_t stTMI;                                 /* TMIUtils parameter structure. */

uint8_t bIsEnggSample = 0;                          /* Variable to identify whether the card used is of engineering sample or final card. */
uint8_t bSimState = 0;
uint8_t bCurrentSecurityLevel = SECURITY_LEVEL_0;   /* Current security level of the card. */
uint8_t bEEPROMSize = EEPROM_2KB;                   /* EEPROM size. */
uint8_t bUid_Len     = 0;                           /* Length of the UID received. */
uint32_t dwTMC       = 0;

uint8_t bSak;                                       /* Select Acknowledge data */
uint8_t aUid[10];                                   /* Complete UID, 4, 7, 10 byte . */
uint8_t aPcdCap2In[6];                              /* PCDCapsIn[0], 0x00: EV0 Secure messaging, 0x01: EV1 secure messaging. */
uint8_t aPcdCap2Out[6];                             /* Pointer to PCDCaps sent from the card (6 bytes). */
uint8_t aPdCap2[6];                                 /* Pointer to PDCaps. (6 bytes) */
uint8_t aTMC[4];
uint8_t aTMV[8];
uint8_t aRx_Data[16];

uint16_t aSectorNo[]    = { 0x4001, 0x4003 };
uint16_t aKeyB_Key[]    = { AES_KEY_ADDRESS, AES_KEY_ADDRESS };
uint16_t aKeyB_Ver[]    = { AES_KEY_VERSION, AES_KEY_VERSION };

phStatus_t RestoreToSL0 ();
phStatus_t UpdateKeystore ();
phStatus_t UpdateEEPROM_Size ();
uint8_t GetNumberofSectors ();
phStatus_t SetSecurityLevel ();
phStatus_t UpdateTMC ( uint8_t bSecurityLevel );
phStatus_t ActivateCard ( uint8_t bIsoLayer );
phStatus_t IncludeDemo ( uint8_t bSecurityLevel );
phStatus_t GetAESSectorBlock_A ( uint16_t wSectorNr );
phStatus_t GetAESSectorBlock_B ( uint16_t wSectorNr );
phStatus_t ResetCommitReaderIDBlock ( uint8_t bSecurityLevel );
phStatus_t ConfigureTmProtectedBlock ( uint8_t bBlockNo, uint8_t bSecurityLevel );
phStatus_t ConfigureValueBlock ( uint8_t bBlockNo, uint8_t bSecurityLevel, uint8_t bISOLayer );

phStatus_t Demo_GetVersion ( uint8_t bSecurityLevel );
phStatus_t Demo_TransactionMAC ( uint8_t bSecurityLevel );
phStatus_t Demo_OriginalityCheck ( uint8_t bSecurityLevel );
phStatus_t Demo_PrePersonalization ( uint8_t bISOLayer, uint8_t bSwitch_SL3 );
phStatus_t Demo_SecurityLayer ( uint8_t bSecurityLevel, uint8_t bISOLayer, uint8_t bSecureMessaging, uint8_t bPrepersonalize );
phStatus_t Demo_ISO7816 ( uint8_t bSecurityLevel, uint8_t bISOLayer, uint8_t bSecureMessaging, uint8_t bExtended );
phStatus_t Demo_VirtualCardDemo ();
phStatus_t Demo_ProximityCheck ();
phStatus_t Demo_UidPersonalization ();
phStatus_t Demo_TearingProofTransfer ();
phStatus_t Demo_MultipleBlocksRead ( uint8_t bSecurityLevel, uint8_t bSecureMessaging, uint8_t bPrepersonalize );

void PrintData ( uint8_t * pBuffer, uint32_t dwLength, char* pFormat, char* pSpecialChar );
void MfpEv1_Log ( void* pDataParams, uint8_t bOption, phLog_LogEntry_t* pEntries, uint16_t wEntryCount );

#endif /* EXAMPLE_MFPEVX_H */
