/*
 * Copyright 2013, 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Example source for CryptoLibFootPrint that demonstrates Random number generation,
 * Symmetric Crypto and ASymmetric Crypto operation.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

/** Header for this file */
#include "Example-CryptoLibFootprint.h"

#ifdef NXPBUILD__PH_CRYPTORNG
#include "Example-CryptoLibFootprint_RND.h"
#endif /* NXPBUILD__PH_CRYPTORNG */

#ifdef NXPBUILD__PH_CRYPTOSYM
#include "Example-CryptoLibFootprint_Sym.h"
#endif /* NXPBUILD__PH_CRYPTOSYM */

#ifdef NXPBUILD__PH_CRYPTOASYM
#include "Example-CryptoLibFootprint_ASym.h"
#endif /* NXPBUILD__PH_CRYPTOASYM */

void * pKeyStore = NULL;

int __cdecl main()
{
    /* Generic Variables */
    uint32_t dwChoice = 0;
    char aChoice[5];

    /* Initialize Logging. */
#ifdef NXPBUILD__PH_LOG
    CHECK_SUCCESS(phLog_Init(CryptoLibFootPrint_Log, aLogRegisterEntries, (uint16_t) (sizeof(aLogRegisterEntries) / sizeof(phLog_RegisterEntry_t))), TRUE);
#endif /* NXPBUILD__PH_LOG */

#ifdef NXPBUILD__PH_KEYSTORE_SW
    /* Initialize software KeyStore component. */
    CHECK_SUCCESS(phKeyStore_Sw_Init(&stKeyStore_Sw, sizeof(stKeyStore_Sw), aKeyEntry, KEY_ENTRIES, aKeyVersion, 2,
        aKeyUsageCounter, KEY_USAGE_COUNTER), TRUE);

    pKeyStore = &stKeyStore_Sw;
#endif /* NXPBUILD__PH_KEYSTORE_SW */

    /* Initialize KeyStore component for logging. */
#ifdef NXPBUILD__PH_LOG
    CHECK_SUCCESS(phLog_Register(pKeyStore, aLogEntries, (uint16_t) (sizeof(aLogEntries) / sizeof(phLog_LogEntry_t))), TRUE);
#endif /* NXPBUILD__PH_LOG */

    do
    {
        dwChoice = 0;

        /* Clear the console. */
        system("cls");

        if((uint8_t) FEATURE_MAX > 2U)
        {
#ifdef NXPBUILD__PH_CRYPTORNG
            printf("Press %d to demonstrate Random number functionality. \n", RANDOM_NUMBER);
#endif /* NXPBUILD__PH_CRYPTORNG */

#ifdef NXPBUILD__PH_CRYPTOSYM
            printf("Press %d to demonstrate Symmetric Crypto functionality. \n", SYMMETRIC_CRYPTO);
#endif /* NXPBUILD__PH_CRYPTOSYM */

#ifdef NXPBUILD__PH_CRYPTOASYM
            printf("Press %d to demonstrate ASymmetric Crypto functionality. \n", ASYMMETRIC_CRYPTO);
#endif /* NXPBUILD__PH_CRYPTOASYM */

            printf("\n");
            printf("Press x to exit the application.\n");
            printf("Enter the option and press Enter to perform the demo - ");
            scanf("%s", aChoice);
        }
        else
        {
            dwChoice = 1;
        }

        /* Convert to Integer value. */
        ToInt(aChoice, dwChoice);

        printf("\n\n");

        /* Exit if requested by user. */
        EXIT_IF_REQUESTED(dwChoice);

        switch(dwChoice)
        {
#ifdef NXPBUILD__PH_CRYPTORNG
            case RANDOM_NUMBER:
                CHECK_SUCCESS(Demo_RandomNumber_Main(), TRUE);
                break;
#endif /* NXPBUILD__PH_CRYPTORNG */

#ifdef NXPBUILD__PH_CRYPTOSYM
            case SYMMETRIC_CRYPTO:
                CHECK_SUCCESS(Demo_SymmetricCrypto_Main(), TRUE);
                break;
#endif /* NXPBUILD__PH_CRYPTOSYM */

#ifdef NXPBUILD__PH_CRYPTOASYM
            case ASYMMETRIC_CRYPTO:
                CHECK_SUCCESS(Demo_ASymmetricCrypto_Main(), TRUE);
                break;
#endif /* NXPBUILD__PH_CRYPTOASYM */

            default:
                printf("Invalid option selected.\n");

                printf("--------------------------------------------------------------------------------------------------- \n");
                printf("\n\n");
                printf("Press any key to continue with the demonstration.\n");
                printf("Press r to return to previous demo description.\n");
                printf("Press x to exit the demonstration.\n");
                dwChoice = _getch();
                break;
        }
    } while((dwChoice != 'x') && (dwChoice != 'X'));

    return 0;
}

void PrintASCII(uint8_t * pBuffer, uint16_t wBuffLen, uint8_t bRemoveNullChar)
{
    uint16_t wITeration = 0;
    printf("\t               ASCII: ");

    /* Null Character Removed. */
    if(bRemoveNullChar)
        --wBuffLen;

    for(wITeration = 0; wITeration < wBuffLen; wITeration++)
    {
        printf("%c", pBuffer[wITeration]);

        if(pBuffer[wITeration] == 0x0A)
            printf("\t                      ");
    }

    printf("\n");
}

void PrintHEX(uint8_t * pBuffer, uint16_t wBuffLen)
{
    uint16_t wITeration = 0;

    printf("\t                 HEX: ");

    for(wITeration = 0; wITeration < wBuffLen; wITeration++)
    {
        printf("%02X ", pBuffer[wITeration]);

        if(pBuffer[wITeration] == 0x0A)
            printf("\t                      ");
    }

    printf("\n");
}

void PrintData(uint8_t* pBuffer, uint32_t dwLength, char* pFormat, char* pSpecialChar)
{
    uint32_t dwSplit_Count = 32;
    uint32_t dwIndex1 = 0;
    uint32_t dwIndex2 = 0;

    for(dwIndex1 = 0; dwIndex1 < dwLength; dwIndex1++)
    {
        printf(pFormat, pBuffer[dwIndex1]);

        dwIndex2++;
        if(dwIndex2 > dwSplit_Count)
        {
            printf("\n\t                      ");
            dwIndex2 = 0;
        }
    }

    printf(pSpecialChar);
}

phStatus_t DispalyAddStatus(void * pDataParams, phStatus_t wStatus)
{
    int32_t dwStatusCode = 0;
    int8_t aStatusMsg[256];
    uint16_t wStatusMsgLen = (uint16_t) sizeof(aStatusMsg);

    if((wStatus & PH_ERR_MASK) != PH_ERR_SUCCESS)
    {
        printf("\n\n");
        printf("An error occurred: (0x%04X)\n", wStatus);
        if((wStatus & PH_ERR_MASK) == PH_ERR_INTERNAL_ERROR)
        {
            phCryptoSym_GetLastStatus(pDataParams, wStatusMsgLen, aStatusMsg, &dwStatusCode);
            printf("\n");
            printf("Additional Info ");
            printf("\tStatusCode    : %d", dwStatusCode);
            printf("\tStatus Message: %s", aStatusMsg);
        }
        return wStatus;
    }

    return PH_ERR_SUCCESS;
}

/* Logging function. */
#ifdef NXPBUILD__PH_LOG
void CryptoLibFootPrint_Log(void* pDataParams, uint8_t bOption, phLog_LogEntry_t* pEntries, uint16_t wEntryCount)
{
    uint16_t wIteration;
    PH_UNUSED_VARIABLE(bOption);
    PH_UNUSED_VARIABLE(pDataParams);

    for(wIteration = 0; wIteration < wEntryCount; wIteration++)
    {
        if(wIteration != 0)
        {
            printf("%s : ", pEntries[wIteration].pString);
        }
        else
        {
            printf("-----------------------------------------\n");
            printf("%s\n", pEntries[0].pString);
            printf("-----------------------------------------\n");
        }
        if(pEntries[wIteration].wDataLen != 0)
            PrintData((uint8_t *) (pEntries[wIteration].pData), pEntries[wIteration].wDataLen, "%02X ", "\t");
        else
            PrintData((uint8_t *) (pEntries[wIteration].pData), pEntries[wIteration].wDataLen, "%02X ", "");
    }
    printf("\n\n");
}
#endif /* NXPBUILD__PH_LOG */
