/*
 * Copyright 2013, 2015, 2017, 2023 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software ISO15693 Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHPALSLI15693_SW_H
#define PHPALSLI15693_SW_H

#include <ph_Status.h>

#ifdef NXPBUILD__PHPAL_SLI15693_SW

/* ISO15693 Mandatory commands ------------------------------------------------------------------------------------- */
phStatus_t phpalSli15693_Sw_Inventory(phpalSli15693_Sw_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi, uint8_t * pMask,
    uint8_t bMaskBitLen, uint8_t * pDsfid, uint8_t * pUid);

phStatus_t phpalSli15693_Sw_StayQuiet(phpalSli15693_Sw_DataParams_t * pDataParams);





/* ISO15693 Optional commands -------------------------------------------------------------------------------------- */
phStatus_t phpalSli15693_Sw_Select(phpalSli15693_Sw_DataParams_t * pDataParams);

phStatus_t phpalSli15693_Sw_ResetToReady(phpalSli15693_Sw_DataParams_t * pDataParams);





/* ISO15693 Custom commands ---------------------------------------------------------------------------------------- */
phStatus_t phpalSli15693_Sw_InventoryRead(phpalSli15693_Sw_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi, uint8_t * pMask,
    uint8_t bMaskBitLen, uint8_t bBlockNo, uint16_t wNoOfBlocks, uint8_t * pUid, uint8_t * pUidLen, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phpalSli15693_Sw_InventoryReadExtended(phpalSli15693_Sw_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi, uint8_t * pMask,
    uint8_t bMaskBitLen, uint8_t bExtendedOptions, uint8_t * pCID, uint8_t bBlockNo, uint16_t wNumOfBlocks, uint8_t * pCDIDOut, uint8_t * pUid,
    uint8_t * pUidLen, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phpalSli15693_Sw_FastInventoryRead(phpalSli15693_Sw_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi, uint8_t * pMask,
    uint8_t bMaskBitLen, uint8_t bBlockNo, uint16_t wNoOfBlocks, uint8_t * pUid, uint8_t * pUidLen, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phpalSli15693_Sw_FastInventoryReadExtended(phpalSli15693_Sw_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi, uint8_t * pMask,
    uint8_t bMaskBitLen, uint8_t bExtendedOptions, uint8_t * pCID, uint8_t bBlockNo, uint16_t wNumOfBlocks, uint8_t * pCDIDOut, uint8_t * pUid,
    uint8_t * pUidLen, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phpalSli15693_Sw_InventoryPageRead(phpalSli15693_Sw_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi, uint8_t * pMask,
    uint8_t bMaskBitLen, uint8_t bPageNo, uint16_t wNoOfPages, uint8_t * pUid, uint8_t * pUidLen, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phpalSli15693_Sw_FastInventoryPageRead(phpalSli15693_Sw_DataParams_t * pDataParams, uint8_t bFlags, uint8_t bAfi, uint8_t * pMask,
    uint8_t bMaskBitLen, uint8_t bPageNo, uint16_t wNoOfPages, uint8_t * pUid, uint8_t * pUidLen, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phpalSli15693_Sw_StayQuietPersistent(phpalSli15693_Sw_DataParams_t * pDataParams);





/* ISO15693 Common commands ---------------------------------------------------------------------------------------- */
phStatus_t phpalSli15693_Sw_ActivateCard(phpalSli15693_Sw_DataParams_t * pDataParams, uint8_t  bOption, uint8_t bFlags, uint8_t bAfi,
    uint8_t * pMask, uint8_t MaskBitLen, uint8_t * pDsfid, uint8_t * pUid, uint8_t * pMoreCardsAvailable);

phStatus_t phpalSli15693_Sw_SendEof(phpalSli15693_Sw_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pDsfid, uint8_t * pUid,
    uint8_t * pUidLen, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phpalSli15693_Sw_Exchange(phpalSli15693_Sw_DataParams_t * pDataParams, uint16_t wOption, uint8_t * pTxBuffer, uint16_t wTxLen,
    uint8_t ** ppRxBuffer, uint16_t * pRxLen);

#ifdef NXPBUILD__PHPAL_SLI15693_INTERNAL
phStatus_t phpalSli15693_Sw_InProcessReplyASync(phpalSli15693_Sw_DataParams_t * pDataParams, uint8_t * pTxBuffer, uint16_t wTxBuffLen,
    uint8_t * pResponse1, uint16_t * pResp1_Len, uint8_t * pResponse2, uint16_t * pResp2_Len);
#endif /* NXPBUILD__PHPAL_SLI15693_INTERNAL */





/* ISO15693 Utility commands --------------------------------------------------------------------------------------- */
phStatus_t phpalSli15693_Sw_GetSerialNo(phpalSli15693_Sw_DataParams_t * pDataParams, uint8_t * pUid, uint8_t * bUidLen);

phStatus_t phpalSli15693_Sw_SetSerialNo(phpalSli15693_Sw_DataParams_t * pDataParams, uint8_t * pUid, uint8_t bUidLen);

phStatus_t phpalSli15693_Sw_SetConfig(phpalSli15693_Sw_DataParams_t * pDataParams, uint16_t wConfig, uint16_t wValue);

phStatus_t phpalSli15693_Sw_GetConfig(phpalSli15693_Sw_DataParams_t * pDataParams, uint16_t wConfig, uint16_t * pValue);

#endif /* NXPBUILD__PHPAL_SLI15693_SW */

#endif /* PHPALSLI15693_SW_H */
