/*
 * Copyright 2013, 2018, 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software ISO18000-3 Mode3 Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHPALI18000P3M3_SW_INT_H
#define PHPALI18000P3M3_SW_INT_H

#include <ph_Status.h>

/** \addtogroup ph_Private
* @{
*/

/**
* \name Command Codes
*/
/** @{ */
#define PHPAL_I18000P3M3_CMD_SELECT         0x0A    /**< Select command code. */
#define PHPAL_I18000P3M3_CMD_BEGIN_ROUND    0x08    /**< BeginRound command code. */
#define PHPAL_I18000P3M3_CMD_RESIZE_ROUND   0x09    /**< ResizeRound command code. */
#define PHPAL_I18000P3M3_CMD_NEXT_SLOT      0x00    /**< NextSlot command code. */
#define PHPAL_I18000P3M3_CMD_ACK            0x01    /**< ACK command code. */
#define PHPAL_I18000P3M3_CMD_NAK            0xC0    /**< NAK command code. */
/** @} */

/**
* \name Timeout constants
*/
/** @{ */
#define PHPAL_I18000P3M3_SW_T1_MAX_US   78U
#define PHPAL_I18000P3M3_SW_T2_MIN_US   151U
#define PHPAL_I18000P3M3_SW_T3_MIN_US   25U
#define PHPAL_I18000P3M3_SW_T4_MIN_US   100U
#define PHPAL_I18000P3M3_SW_DELTA_MIN_US   10U
/** @} */

/**
* end of ph_Private
* @}
*/

#endif /* PHPALI18000P3M3_SW_INT_H_ */
