/*
 * Copyright 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Callback ISO14443-4 layer of Reader Library.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <phpalI14443p4.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHPAL_I14443P4_CALLBACK

#include "phpalI14443p4_Callback.h"

phStatus_t phpalI14443p4_Callback_Init(
                                            phpalI14443p4_Callback_DataParams_t * pDataParams,
                                            uint16_t wSizeOfDataParams,
                                            cbPalI14443p4_SetProtocol pSetProtocolCb,
                                            cbPalI14443p4_ResetProtocol pResetProtocolCb,
                                            cbPalI14443p4_Deselect pDeselectCb,
                                            cbPalI14443p4_PresCheck pPresCheckCb,
                                            cbPalI14443p4_Exchange pExchangeCb,
                                            cbPalI14443p4_SetConfig pSetConfigCb,
                                            cbPalI14443p4_GetConfig pGetConfigCb,
                                            cbPalI14443p4_SParamFrameFormat pSParamFrameFormatCb,
                                            cbPalI14443p4_SParamBitRates pSParamBitRatesCb,
                                            void * pCbContext
                                   )
{
    if (sizeof(phpalI14443p4_Callback_DataParams_t) != wSizeOfDataParams)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_ISO14443P4);
    }
    PH_ASSERT_NULL (pDataParams);

    /* Initialize private data */
    pDataParams->wId = PH_COMP_PAL_ISO14443P4 | PHPAL_I14443P4_CALLBACK_ID;
    pDataParams->pSetProtocolCb = pSetProtocolCb;
    pDataParams->pResetProtocolCb = pResetProtocolCb;
    pDataParams->pDeselectCb = pDeselectCb;
    pDataParams->pPresCheckCb = pPresCheckCb;
    pDataParams->pExchangeCb = pExchangeCb;
    pDataParams->pSetConfigCb = pSetConfigCb;
    pDataParams->pGetConfigCb = pGetConfigCb;
    pDataParams->pSParamFrameFormatCb = pSParamFrameFormatCb;
    pDataParams->pSParamBitRatesCb = pSParamBitRatesCb;
    pDataParams->pCbContext = pCbContext;

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_PAL_ISO14443P3A);
}

phStatus_t phpalI14443p4_Callback_SetProtocol(
                                          phpalI14443p4_Callback_DataParams_t * pDataParams,
                                          uint8_t   bCidEnable,
                                          uint8_t   bCid,
                                          uint8_t   bNadEnable,
                                          uint8_t   bNad,
                                          uint8_t   bFwi,
                                          uint8_t   bFsdi,
                                          uint8_t   bFsci
                                          )
{
    if (pDataParams->pSetProtocolCb)
    {
        return (*pDataParams->pSetProtocolCb)(bCidEnable, bCid, bNadEnable, bNad, bFwi, bFsdi, bFsci, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P4);
    }
}

phStatus_t phpalI14443p4_Callback_ResetProtocol(
                                            phpalI14443p4_Callback_DataParams_t * pDataParams
                                            )
{
    if (pDataParams->pResetProtocolCb)
    {
        return (*pDataParams->pResetProtocolCb)(pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P4);
    }
}

phStatus_t phpalI14443p4_Callback_Deselect(
                                       phpalI14443p4_Callback_DataParams_t * pDataParams
                                       )
{
    if (pDataParams->pDeselectCb)
    {
        return (*pDataParams->pDeselectCb)(pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P4);
    }
}

phStatus_t phpalI14443p4_Callback_PresCheck(
                                        phpalI14443p4_Callback_DataParams_t * pDataParams
                                        )
{
    if (pDataParams->pPresCheckCb)
    {
        return (*pDataParams->pPresCheckCb)(pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P4);
    }
}

phStatus_t phpalI14443p4_Callback_Exchange(
                                       phpalI14443p4_Callback_DataParams_t * pDataParams,
                                       uint16_t wOption,
                                       uint8_t * pTxBuffer,
                                       uint16_t wTxLength,
                                       uint8_t ** ppRxBuffer,
                                       uint16_t * pRxLength
                                       )
{
    if (pDataParams->pExchangeCb)
    {
        return (*pDataParams->pExchangeCb)(wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P3A);
    }
}

phStatus_t phpalI14443p4_Callback_SetConfig(
                                        phpalI14443p4_Callback_DataParams_t * pDataParams,
                                        uint16_t wConfig,
                                        uint16_t wValue
                                        )
{
    if (pDataParams->pSetConfigCb)
    {
        return (*pDataParams->pSetConfigCb)(wConfig, wValue, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P3A);
    }
}

phStatus_t phpalI14443p4_Callback_GetConfig(
                                        phpalI14443p4_Callback_DataParams_t * pDataParams,
                                        uint16_t wConfig,
                                        uint16_t * pValue
                                        )
{
    if (pDataParams->pGetConfigCb)
    {
        return (*pDataParams->pGetConfigCb)(wConfig, pValue, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P3A);
    }
}

phStatus_t phpalI14443p4_Callback_SParamFrameFormat(
    phpalI14443p4_Callback_DataParams_t * pDataParams,
    uint8_t bMode,
    uint8_t  * pbFramePcd2Picc,
    uint8_t  * pbFramePicc2Pcd,
    uint8_t  * pbFramingOptionsPcd2Picc,
    uint8_t  * pbFramingOptionsPicc2Pcd
)
{
    if (pDataParams->pSParamFrameFormatCb)
    {
        return (*pDataParams->pSParamFrameFormatCb)(bMode, pbFramePcd2Picc, pbFramePicc2Pcd, pbFramingOptionsPcd2Picc, pbFramingOptionsPicc2Pcd, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P3A);
    }
}

phStatus_t phpalI14443p4_Callback_SParamBitRates(
    phpalI14443p4_Callback_DataParams_t * pDataParams,
    uint8_t bMode,
    uint16_t * pwBitRatePcd2Picc,
    uint16_t * pwBitRatePicc2Pcd,
    uint8_t  * pbFramingOptions
)
{
    if (pDataParams->pSParamBitRatesCb)
    {
        return (*pDataParams->pSParamBitRatesCb)(bMode, pwBitRatePcd2Picc, pwBitRatePicc2Pcd, pbFramingOptions, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_PAL_ISO14443P3A);
    }
}

#endif /* NXPBUILD__PHPAL_I14443P4_CALLBACK */
