/*
 * Copyright 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * SAM (AV4 and future SAM's) ISO14443-3A Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7230 $
 * $Date: 2025-03-14 10:27:23 +0530 (Fri, 14 Mar 2025) $
 */

#ifndef PHPALI14443P3A_SAM_X_H
#define PHPALI14443P3A_SAM_X_H

#include <ph_Status.h>

phStatus_t phpalI14443p3a_Sam_X_RequestA(phpalI14443p3a_Sam_X_DataParams_t * pDataParams, uint8_t * pAtqa);

phStatus_t phpalI14443p3a_Sam_X_WakeUpA(phpalI14443p3a_Sam_X_DataParams_t * pDataParams,uint8_t * pAtqa);

phStatus_t phpalI14443p3a_Sam_X_HaltA(phpalI14443p3a_Sam_X_DataParams_t * pDataParams);

phStatus_t phpalI14443p3a_Sam_X_Anticollision(phpalI14443p3a_Sam_X_DataParams_t * pDataParams, uint8_t bCascadeLevel,
    uint8_t * pUidIn, uint8_t bNvbUidIn, uint8_t * pUidOut, uint8_t * pNvbUidOut);

phStatus_t phpalI14443p3a_Sam_X_Select(phpalI14443p3a_Sam_X_DataParams_t * pDataParams, uint8_t bCascadeLevel,
    uint8_t * pUidIn,uint8_t * pSak);

phStatus_t phpalI14443p3a_Sam_X_ActivateCard(phpalI14443p3a_Sam_X_DataParams_t * pDataParams, uint8_t * pUidIn,
    uint8_t bLenUidIn, uint8_t * pUidOut, uint8_t * pLenUidOut, uint8_t * pSak, uint8_t * pMoreCardsAvailable);

phStatus_t phpalI14443p3a_Sam_X_Exchange(phpalI14443p3a_Sam_X_DataParams_t * pDataParams, uint16_t wOption,
    uint8_t * pTxBuffer, uint16_t wTxLength, uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phpalI14443p3a_Sam_X_GetSerialNo(phpalI14443p3a_Sam_X_DataParams_t * pDataParams, uint8_t * pResponse,
    uint8_t * pRespLen);

#endif /* PHPALI14443P3A_SAM_X_H */
