/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Generic HAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <phhalHw.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHHAL_HW_CONTACT_CALLBACK
#include "ContactCallback\phhalHwContact_Callback.h"
#endif  /* NXPBUILD__PHHAL_HW_CONTACT_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS
#include "ContactMicropross\phhalHwContact_Micropross.h"
#endif /* NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT
#include "ContactTransparent\phhalHwContact_Transparent.h"
#endif /* NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR01
#include "ContactRdScr01\phhalHwContact_RdScr01.h"
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR01 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR2
#include "ContactRdScr2\phhalHwContact_RdScr2.h"
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR2 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE
#include "ContactSmartware\phhalHwContact_Smartware.h"
#endif /* NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_KEOLABS
#include "ContactKeolabs\phhalHwContact_Keolabs.h"
#endif /* NXPBUILD__PHHAL_HW_CONTACT_KEOLABS */

#ifdef NXPBUILD__PHHAL_HW

phStatus_t phhalHwContact_Exchange(
                            void * pDataParams,
                            uint16_t wOption,
                            uint8_t * pTxBuffer,
                            uint16_t wTxLength,
                            uint8_t ** ppRxBuffer,
                            uint16_t * pRxLength
                            )
{
    phStatus_t PH_MEMLOC_REM status;
    uint8_t bCompId;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHwContact_Exchange");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wOption);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pTxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(ppRxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bCompId);
    bCompId = PH_GET_COMPID(pDataParams);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bCompId_log, &bCompId);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wOption_log, &wOption);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pTxBuffer_log, pTxBuffer, wTxLength);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);
    if (wTxLength) PH_ASSERT_NULL (pTxBuffer);

    /* Check data parameters */
    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);
        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS
    case PHHAL_HW_CONTACT_MICROPROSS_ID:
        status = phhalHwContact_Micropross_Exchange((phhalHwContact_Micropross_DataParams_t *)pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_CALLBACK
    case PHHAL_HW_CONTACT_CALLBACK_ID:
        status = phhalHwContact_Callback_Exchange((phhalHwContact_Callback_DataParams_t *)pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT
    case PHHAL_HW_CONTACT_TRANSPARENT_ID:
        status = phhalHwContact_Transparent_Exchange((phhalHwContact_Transparent_DataParams_t *)pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR01
    case PHHAL_HW_CONTACT_RDSCR01_ID:
        status = phhalHwContact_RdScr01_Exchange((phhalHwContact_RdScr01_DataParams_t *)pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR01 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR2
    case PHHAL_HW_CONTACT_RDSCR2_ID:
        status = phhalHwContact_RdScr2_Exchange((phhalHwContact_RdScr2_DataParams_t *)pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR2 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE
    case PHHAL_HW_CONTACT_SMARTWARE_ID:
        status = phhalHwContact_Smartware_Exchange((phhalHwContact_Smartware_DataParams_t *)pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_KEOLABS
    case PHHAL_HW_CONTACT_KEOLABS_ID:
        status = phhalHwContact_Keolabs_Exchange((phhalHwContact_Keolabs_DataParams_t *)pDataParams, wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_KEOLABS */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
        break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
#ifdef NXPBUILD__PH_LOG
    if ((((status & PH_ERR_MASK) == PH_ERR_SUCCESS) ||
        ((status & PH_ERR_MASK) == PH_ERR_SUCCESS_CHAINING) ||
        ((status & PH_ERR_MASK) == PH_ERR_SUCCESS_INCOMPLETE_BYTE)) &&
        !(wOption & PH_EXCHANGE_BUFFERED_BIT) &&
        (ppRxBuffer != NULL))
    {
        PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, ppRxBuffer_log, *ppRxBuffer, *pRxLength);
    }
#endif /* NXPBUILD__PH_LOG */
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHwContact_ApplyProtocolSettings(
    void * pDataParams,
    uint8_t * pAtr,
    uint16_t dwAtrLength,
    uint8_t bProtocolType
    )
{
    phStatus_t PH_MEMLOC_REM status;
    uint8_t bCompId;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHwContact_ApplyProtocolSettings");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bProtocolType);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bCompId);
    bCompId = PH_GET_COMPID(pDataParams);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bCompId_log, &bCompId);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bProtocolType_log, &bProtocolType);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    /* Check data parameters */
    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS
    case PHHAL_HW_CONTACT_MICROPROSS_ID:
        status = phhalHwContact_Micropross_ApplyProtocolSettings((phhalHwContact_Micropross_DataParams_t *)pDataParams, pAtr, dwAtrLength, bProtocolType);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_CALLBACK
    case PHHAL_HW_CONTACT_CALLBACK_ID:
        status = phhalHwContact_Callback_ApplyProtocolSettings((phhalHwContact_Callback_DataParams_t *)pDataParams, pAtr, dwAtrLength, bProtocolType);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT
    case PHHAL_HW_CONTACT_TRANSPARENT_ID:
        status = phhalHwContact_Transparent_ApplyProtocolSettings((phhalHwContact_Transparent_DataParams_t *)pDataParams, pAtr, dwAtrLength, bProtocolType);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR01
    case PHHAL_HW_CONTACT_RDSCR01_ID:
        status = phhalHwContact_RdScr01_ApplyProtocolSettings((phhalHwContact_RdScr01_DataParams_t *)pDataParams, pAtr, dwAtrLength, bProtocolType);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR01 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR2
    case PHHAL_HW_CONTACT_RDSCR2_ID:
        status = phhalHwContact_RdScr2_ApplyProtocolSettings((phhalHwContact_RdScr2_DataParams_t *)pDataParams, pAtr, dwAtrLength, bProtocolType);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR2 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE
    case PHHAL_HW_CONTACT_SMARTWARE_ID:
        status = phhalHwContact_Smartware_ApplyProtocolSettings((phhalHwContact_Smartware_DataParams_t *)pDataParams, pAtr, dwAtrLength, bProtocolType);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_KEOLABS
    case PHHAL_HW_CONTACT_KEOLABS_ID:
        status = phhalHwContact_Keolabs_ApplyProtocolSettings((phhalHwContact_Keolabs_DataParams_t *)pDataParams, pAtr, dwAtrLength, bProtocolType);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_KEOLABS */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
        break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHwContact_SetConfig32(
                             void * pDataParams,
                             uint16_t wConfig,
                             uint32_t dwValue
                             )
{
    phStatus_t PH_MEMLOC_REM status;
    uint8_t bCompId;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHwContact_SetConfig32");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wConfig);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(dwValue);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bCompId);
    bCompId = PH_GET_COMPID(pDataParams);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bCompId_log, &bCompId);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wConfig_log, &wConfig);
    PH_LOG_HELPER_ADDPARAM_UINT32(PH_LOG_LOGTYPE_DEBUG, dwValue_log, &dwValue);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    /* Check data parameters */
    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS
    case PHHAL_HW_CONTACT_MICROPROSS_ID:
        status = phhalHwContact_Micropross_SetConfig32((phhalHwContact_Micropross_DataParams_t *)pDataParams, wConfig, dwValue);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_CALLBACK
    case PHHAL_HW_CONTACT_CALLBACK_ID:
        status = phhalHwContact_Callback_SetConfig32((phhalHwContact_Callback_DataParams_t *)pDataParams, wConfig, dwValue);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT
    case PHHAL_HW_CONTACT_TRANSPARENT_ID:
        status = phhalHwContact_Transparent_SetConfig32((phhalHwContact_Transparent_DataParams_t *)pDataParams, wConfig, dwValue);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR01
    case PHHAL_HW_CONTACT_RDSCR01_ID:
        status = phhalHwContact_RdScr01_SetConfig32((phhalHwContact_RdScr01_DataParams_t *)pDataParams, wConfig, dwValue);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR01 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR2
    case PHHAL_HW_CONTACT_RDSCR2_ID:
        status = phhalHwContact_RdScr2_SetConfig32((phhalHwContact_RdScr2_DataParams_t *)pDataParams, wConfig, dwValue);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR2 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE
    case PHHAL_HW_CONTACT_SMARTWARE_ID:
        status = phhalHwContact_Smartware_SetConfig32((phhalHwContact_Smartware_DataParams_t *)pDataParams, wConfig, dwValue);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_KEOLABS
    case PHHAL_HW_CONTACT_KEOLABS_ID:
        status = phhalHwContact_Keolabs_SetConfig32((phhalHwContact_Keolabs_DataParams_t *)pDataParams, wConfig, dwValue);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_KEOLABS */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
        break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}


phStatus_t phhalHwContact_GetConfig32(
                             void * pDataParams,
                             uint16_t wConfig,
                             uint32_t * pValue
                             )
{
    phStatus_t PH_MEMLOC_REM status;
    uint8_t bCompId;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHwContact_GetConfig32");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wConfig);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pValue);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bCompId);
    bCompId = PH_GET_COMPID(pDataParams);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bCompId_log, &bCompId);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wConfig_log, &wConfig);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);
    PH_ASSERT_NULL (pValue);

    /* Check data parameters */
    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS
    case PHHAL_HW_CONTACT_MICROPROSS_ID:
        status = phhalHwContact_Micropross_GetConfig32((phhalHwContact_Micropross_DataParams_t *)pDataParams, wConfig, pValue);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_CALLBACK
    case PHHAL_HW_CONTACT_CALLBACK_ID:
        status = phhalHwContact_Callback_GetConfig32((phhalHwContact_Callback_DataParams_t *)pDataParams, wConfig, pValue);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT
    case PHHAL_HW_CONTACT_TRANSPARENT_ID:
        status = phhalHwContact_Transparent_GetConfig32((phhalHwContact_Transparent_DataParams_t *)pDataParams, wConfig, pValue);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR01
    case PHHAL_HW_CONTACT_RDSCR01_ID:
        status = phhalHwContact_RdScr01_GetConfig32((phhalHwContact_RdScr01_DataParams_t *)pDataParams, wConfig, pValue);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR01 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR2
    case PHHAL_HW_CONTACT_RDSCR2_ID:
        status = phhalHwContact_RdScr2_GetConfig32((phhalHwContact_RdScr2_DataParams_t *)pDataParams, wConfig, pValue);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR2 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE
    case PHHAL_HW_CONTACT_SMARTWARE_ID:
        status = phhalHwContact_Smartware_GetConfig32((phhalHwContact_Smartware_DataParams_t *)pDataParams, wConfig, pValue);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_KEOLABS
    case PHHAL_HW_CONTACT_KEOLABS_ID:
        status = phhalHwContact_Keolabs_GetConfig32((phhalHwContact_Keolabs_DataParams_t *)pDataParams, wConfig, pValue);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_KEOLABS */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT32(PH_LOG_LOGTYPE_DEBUG, pValue_log, pValue);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHwContact_Wait(
                        void * pDataParams,
                        uint8_t bUnit,
                        uint16_t wTimeout
                        )
{
    phStatus_t PH_MEMLOC_REM status;
    uint8_t bCompId;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHwContact_Wait");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bUnit);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wTimeout);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bCompId);
    bCompId = PH_GET_COMPID(pDataParams);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bCompId_log, &bCompId);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bUnit_log, &bUnit);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wTimeout_log, &wTimeout);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    /* Check data parameters */
    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS
    case PHHAL_HW_CONTACT_MICROPROSS_ID:
        status = phhalHwContact_Micropross_Wait((phhalHwContact_Micropross_DataParams_t *)pDataParams, bUnit, wTimeout);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_CALLBACK
    case PHHAL_HW_CONTACT_CALLBACK_ID:
        status = phhalHwContact_Callback_Wait((phhalHwContact_Callback_DataParams_t *)pDataParams, bUnit, wTimeout);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT
    case PHHAL_HW_CONTACT_TRANSPARENT_ID:
        status = phhalHwContact_Transparent_Wait((phhalHwContact_Transparent_DataParams_t *)pDataParams, bUnit, wTimeout);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR01
    case PHHAL_HW_CONTACT_RDSCR01_ID:
        status = phhalHwContact_RdScr01_Wait((phhalHwContact_RdScr01_DataParams_t *)pDataParams, bUnit, wTimeout);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR01 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR2
    case PHHAL_HW_CONTACT_RDSCR2_ID:
        status = phhalHwContact_RdScr2_Wait((phhalHwContact_RdScr2_DataParams_t *)pDataParams, bUnit, wTimeout);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR2 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE
    case PHHAL_HW_CONTACT_SMARTWARE_ID:
        status = phhalHwContact_Smartware_Wait((phhalHwContact_Smartware_DataParams_t *)pDataParams, bUnit, wTimeout);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_KEOLABS
    case PHHAL_HW_CONTACT_KEOLABS_ID:
        status = phhalHwContact_Keolabs_Wait((phhalHwContact_Keolabs_DataParams_t *)pDataParams, bUnit, wTimeout);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_KEOLABS */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
        break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHwContact_Activate(
                        void * pDataParams,
                        uint8_t * pATRBuffer,
                        uint16_t * pwATRLength
                        )
{
    phStatus_t PH_MEMLOC_REM status;
    uint8_t bCompId;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHwContact_Activate");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pATRBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bCompId);
    bCompId = PH_GET_COMPID(pDataParams);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bCompId_log, &bCompId);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    /* Check data parameters */
    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS
    case PHHAL_HW_CONTACT_MICROPROSS_ID:
        status = phhalHwContact_Micropross_Activate((phhalHwContact_Micropross_DataParams_t *)pDataParams, pATRBuffer, pwATRLength);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_CALLBACK
    case PHHAL_HW_CONTACT_CALLBACK_ID:
        status = phhalHwContact_Callback_Activate((phhalHwContact_Callback_DataParams_t *)pDataParams, pATRBuffer, pwATRLength);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT
    case PHHAL_HW_CONTACT_TRANSPARENT_ID:
        status = phhalHwContact_Transparent_Activate((phhalHwContact_Transparent_DataParams_t *)pDataParams, pATRBuffer, pwATRLength);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR01
    case PHHAL_HW_CONTACT_RDSCR01_ID:
        status = phhalHwContact_RdScr01_Activate((phhalHwContact_RdScr01_DataParams_t *)pDataParams, pATRBuffer, pwATRLength);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR01 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR2
    case PHHAL_HW_CONTACT_RDSCR2_ID:
        status = phhalHwContact_RdScr2_Activate((phhalHwContact_RdScr2_DataParams_t *)pDataParams, pATRBuffer, pwATRLength);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR2 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE
    case PHHAL_HW_CONTACT_SMARTWARE_ID:
        status = phhalHwContact_Smartware_Activate((phhalHwContact_Smartware_DataParams_t *)pDataParams, pATRBuffer, pwATRLength);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_KEOLABS
    case PHHAL_HW_CONTACT_KEOLABS_ID:
        status = phhalHwContact_Keolabs_Activate((phhalHwContact_Keolabs_DataParams_t *)pDataParams, pATRBuffer, pwATRLength);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_KEOLABS */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
        break;
    }

#ifdef NXPBUILD__PH_LOG
    if ((status & PH_ERR_MASK) == PH_ERR_SUCCESS)
    {
        PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pATRBuffer_log, pATRBuffer, *pwATRLength);
    }
#endif /* NXPBUILD__PH_LOG */

    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHwContact_Deactivate(
                        void * pDataParams
                        )
{
    phStatus_t PH_MEMLOC_REM status;
    uint8_t bCompId;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHwContact_Deactivate");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bCompId);
    bCompId = PH_GET_COMPID(pDataParams);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bCompId_log, &bCompId);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    /* Check data parameters */
    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS
    case PHHAL_HW_CONTACT_MICROPROSS_ID:
        status = phhalHwContact_Micropross_Deactivate((phhalHwContact_Micropross_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_CALLBACK
    case PHHAL_HW_CONTACT_CALLBACK_ID:
        status = phhalHwContact_Callback_Deactivate((phhalHwContact_Callback_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT
    case PHHAL_HW_CONTACT_TRANSPARENT_ID:
        status = phhalHwContact_Transparent_Deactivate((phhalHwContact_Transparent_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR01
    case PHHAL_HW_CONTACT_RDSCR01_ID:
        status = phhalHwContact_RdScr01_Deactivate((phhalHwContact_RdScr01_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR01 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR2
    case PHHAL_HW_CONTACT_RDSCR2_ID:
        status = phhalHwContact_RdScr2_Deactivate((phhalHwContact_RdScr2_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR2 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE
    case PHHAL_HW_CONTACT_SMARTWARE_ID:
        status = phhalHwContact_Smartware_Deactivate((phhalHwContact_Smartware_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_KEOLABS
    case PHHAL_HW_CONTACT_KEOLABS_ID:
        status = phhalHwContact_Keolabs_Deactivate((phhalHwContact_Keolabs_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_KEOLABS */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
        break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHwContact_ClockStop(
                        void * pDataParams,
                        uint16_t wTgClockCount,
                        uint16_t wThClockCount,
                        uint32_t dwPinState
                        )
{
    phStatus_t PH_MEMLOC_REM status;
    uint8_t bCompId;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHwContact_StopClock");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wTgClockCount);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wThClockCount);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(dwPinState);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bCompId);
    bCompId = PH_GET_COMPID(pDataParams);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bCompId_log, &bCompId);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wTgClockCount_log, &wTgClockCount);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wThClockCount_log, &wThClockCount);
    PH_LOG_HELPER_ADDPARAM_UINT32(PH_LOG_LOGTYPE_DEBUG, dwPinState_log, &dwPinState);

    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    /* Check data parameters */
    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS
    case PHHAL_HW_CONTACT_MICROPROSS_ID:
        status = phhalHwContact_Micropross_ClockStop((phhalHwContact_Micropross_DataParams_t *)pDataParams, wTgClockCount, wThClockCount, dwPinState);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_CALLBACK
    case PHHAL_HW_CONTACT_CALLBACK_ID:
        status = phhalHwContact_Callback_ClockStop((phhalHwContact_Callback_DataParams_t *)pDataParams, wTgClockCount, wThClockCount, dwPinState);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT
    case PHHAL_HW_CONTACT_TRANSPARENT_ID:
        status = phhalHwContact_Transparent_ClockStop((phhalHwContact_Transparent_DataParams_t *)pDataParams, wTgClockCount, wThClockCount, dwPinState);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR01
    case PHHAL_HW_CONTACT_RDSCR01_ID:
        status = phhalHwContact_RdScr01_ClockStop((phhalHwContact_RdScr01_DataParams_t *)pDataParams, wTgClockCount, wThClockCount, dwPinState);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR01 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR2
    case PHHAL_HW_CONTACT_RDSCR2_ID:
        status = phhalHwContact_RdScr2_ClockStop((phhalHwContact_RdScr2_DataParams_t *)pDataParams, wTgClockCount, wThClockCount, dwPinState);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR2 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE
    case PHHAL_HW_CONTACT_SMARTWARE_ID:
        status = phhalHwContact_Smartware_ClockStop((phhalHwContact_Smartware_DataParams_t *)pDataParams, wTgClockCount, wThClockCount, dwPinState);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_KEOLABS
    case PHHAL_HW_CONTACT_KEOLABS_ID:
        status = phhalHwContact_Keolabs_ClockStop((phhalHwContact_Keolabs_DataParams_t *)pDataParams, wTgClockCount, wThClockCount, dwPinState);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_KEOLABS */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
        break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phhalHwContact_InitContactReader(
                                            void * pDataParams
                                            )
{
    phStatus_t PH_MEMLOC_REM status;
    uint8_t bCompId;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phhalHwContact_InitContactReader");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(bCompId);
    bCompId = PH_GET_COMPID(pDataParams);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, bCompId_log, &bCompId);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    /* Check data parameters */
    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_HAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS
    case PHHAL_HW_CONTACT_MICROPROSS_ID:
        status = phhalHwContact_Micropross_InitContactReader((phhalHwContact_Micropross_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_CALLBACK
    case PHHAL_HW_CONTACT_CALLBACK_ID:
        status = phhalHwContact_Callback_InitContactReader((phhalHwContact_Callback_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_CALLBACK */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT
    case PHHAL_HW_CONTACT_TRANSPARENT_ID:
        status = phhalHwContact_Transparent_InitContactReader((phhalHwContact_Transparent_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR01
    case PHHAL_HW_CONTACT_RDSCR01_ID:
        status = phhalHwContact_RdScr01_InitContactReader((phhalHwContact_RdScr01_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR01 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR2
    case PHHAL_HW_CONTACT_RDSCR2_ID:
        status = phhalHwContact_RdScr2_InitContactReader((phhalHwContact_RdScr2_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR2 */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE
    case PHHAL_HW_CONTACT_SMARTWARE_ID:
        status = phhalHwContact_Smartware_InitContactReader((phhalHwContact_Smartware_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE */

#ifdef NXPBUILD__PHHAL_HW_CONTACT_KEOLABS
    case PHHAL_HW_CONTACT_KEOLABS_ID:
        status = phhalHwContact_Keolabs_InitContactReader((phhalHwContact_Keolabs_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHHAL_HW_CONTACT_KEOLABS */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
        break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

#endif /* NXPBUILD__PHHAL_HW */
