/*************************************************************************
                        MLOS USER
                        Entry points of a package
 *************************************************************************
 15/04/2009 Marc LEGOUX V2r23p: Add extern "C" block
 19/03/2007 Marc LEGOUX V2r23f: Add Package in usercfg_Type
 15/11/2002 Marc LEGOUX C6r08 : Move to common C code
 24/10/2001 Marc LEGOUX WNT6r05b: Add Quit function
 *************************************************************************/
#ifndef usercfg_h
#define usercfg_h

#ifdef __cplusplus
extern "C" {
#endif

#include <config.h>
#include <err.h>

#if config_WIN
#include <windows.h>
#endif

typedef
  struct {
    unsigned SizeOf;		// == sizeof(usercfg_Type)
    unsigned Mode;
    void * Params;		// Specific parameters
    unsigned ParamsSize;	// Size in bytes or 0
    
    #if config_WIN
    HANDLE hInstance;		// Instance of Process 
    #else
    ulong	RFU;		// From v2r23f
    #endif
    
    err_Type (* Quit)();	// Process quit or null
    // From v2r23f
    void  * Package;		// 0 or Starting package (No Ref count)
    
  } usercfg_Type;

/*-----------------------------------------------------------------------*
                        Create tasks of configuration
 *-----------------------------------------------------------------------*/
extern
err_Type usercfg_Start(usercfg_Type * Cfg);
/*-----------------------------------------------------------------------*
                        End tasks of configuration
 *-----------------------------------------------------------------------*/
extern
err_Type usercfg_End(usercfg_Type * Cfg);

#ifdef __cplusplus
}
#endif
#endif
