/**********************************************************************
		CONFIGURATION of APPLICATION
 This file makes the Interface with the SYSCFGxx.c files which are 
 generated by MLAG for every targets. 
 **********************************************************************
 06/06/2009 - Marc LEGOUX - V2r24 : New interface
 06/02/2007 - Marc LEGOUX - V2r23 : New interface (needed for 5407)
 24/05/2005 - Marc LEGOUX - V2r22 : New interface
 03/11/2004 - Marc LEGOUX - V2r22 : New interface
 12/03/2004 - Marc LEGOUX - V2r21p: New interface
 14/12/2003 - Marc LEGOUX - V2r21j: INITC for relocatable code
 29/10/2003 - Marc LEGOUX - V2r21e: Call glob with DLL target
 01/10/2003 - Marc LEGOUX - V2r21 : Creation for main
 19/06/2003 - Marc LEGOUX - V2r20 : Creation for main
 **********************************************************************/

#include <sysobj.h>
#include <mlosmain.h>
//#include <glob.h>

#if config_MLOS32
char syscfg_ModVers[] = "MAINUSER_PF:V2R24";
#endif
#if config_WIN
char syscfg_ModVers[] = "MAINUSER_WIN:V2R24";
#endif
/*--------------------------------------------------------------------*/
/* Start application Objects */
err_Type syscfg_Start(void * Cfg)
{ 
  err_Type erno=0;
  extern err_Type sysct_Start();
  
  #if config_MLOS32
  extern int syst_Trap0Cfg();
  extern err_Type mem_HeapStart();
  extern err_Type std_32Start();
  
  syst_Trap0Cfg();	// Init Trap0 direct calls
  //err_Start(0);
  #endif
  
  //glob_Start(0);
  erno = mlos_MAINEntryStart(0);
  if (erno) return(erno);
  
  #if config_MLOS32
  erno = mem_HeapStart(Cfg);
  if (erno) return(erno);
  erno = std_32Start(Cfg);
  if (erno) return(erno);
  #endif
  
  /*-USER---------------------------------------*/
  erno = sysct_Start(Cfg);
  return(erno);
}

/*--------------------------------------------------------------------*/
/* Stop application Objects */
err_Type syscfg_End(void * Cfg)
{ 
  err_Type erno;
  extern err_Type sysct_End();
  #if config_MLOS32
  extern err_Type mem_HeapEnd();
  extern err_Type std_32End();
  #endif
  
  erno = sysct_End(Cfg);
  #if config_MLOS32
  std_32End(Cfg);
  mem_HeapEnd(Cfg);
  #endif
  if (erno) return(erno);
  
  erno = mlos_MAINEntryEnd(Cfg);
  return(erno);
}
/*--------------------------------------------------------------------*/
//#pragma section CONST ".textheader2"
//const char sysct_Name[] = "USER";
//const char sysct_Vers[] = "USER:V2r20k";
/*--------------------------------------------------------------------*/
