/***********************************************************************
                                 CONFIG
                          Configuration et Portage
 ***********************************************************************
 Copyright (c) SMARTWARE, 1999 All Rights Reserved.
 10/02/2002 - Marc LEGOUX - WNT6R05-DLL : Use TLS 
 06/09/2001 - Marc LEGOUX - WNT6R05-DLL : Add DLL flag
 28/08/2001 - Marc LEGOUX - WNT6R05 : Add VIRTAL_MEM flag in MACHINE
 20/02/2001 - Marc LEGOUX - WNT6R05 : Add INI files
 06/06/2000 - Marc LEGOUX - WNT6R03 : Add TLSMANUAL config
 24/03/1999 - Marc LEGOUX - WNT4R01 : Copy from own module
 05/12/1989 - Marc LEGOUX : Creation
 ***********************************************************************
 Chaque symbole de la zone CONFIGURATION COURANTE doit etre 
 definit avec les valeurs decrites dans CONFIGURATIONS.
 
 PORTAGE :
   Ne jamais emputer un source pour le porter : Rajouter plutot dans
   la configuration un symbole identifiant la cible du portage et
   permettant de compiler conditionnellement le code a modifier. 
 
 ***********************************************************************/
#ifndef config_h
#define config_h
/*----------------------------CONFIGURATIONS---------------------------*/
/****** Proprietes de machines (composables par |) */
/* Byte ordering (little-endian: meme adresse pour un mot et son octet 0) */
#define LENDIAN	0	/* little-endian: VAX11/780, 80286, NS32000*/
#define BENDIAN	1	/* big-endian: IBM370, MC68000 */
#define VIRTUAL_MEM 2   /* avec memoire virtuelle */
 
/* Size of (data) registers in bits: 8, 16, 32, 48, 64 */
/* That gives the size of int of the compiler */
#define config_REGSIZE 32	/* default */

/****** Types de systeme */
#define SYSMASK	0xFFF0	/* 4 lower bits for sub-system */

#define UNIX	0x10
#define BSD	0x11	/* UNIX + bit 0 */
#define SYS5	0x12	/* UNIX + bit 1 */
#define SUN     0x15	/* UNIX-BSD + bit 2 */

#define MDOS	0x20

#define VMS	0x30

#define WINMASK	0x40
#define WIN311	0x41

#define WIN32M	0x48	/* bit 4 == 95 || NT */
#define WIN95	0x49
#define WINNT	0x4A

#define MLOS	0x50
#define MLOS8	0x51
#define MLOS32	0x52
 
/****** Types d'ecran */
#define SCREEN_CONSO	1
#define SCREEN_WIN	2

/****** Types de compilateurs */
#define MSC	1	/* Microsotf-C */
#define IAR	2	/* C IAR 8051 */
#define C51	3	/* C KYLE 8051 */
#define DIAB	4	/* C DIAB data */

/****** Proprietes de compilateurs (composables par |) */
#define KERNIGHAN	0	/* Kernighan et Richie 78 */
#define STRUCTVAL	1	/* Connait les valeurs de structures */
				/* ->assignement et passage en parame`tres*/
#define TLSMANUAL	2	/* TLS : Manual Task Local Storage  */
				/*      -> must use TlsAlloc, ... */

#define XOPEN		STRUCTVAL

/****** Proprietes des librairies (composables par |) */
#define TERMCAP		1	/* (bit 0) termcap est disponible */
#define EXTERM		2	/* (bit 1) terminal externe (!interne)*/
 
/************************** CONFIGURATION COURANTE **********************/
 
/* Machine courante (OU des proprietes ou 0) */
#define config_MACHINE (LENDIAN | VIRTUAL_MEM)
 
#define config_REGSIZE 32

/* Systeme courant (Type du systeme) */
#define config_SYSTEM	WINNT
 
/* Compilateur courant */
#define config_COMPILER	MSC

/* Ecran courant (CONSO if not defined)*/
#define config_SCREEN	SCREEN_WIN

/* Proprietes Compilateur courant (OU des proprietes ou 0) */
// In a Windows DLL TLS must be used
#define config_COMPILPROP (STRUCTVAL | TLSMANUAL)

/* Librairies courantes (OU des proprietes ou 0) */
//#define config_LIB 0
#define config_DLL 1		// Inside a Dll else not defined
 
/* INI Files */
#define config_SysFName		"MLOS.INI"
#define config_HwiFName		"MLOS.INI"
/*--------------------------------#IF-----------------------------------*/
/* Max des entiers signes */
#if config_REGSIZE == 32
#define config_maxint 0x7fffffff
#define config_maxuint 0x0ffffffff
#else
#define config_maxint 0x7fff
#define config_maxuint 0x0ffff
#endif

/* Expressions de test pour #if ... */ 
/* Operating System */
#define config_UNIX	((config_SYSTEM & SYSMASK) == UNIX)
#define config_BSD	((config_SYSTEM & BSD) == BSD)
#define config_SYS5	(config_SYSTEM == SYS5)
#define config_SUN      (config_SYSTEM == SUN)
#define config_VMS	(config_SYSTEM == VMS)
#define config_MSDOS	((config_SYSTEM & SYSMASK) == MDOS)
#define config_WIN      ((config_SYSTEM & SYSMASK) == WINMASK)
#define config_WIN32    ((config_SYSTEM & (WIN32M|SYSMASK)) == WIN32M)
#define config_WIN311   (config_SYSTEM == WIN311)
#define config_WIN95    (config_SYSTEM == WIN95)
#define config_WINNT    (config_SYSTEM == WINNT)
#define config_MLOS     ((config_SYSTEM & SYSMASK) == MLOS)
#define config_MLOS8    (config_SYSTEM == MLOS8)
#define config_MLOS32   (config_SYSTEM == MLOS32)
 
/* Multitasking */
#define config_MULTITASK     (config_UNIX || config_WIN32 || config_MLOS)
#define config_MONOTASK      (!config_MULTITASK)

/* Screen */
#ifdef config_SCREEN
#define config_CONSO	(config_SCREEN == SCREEN_CONSO)
#endif

/* Compiler */
#define config_MSC	(config_COMPILER == MSC)
#define config_IAR	(config_COMPILER == IAR)
#define config_C51	(config_COMPILER == C51)

#define config_STRUVAL	(config_COMPILPROP & STRUCTVAL)
#define config_TLS	(config_COMPILPROP & TLSMANUAL)
#define config_XOPEN	(config_COMPILPROP & XOPEN)
 
#define config_LENDIAN  (!(config_MACHINE & BENDIAN))
#define config_BENDIAN  (config_MACHINE & BENDIAN)
#define config_VIRTUAL_MEM  (config_MACHINE & VIRTUAL_MEM)

#define config_TERMCAP	(config_LIB & TERMCAP)
#define config_EXTERMCAP (config_LIB & EXTERM)
/*------------------------------FUNCTIONS------------------------------*/
#endif
