/***********************************************************************
                                  TCURTXF
 				  Tcur from a file
 ***********************************************************************
 27/03/2007 Marc LEGOUX V2r23g : Increase line max size to 1024
 ***********************************************************************/
#ifndef tcurtxf_h
#define tcurtxf_h

#include <tcur.h>
#include <txf.h>
 
/*--------------------------------DATAS--------------------------------*/
#define tcurtxf_linesize 1024	// line buffer size 

typedef 
  struct {
    tcur_ctype cur;			/* Generic cursor : first field */
    char_0type line[tcurtxf_linesize+1];	/* line buffer */
    union {
      txf_iter_type iter;	/* Iterator on file */
      txf_cur_type  cur;	/* Cursor on file (saved state) */
    } txf;
  } tcurtxf_type;
/*------------------------------FUNCTIONS------------------------------*/
/*---------------------------------------------------------------------*
			From a TXF file
 *---------------------------------------------------------------------*/
#define tcurtxf_get(pcur) ((tcurtxf_type *)((pcur)->ctx1))
#define tcurtxf_set(pcur,curtxf) ((pcur)->ctx1 = (tcur_ctx_type)(curtxf))
/*---------------------------------------------------------------------*
                              Init a text cursor on file
 Should be done before use as generic cursor saving
 *---------------------------------------------------------------------*/
extern
err_type tcurtxf_initfile(
  tcurtxf_type * curtxf,/* (OUT) txf Cursor to init*/
  tcur_ctype ** ppcur	/* (OUT) Corresponding generic Cursor (or 0) */
);
/*---------------------------------------------------------------------*
                               Open the text cursor
 *---------------------------------------------------------------------*/
extern
err_type tcurtxf_openfile(
  char * fpath,		/* File path */
  char * wfpath,	/* Path of a temporary file to write (or NULL)*/
  tcur_fertype ferror,	/* Error function to call with tcur_err */
  long sp,		/* Pointeur initial dans le fichier (0=debut) */
  unsigned lnum,	/* Ligne 1.. du pointeur initial (0=inconnue) */
  tcurtxf_type * curtxf,/* (OUT) txf Cursor to init*/
  tcur_ctype ** ppcur	/* (OUT) Corresponding generic Cursor (or 0) */
);
/*---------------------------------------------------------------------*
                               Close
 *---------------------------------------------------------------------*/
extern
err_type tcurtxf_closefile(
  tcur_ctype * cur, 	/* text Cursor */
  unsigned mode		/* see txf_file_mode_... */
);
/*---------------------------------------------------------------------*
                               Operation
 Spec accorded to tcur_ftype()
 *---------------------------------------------------------------------*/
err_type tcurtxf_operfile();

#endif
