/***********************************************************************
                        System INTERFACE X
 ***********************************************************************
 Copyright (c) SMARTWARE, 1999,2009 All Rights Reserved.
 ***********************************************************************
 26/02/2009 - Marc LEGOUX : V2r23p: Add MOpHeapSpy operations
 11/08/2008 - Marc LEGOUX : V2r23n: Add MOpIncr
 27/09/2007 - Marc LEGOUX : V2r23j: Add MOpTaskxx (Signal to PriorSet)
 12/07/2007 - Marc LEGOUX : V2r23i: Add MOpReadxNI, MOpWritexxNI
 11/04/2006 - Marc LEGOUX : C6r22a: Add MOpFlashInfo
 24/10/2005 - Marc LEGOUX : C6r21b: Add MOpSysobjPrintRedir
 10/10/2005 - Marc LEGOUX : C6r21 : Add parameter definitions 
 13/07/2005 - Marc LEGOUX : C6r19 : Add _MOpWait 
 17/05/2005 - Marc LEGOUX : C6r19 : Add _MOpFileRead
 01/10/2004 - Marc LEGOUX : C6r17 : Add _MOpPLoadInfo
 17/03/2004 - Marc LEGOUX : C6r15 : Add SerialNum into sys_InfoType
 03/11/2003 - Marc LEGOUX : C6r12 : Add _MOpPInfo
 11/06/2003 - Marc LEGOUX : C6r09 : Add _MOpPLoadOpen, Move HdType to pac32
 21/05/2003 - Marc LEGOUX : krn2r06 : Modify sys_InfoType
 14/03/2003 - Marc LEGOUX : krn2r05 : Add _MOpModInfo, _MOpErrMsg
 18/12/2002 - Marc LEGOUX : krn2r03 : Add _MOpxx32, _MOpxx16
 14/11/2002 - Marc LEGOUX : krn2r02 : Update sys_MProgHdType
 14/05/2002 - Marc LEGOUX : krn2r02 : Add _MOpSI
 10/04/2002 - Marc LEGOUX : krn2r02 : Add _MOp
 08/02/2002 - Marc LEGOUX : krn2r01 : Add _MOp
 23/04/2001 - Marc LEGOUX : krn1r07 : Add _MOpImg Id
 22/01/2001 - Marc LEGOUX : krn1r07 : Add _MOpHeapCheck Id
 07/06/2000 - Marc LEGOUX : krn1r07 : Add sys_SysobjNode and sys_SysobjDirIni
 12/01/2000 - Marc LEGOUX : krn1r05
 ***********************************************************************/
#ifndef sysx_h
#define sysx_h

#include <err.h>

/*----------------------------------------------------------------------*
                        Search and start/end all applis from flash
 *----------------------------------------------------------------------*/
extern
err_Type sys_MProgFExec(
        unsigned Mode);	/* bit0: 0=Start, 1=End*/
/*---------------------------------------------------------------------*
                        Sub-Operation codes for sys_MOp
 *---------------------------------------------------------------------*/
#define sys_MOpId	0x02	// Object-Operation Id

/* Machine */
// WARNING: USED in netobj_ARPType - Do not modify
#pragma pack(1)
typedef
  struct {
    char McuVersion[33];	// MCU
    char SystVersion[33];	// System	= <SystemId>:<Version>_<Date>
    char HwVersion[33];		// Hardware
    char SerialNum[33];		// Serial number
  } sys_InfoType;
#if config_MLOS32
#pragma pack(0)
#else
#pragma pack()
#endif

extern sys_InfoType sys_Info;		// In SYSCFG.C

#define sys_InfoNoSNSizeof	(33*3)	// Sizeof without SerialNum

#define sys_MOpInfo		0x00

/* Program */
#define sys_MOpPStart		0x01
#define sys_MOpPEnd		0x02
#define sys_MOpPLoadOpen	0x03
#define sys_MOpPLoadClose	0x04
#define sys_MOpPInfo		0x30	// Packages
#define sys_MOpPLoadInfo	0x31	// Currently downloading areas

/* Watch dog */
#define sys_MOpWDService	0x05
#define sys_MOpWDCfg		0x06
#define sys_MOpMcuReset		0x07

/* Modules */
#define sys_MOpModNames		0x08
#define sys_MOpModVersions	0x09
#define sys_MOpModVerbose	0x0A
#define sys_MOpModInfo		0x0B
#define sys_MOpErrMsg		0x0C

/* Heap */
#define sys_MOpHeapInfo		0x10
#define sys_MOpHeapAlloc	0x11
#define sys_MOpHeapFree		0x12
#define sys_MOpHeapCheck	0x13

#define sys_MOpHeapSpyOnOff	0x16
#define sys_MOpHeapSpyInfo	0x17

/* Image */
#define sys_MOpImg		0x18	// To 0x1F

/* Time */
#define sys_MOpTic		0x20
#define sys_MOpTick		0x20
#define sys_MOpTimerInfo	0x21
#define sys_MOpWait		0x25

/* Task */
#define sys_MOpTaskInfo		0x22
#define sys_MOpTaskListTake	0x23
#define sys_MOpTaskListRel	0x24
#define sys_MOpTaskSignal	0x26
#define sys_MOpTaskKill		0x27
#define sys_MOpTaskAbort	0x28
#define sys_MOpTaskPriorSet	0x29
#define sys_MOpTaskSuspend	0x2A
#define sys_MOpTaskResume	0x2B

/* Memory */
// Ops with No Increment
#define sys_MOpReadNI		0xE5
#define sys_MOpWriteNI		0xE6
#define sys_MOpRead16NI		0xE7
#define sys_MOpWrite16NI	0xE8
#define sys_MOpRead32NI		0xE9
#define sys_MOpWrite32NI	0xEA

#define sys_MOpIncr		0xEF

// Standart op
#define sys_MOpCopy		0xF0
#define sys_MOpCompare		0xF2
#define sys_MOpCheck		0xF3
#define sys_MOpFill		0xF4
#define sys_MOpRead		0xF5
#define sys_MOpWrite		0xF6
#define sys_MOpRead16		0xF7
#define sys_MOpWrite16		0xF8
#define sys_MOpRead32		0xF9
#define sys_MOpWrite32		0xFA
#define sys_MOpReadToFile	0xFB
#define sys_MOpWriteFromFile	0xFC

#pragma pack(1)
typedef 
  struct {
    uchar	Code;
    ulong	Addr;
    ulong	Size;
    ushort	Node;
    uchar	Mode;
    char	FPath[1];
  } sys_MemParamFileType;
#if config_WIN
#pragma pack()
#else
#pragma pack(0)
#endif


/* Flash */
#define sys_MOpFlashProg	0xF1
#define sys_MOpFlashInfo	0xFD
#define sys_MOpFlashErase	0xFE

/*---------------------------------------------------------------------*
                        Sub-Operation codes for sys_SysobjOp
 *---------------------------------------------------------------------*/
#define sys_SysobjOpId		0x03	// Object-Operation Id

#define sys_SysobjObjs		0x00	// List of objects
#define sys_SysobjCall		0x01	// Call
#define sys_SysobjWait		0x02	// Wait
#define sys_SysobjPrintNO	0x03	// Define Print Obj
#define sys_SysobjNode		0x04	// Get/Set sysobj_Node
#define sys_SysobjDirIni	0x05	// Get starting directory
#define sys_SysobjInfo		0x06	// Get Caller and cur objects
#define sys_SysobjPrintSt	0x07	// Print string

#define sys_SysobjTestStart	0x10	// Start call test
#define sys_SysobjTestStop	0x11	// Stop call test
#define sys_SysobjTestExec	0x12	// Exec call test
#define sys_SysobjTestMT	0x13	// Start Multi-task test

#define sys_SysobjTestBufDefX	0x14	// Test sysobj_BufDef()
#define sys_SysobjTestBufDefY	0x15	// Test sysobj_BufDef()
/*---------------------------------------------------------------------*
                        Sub-Operation codes for sys_HwiOp
 *---------------------------------------------------------------------*/
#define sys_HwiOpId		0x04	// Object-Operation Id

/*---------------------------------------------------------------------*
                        Sub-Operation codes for sys_SIOp
 *---------------------------------------------------------------------*/
#define sys_SIOpId		0x05	// Object-Operation Id

/* Secury Interface */
#define sys_SIOpUserLogin	0x00
#define sys_SIOpUserLogout	0x01
#define sys_SIOpUserDef		0x02
#define sys_SIOpUserUndef	0x03
#define sys_SIOpUserInfo	0x04
#define sys_SIOpAccredit	0x05

/*----------------------------------------------------------------------*
                        Start
 *----------------------------------------------------------------------*/
extern
err_Type sys_YStart(void * Cfg);
/*----------------------------------------------------------------------*
                        End
 *----------------------------------------------------------------------*/
extern
err_Type sys_YEnd(void * Cfg);

#endif
