/************************************************************************
                        SHA 1
 FIPS-180-1 compliant
 **********************************************************************
 Copyright (c) SMARTWARE, 1999-2005 All Rights Reserved.
 ************************************************************************
 27/06/2005 ML V2R01 : Creation from freeware
 ************************************************************************/
#ifndef sha1_h
#define sha1_h

#include <err.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
    ulong	RFU[4];	// Reserved to the system
    ulong	total[2];
    ulong	state[5];
    uchar	buffer[64];
  } sha_1ObjType;

/*----------------------------------------------------------------------*
			Init
 *----------------------------------------------------------------------*/
extern
err_Type sha_1Init(
	sha_1ObjType * Obj
	);
/*----------------------------------------------------------------------*
                        Update
 *----------------------------------------------------------------------*/
extern
err_Type sha_1Update(
        sha_1ObjType * Obj, 
        ulong   DataLen, 	// Data block length
        uchar * DataIn		// Data block
        );
/*----------------------------------------------------------------------*
                        Finish
 *----------------------------------------------------------------------*/
extern
err_Type sha_1Finish(
        sha_1ObjType * Obj, 
        uchar DataOut[20]	// OUT : result
        );

#ifdef __cplusplus
}
#endif
#endif
