/***********************************************************************
                        Package
                        in MLOS32 memory
 ***********************************************************************
 02/11/2008 : Marc LEGOUX V2r23p: Add Reloc Info data flag
 14/05/2007 : Marc LEGOUX V2r23m: Add Reloc Info mode of Header
 12/07/2005 : Marc LEGOUX V2r22c: Moved to KRN32. Change SizeDef to 1Mb. 
 06/02/2004 : Marc LEGOUX C6r14 : Add pac32_SizeDef
 04/10/2003 : Marc LEGOUX C6r11 : Change pac32_New from macro to function
 15/09/2003 : Marc LEGOUX C6r10 : Modify pac32_Mode codes /16
 05/03/2001 : Marc LEGOUX C6r06 : Creation from own module
 ***********************************************************************/
#ifndef pac32_h
#define pac32_h

#include <err.h>
#include <pac.h>

/*----------------------------------------------------------------------*
		MLOS32 Image descriptor
 The magic word defines the type of image: 
 Boot, System, Appli, FPGA, etc...
 *----------------------------------------------------------------------*/
// Magic words 
#define pac32_MagicS		0xC421C421	// System Image 
#define pac32_MagicS2		0xC421C422	// System Image >= v2r21n

#define pac32_MagicB		pac32_MagicS	// Boot Image >= v2r05
#define pac32_MagicB2		0xB421B422	// Boot Image >= v2r05

#define pac32_MagicU		0x00421421	// User Appli Image 
#define pac32_MagicU2		0x00421422	// User Appli Image >= v2r20j

#define pac32_MagicS3A		0x53334101	// FPGA Spartan 3A

#define pac32_AddrNull		0xFFFFFFFF	/* Null address */

#define pac32_SizeDef		0x000FFFE0	// Default size if 0 (1M-32)

/*----------------------------------------------------------------------*
                        Image Header
 Compatibility : MLOS32
 Defined at start_Header address
 An image is started at Installation address. 
 An image uses at least a ram area to run. 
 *----------------------------------------------------------------------*/
#pragma pack(1)
typedef
  struct {
    ulong sp;		// Stack pointer for Start() (System only)
    ulong Start;	// Start entry point
    ulong Magic;	// Magic word
    ulong Addr;		// Installation address (PROG_ADDR)
    ulong Size;		// Installation size
    ulong AddrLoad;	// Load address from hex/sre file
                        // Nothing Below with MagicS
    ulong End;		// End entry point
    ulong * AddrStatus;	// Start status address (32 bit word)
                        // Nothing Below with MagicU
    ulong Mode;		// Link Mode
    ulong RunAddr;	// Run address in RAM   (can be adjusted)
    ulong RunSize;	// Run size in RAM
    ulong HeapStart;	// Heap address         (can be adjusted)
    ulong HeapSize;	// Heap size            (can be adjusted)
    char  Name[16+4];	// Program Name (+4 to keep alignement)
    char  Vers[32+4];	// Program Version
  } pac32_HdType;
#if config_MLOS32
#pragma pack(0)
#else
#pragma pack()
#endif

typedef
  err_Type pac32_FuncType(void * Params);

// Mode ORed Flags
#define pac32_HdModeReloc	1	// Relocatable code
#define pac32_HdModeFlash	2	// Flash code
#define pac32_HdModeRelocInfo	4	// Reloc infos after absolute code
/*----------------------------------------------------------------------*
			Specific Modes
 Could be returned in pac_HType.Mode
 Must be choosen in pac_ModeSMask
 *----------------------------------------------------------------------*/
#define pac32_ModeKeepArea	0x01000000	// created AT BaseAddr (do not free BaseAddr)
/*----------------------------------------------------------------------*
			Image infos
 *----------------------------------------------------------------------*
 All values are BigEndian.
 IMAGE :
 <Header> <Code/Data> [<Info header> <Sections> <Relocation infos>]
 *----------------------------------------------------------------------*/
typedef
  struct {
    ulong	Size;		// Size of all infos (Hd + sections + reloc)
    ulong	SectOffs;	// Offset of first section in image
    ulong	SectSize;	// Size of all sections
    ulong	SectNb;		// Nb of sections
    ulong	RFU[4];
  } pac32_InfoHdType;		// Main header of all infos

typedef
  struct {
    uchar	Name[15+1];	// Section name
    ulong	Mode;		// Section mode
    ulong	ProgOffs;	// Offset of code/data in image
    ulong	ProgSize;	// Size   of code/data
    ulong	ProgAddr;	// Addr   of code/data (Linked Addr)
    ulong	RelocOffs;	// Offset of relocation infos
    ulong	RelocSize;	// Size   of relocation infos
    ulong	RelocNb;	// Nb     of relocation entries
    ulong	RFU[2];
  } pac32_SectionType;		// Section descriptor

// NOTE: All sections with ProgAddr < pac32_ProgMaxLen must be relocated
#define pac32_ProgMaxLen	0x00100000	// Program/data max length

#define pac32_SectionModePacHd		1	// Package header
#define pac32_SectionModeAbsAddr	2	// ProgAddr is absolute
#define pac32_SectionModeNoData		4	// Section without data

typedef
  struct {
    ulong	Addr;		// Address of value to adjust
    ulong	Info;		// Info on entry
    long	AddEnd;		// To add to relocated value
  } pac32_RelocType;		// Relocation entry

#define pac32_RelocInfoData	0x80000000	// Data: Do not reloc
#define pac32_RelocInfoSymb	0x3FFFFF00	// Mask of index in the symbol table
#define pac32_RelocModeMask	0x000000FF	// Mask of relocation mode
#define pac32_RelocMode32	1	// 32 bit absolute address
                                        // move.l _abc, d0
#define pac32_RelocMode16	2	// 16 bit absolute address
                                        // move.l (_abc).w, d0
#define pac32_RelocModePC32	4	// 32 bit PC relative address
                                        // move.l ((_abc).l,pc), d0
#define pac32_RelocModePC16	5	// 16 bit PC relative address
                                        // move.l ((_abc).w,pc), d0
#define pac32_RelocModeSDA32	180	// 32 bit Small Data Area relative address
                                        // move.l ((_abc@sda).l,a5), d0
#define pac32_RelocModeSDA16	181	// 16 bit Small Data Area relative address
                                        // move.l ((_abc@sda).w,a5), d0
/*--------------------------------------------------------------------*
                New driver 
 Physical Id : 
 <appli name>:<instance num>
 *--------------------------------------------------------------------*
 The image area is ALWAYS allocated and owned by the package. 
 When the package ends, the area is made free. 
 
 The mode pac32_ModeKeepArea is returned when the package is created AT BaseAddr. 
 In that case the caller must not free BaseAddr. 
 *--------------------------------------------------------------------*/
extern
err_Type pac32_New(
        pac_Type **pobj, 
        unsigned Mode, 
        ulong BaseAddr, 
        char * Id, 
        ulong RFU1, 
        void * Cfg
        );
/*----------------------------------------------------------------------*
                        Start
 *----------------------------------------------------------------------*/
extern
err_Type pac32_Start(
        void * Cfg
        );
/*----------------------------------------------------------------------*
                        End
 *----------------------------------------------------------------------*/
extern
err_Type pac32_End(
        void * Cfg
        );
/*---------------------------------------------------------------------*/

#endif
