/************************************************************************
                        MBUS
                        Common Internal interface
                        Generated MA Interface
 ************************************************************************/
#ifndef mbusMA_h
#define mbusMA_h
#ifdef __cplusplus
extern "C" {
#endif

#include <err.h>
#include <mbus.h>

#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------*
			Methods
 *----------------------------------------------------------------------*/
typedef
  struct {
    /*--------------------*/
    err_Type (* Config)(
            mbus_Type * This, 
            unsigned Mode, 		// Mode
            ulong Val, 			// New value
            ulong * pVal		// null or OUT Current value
            );
    /*--------------------*/
    err_Type (* DeviceCom)(
            mbus_Type * This,
            mbus_DeviceRef Device, 	// Device
            unsigned Mode, 		// Mode
            syst_TType Timeout,
            unsigned Len, 		// Length to transfert
            unsigned * pLen, 		// null or OUT: Transfered length
            uchar * Buf			// IN: Data to write, OUT: Read data
            );
    /*--------------------*/
    err_Type (* DeviceNew)(
            mbus_Type * This, 
            mbus_DeviceRef Device,  // Device
            unsigned Mode, 		// Mode
            drv_Type * Drv
            );
    /*--------------------*/
    err_Type (* DeviceDel)(
            mbus_Type * This, 
            mbus_DeviceRef Device,  // Device
            unsigned Mode, 		// Mode
            drv_Type ** pDrv	// null or OUT
            );
    /*--------------------*/
    void * RFU[28];
    
  } mbus_MAType;

#ifdef __cplusplus
}
#endif
#endif
