/***********************************************************************
                HWI
                HardWare Interface
                IO
 ***********************************************************************
 Copyright (c) SMARTWARE, 1999 All Rights Reserved.
 ***********************************************************************
 16/08/2003 - Marc LEGOUX - v2r07: Add IOB and IOC Get
 04/08/2000 - Marc LEGOUX - v1r03: Add IOOUT0,4..7
 01/04/1999 - Marc LEGOUX - v1r03: From MLOS8
 ***********************************************************************/
#ifndef hwiio_h
#define hwiio_h

#include <err.h>

/*---------------------------------------------------------------------*
                        Generic IO
                        IO masks
 Assignment Facet -> PwFacet:
 Facet		
 IOOUT1		: IconOut5	Green perso side
 IOOUT2 Green	: IconOut4	Green middle
 IOOUT3 Red	: IconOut6	Red middle
 IOOUT4		: IconOut7	Red perso side
 *---------------------------------------------------------------------*/
/* OUTPUTs */
#define hwi_IOLDTR		0x80	/* L232 DTR */
#define hwi_IOOUT7		0x80	/* GPurpose IO */
#define hwi_IOOUT6		0x40	/* GPurpose IO */
#define hwi_IOOUT5		0x20	/* GPurpose IO */
#define hwi_IOOUT4		0x10	/* New Red */
#define hwi_IOOUT3		0x08	/* RED LED */
#define hwi_IOOUT2		0x04	/* GREEN LED */	
#define hwi_IOOUT1		0x02	/* New green */
#define hwi_IOOUT0		0x01	/* Relay */

#define hwi_IOGreenLed		4	/* GREEN LED */
#define hwi_IORedLed		8	/* RED LED */

/* INPUTS */
#define hwi_IOIN0		1	/* ST3 1-2 */
#define hwi_IOIN1		2	/* ST3 2-3 */
#define hwi_IOIN2		4	/* OPTO */
#define hwi_IOIN3		8	/* OPTO */
#define hwi_IOIN4		0x10
#define hwi_IOIN5		0x20
#define hwi_IOIN6		0x40
#define hwi_IOLCTS		0x80
/*---------------------------------------------------------------------*
                        Operation codes for IOxPut
 *---------------------------------------------------------------------*/
#define hwi_IOPutOpSet		0	/* OUTi  = mask */
#define hwi_IOPutOpOr		1	/* OUTi |= mask */
#define hwi_IOPutOpNand		2	/* OUTi &= ~mask */
#define hwi_IOPutOpXor		3	/* OUTi ^= mask */

// Special codes
// WARNING: To modify the direction of a hardware bit can damage the 
// electronic board if conflicts occur. 
#define hwi_IOPutOpInSel	0x10	// mask selects bits as inputs
#define hwi_IOPutOpOutSel	0x11	// mask selects bits as outputs
/*----------------------------------------------------------------------*
			Modes for IOxGet
 ORed flags
 *----------------------------------------------------------------------*/
#define hwi_IOGetModeDir	1	// Get direction mask else data
					// Direction: 0=Input, 1=Output
/*---------------------------------------------------------------------*
                        IO Put 
 *---------------------------------------------------------------------*/
extern
err_Type hwi_IOPut(
        uchar mask, 	// bit mask
        uchar op	// Put operation
	);
/*---------------------------------------------------------------------*
                        IO Get
 *---------------------------------------------------------------------*/
extern
err_Type hwi_IOGet(
	uchar * pmask	// OUT: data
	);
/*---------------------------------------------------------------------*
                        IOB Get
 *---------------------------------------------------------------------*/
extern
err_Type hwi_IOBGet(
        uchar * pmask,		// OUT: Direction or Data (see mode)
        uchar mode		// Mode
	);
/*---------------------------------------------------------------------*
                        IOB Put (PP7..0)
 *---------------------------------------------------------------------*/
extern
err_Type hwi_IOBPut(
        uchar mask, 	// bit mask
        uchar op	// Put operation
	);
/*---------------------------------------------------------------------*
                        IOC Get
 *---------------------------------------------------------------------*/
extern
err_Type hwi_IOCGet(
        uchar * pmask,		// OUT: Direction or Data (see mode)
        uchar mode		// Mode
	);
/*---------------------------------------------------------------------*
                        IOC Put (PP15..8)
 *---------------------------------------------------------------------*/
extern
err_Type hwi_IOCPut(
        uchar mask, 	// bit mask
        uchar op	// Put operation
	);

#endif
