/************************************************************************
                PACkage
                Generic object
 ************************************************************************
 25/06/2010 : Marc LEGOUX V2R24c: Import _EntryListAdd/Remove from pach.h
 05/09/2009 : Marc LEGOUX V2R24b: Add pac_EntryTypeN and pac_EntryXType
 01/04/2009 : Marc LEGOUX V2R23p: Enlarge pac_InfoType
 26/11/2008 : Marc LEGOUX V2R23n: Add pac__Image
 03/06/2008 : Marc LEGOUX V2R23m: Add pac__Exists
 19/03/2007 : Marc LEGOUX V2R23f: Add pac_Entry
 21/06/2005 : Marc LEGOUX C6R19 : Improve pac_InfoType
 08/02/2004 : Marc LEGOUX C6R14 : Package parameters are defined by usercfg_Type
 26/01/2004 : Marc LEGOUX C6R13 : Change pac_Delete from macro to function
 03/11/2003 : Marc LEGOUX C6R12 : Add pac_InfoGet
 04/10/2003 : Marc LEGOUX C6R11 : Change pac_Type to void *
 25/06/2003 : Marc LEGOUX C6R11 : Use DRVH.H
 16/06/2003 : Marc LEGOUX C6R09 : A package is a driver
 12/01/2003 : Marc LEGOUX C6R07 : From MLL
 16/08/2001 : Marc LEGOUX V5R01 : From Img
 05/03/2001 : Marc LEGOUX C6r06 : Creation from own module
 ************************************************************************/
#ifndef pac_h
#define pac_h

#ifdef __cplusplus
extern "C" {
#endif

#include <err.h>
#include <drv.h>
#include <usercfg.h>

extern err_Type pac__Err;
#define pac__NotFound			(pac__Err + 1)
#define pac__Size			(pac__Err + 2)
#define pac__Param			(pac__Err + 3)
#define pac__NoRoom			(pac__Err + 4)
#define pac__RefNb			(pac__Err + 5)
#define pac__Running			(pac__Err + 6)
#define pac__StartEnding		(pac__Err + 7)
#define pac__Class			(pac__Err + 8)
#define pac__StartAddr			(pac__Err + 9)
#define pac__NotValid			(pac__Err + 10)
#define pac__Info			(pac__Err + 11)
#define pac__IterNoMore			(pac__Err + 12)
#define pac__NoFunc			(pac__Err + 13)
#define pac__Obsolete			(pac__Err + 14)
#define pac__NoRoomRun			(pac__Err + 15)
#define pac__Ended			(pac__Err + 16)
#define pac__EntryUsed			(pac__Err + 17)
#define pac__EntryLength		(pac__Err + 18)	// Length 
#define pac__EntryNoFunc		(pac__Err + 19)	// Entry wrong Type
#define pac__NotEndable			(pac__Err + 20)
#define pac__Exists			(pac__Err + 21) // Already loaded
#define pac__Image			(pac__Err + 22)
#define pac__EntryName			(pac__Err + 23)
#define pac__EntryNotFound		(pac__Err + 24)

/*----------------------------------------------------------------------*
                        Package external type
 *----------------------------------------------------------------------*/
typedef 
  void pac_Type;

/*----------------------------------------------------------------------*
			Parameters for new packages
 *----------------------------------------------------------------------*/
#define pac_ModeAddrPath	drv_NewModeAddrSt	// Address to load is a path
#define pac_ModeAddrObj		drv_NewModeAddrObj	// Address to load is an object
#define pac_ModeMaskX		drv_ModeMaskX		// Specific modes

typedef
  struct {
    ulong  Addr;		// "Address" to load
    char * DirHome;		// Path name of home dir or 0
    char * Name;		// Package unique name or 0
    usercfg_Type * Param;	// Execution parameters if Auto mode
    void * RFU[4];
  } pac_NewParamType;

#define pac_SystemName	"MLOS"	// Unique name of system package
/*----------------------------------------------------------------------*
                        New Package
 *----------------------------------------------------------------------*/
extern
err_Type pac_New(
        pac_Type ** pPac,	// null or (OUT): New Package
        unsigned Mode,
        pac_NewParamType * NewParam
        );
/*----------------------------------------------------------------------*
                        Free Package
 *----------------------------------------------------------------------*/
extern
err_Type pac_Delete(
        pac_Type * Pac,
        unsigned Mode		// 0
        );
/*----------------------------------------------------------------------*
                        Exec Package
 *----------------------------------------------------------------------*/
extern
err_Type pac_Exec(
        pac_Type * Pac,
        unsigned Mode,
        usercfg_Type * Param	// 0 or Starting parameters
        );
/*----------------------------------------------------------------------*
                        Terminate Package
 *----------------------------------------------------------------------*/
extern
err_Type pac_Kill(
        pac_Type * Pac,
        unsigned Mode,
        usercfg_Type * Param	// 0 or Ending parameters
        );
/*----------------------------------------------------------------------*
                Get Info on package program
 *----------------------------------------------------------------------*/
#define pac_NameMax	32
#define pac_VersMax	32

typedef
  struct {
    ulong	SizeOf;			// IN: 0 or Max size, OUT: Size of struct
    ulong	Mode;			// Package mode
    char	Name[pac_NameMax+4];	// Program name
    char	Version[pac_VersMax+4];	// Program version
    
    // From C6R19
    ulong	State;			// Driver state
    err_Type	Erno;			// Last Exec or End error
    
    // MLOS32
    ulong	Addr;			// Program integer addr
    ulong	Size;			// Program size
    ulong	RunAddr;		// Run area
    ulong	RunSize;		// Run area size
    
    // V2r23p
    char DirHome[drv_PathMax+1];	// Path of related files
    char IniPath[drv_PathMax+1];	// Path of INI and session files
    char FilePath[drv_PathMax+1];	// Program file path
    
    ulong	RFU[32];
    
  } pac_InfoType;

// Size from v2r23p
#define pac_InfoTypeSize2	(sizeof(pac_InfoType))
// Size before V2r23p
#define pac_InfoTypeSize1	(pac_InfoTypeSize2 -32*sizeof(ulong) -3*(drv_PathMax+1))
// Size before C6R19
#define pac_InfoTypeSize0	(pac_InfoTypeSize1- 6*sizeof(ulong))

extern
err_Type pac_InfoGet(
        pac_Type * Pac,
        unsigned Mode,
        pac_InfoType * pInfo	// IN/OUT
        );
/*----------------------------------------------------------------------*
                        Find package by Name/Addr
 Name else Addr
 *----------------------------------------------------------------------*/
#define pac_FindModePath	1	// Name is Path (else Id)
extern
err_Type pac_Find(
        pac_Type ** pPac,	// OUT
        unsigned Mode,
        uchar * Name,		// null or 0 ended
        unsigned Addr
        );
/*----------------------------------------------------------------------*
                        Iterator on local Packages
 *----------------------------------------------------------------------*/
extern
err_Type pac_IterNew(
        unsigned Mode,
        void ** pIter	// OUT: iterl_Type * (ref is counted)
        );
/************************************************************************
                Entry and Entry List of a package program
 (Needed by OBJNET)
 ************************************************************************/
#define		pac_EntryModeX		1	// pac_EntryXType

#define		pac_EntryListMax	24
typedef
  struct {
    ulong	SizeOf;			// IN: 0 or Max size, OUT: Size of struct
    ulong	Mode;			// Simple or X type
    char	Name[pac_NameMax+4];
    ulong	RFU[3];
    ulong	ObjListLen;			// Last used index = n entries
    void *	ObjList[1+pac_EntryListMax];	// [0] not used (==0)
    
  } pac_EntryType;

// EntryType with n valid entries
#define pac_EntryTypeN(n) \
  struct {\
    ulong	SizeOf;\
    ulong	Mode;\
    char	Name[pac_NameMax+4];\
    ulong	RFU[3];\
    ulong	ObjListLen;\
    void *	ObjList[1+ n];\
  } 

#define pac_EntrySizeOf(n)	((15+(n)+1)*sizeof(void *))	// With n valid entries
// Max num of valid entries
#define pac_EntryMaxLen(e)	(((e)->SizeOf - pac_EntrySizeOf(0))/sizeof(void *))

/*----------------------------------------------------------------------*
                Extended Entry of a package program
 *----------------------------------------------------------------------*/
#define pac_EntryItemNameMax	23

#define pac_EntryItemMask	0x0F
#define pac_EntryItemModeULong	0x1	// 32 bit Value 
#define pac_EntryItemModeFunc	0x2	// C function
#define pac_EntryItemModeObj	0x3	// obj_type *
#define pac_EntryItemModeObjRef	0x4	// obj_type * (ref counted)
#define pac_EntryItemModeEntry	0x5	// EntryGet function

#define pac_EntryItemModeSet	0x100	// Value is set by package

typedef
  err_Type pac_ValFuncType();

typedef
  struct {
    void *	Val;				// Value
    ulong	Mode;				// Value type
    ulong	Num;				// Item num (default==Index)
    char 	Name[pac_EntryItemNameMax+1];	// Item Name
  } pac_EntryItemType;

#define pac_EntryXType(n) \
  struct {\
    ulong	SizeOf;\
    ulong	Mode;\
    char	Name[pac_NameMax+4];\
    ulong	RFU[3];\
    ulong	ObjListLen;\
    pac_EntryItemType ObjList[1+n];\
  }
#define pac_EntryXSizeOf(n)	(sizeof(pac_EntryXType(n)))	// With n valid entries
// Max num of valid entries
#define pac_EntryXMaxLen(e)	(((e)->SizeOf - pac_EntryXSizeOf(0))/sizeof(pac_EntryItemType))
/*----------------------------------------------------------------------*
                        Update one entry
 Idx is used to try a direct access 
 Num if !=0 is prioritary on Name
 IN: Sizeof and all infos except Values. 
 OUT: Same + updated Value of the selected entry
 *----------------------------------------------------------------------*/
#define pac_EntryModeAll	2	// All entries (release)
#define pac_EntryModeInit	4	// Init entry with index
extern
err_Type pac_EntryUpdate(
        pac_EntryType * pEntry,	// IN/OUT: Entry list
        ulong Mode, 	// Mode (Take/Release, all)
        ulong Idx,	// Index 
        void * Val, 	// Entry Value
        ulong EMode, 	// Entry Mode
        ulong Num, 	// Entry num or 0
        char * Name	// Entry Name or 0
        );
/*----------------------------------------------------------------------*
                        Take/Release
 *----------------------------------------------------------------------*/
#define pac_EntryModeTake	0	// Get and Take
#define pac_EntryModeRelease	1	// Release and Clear
extern
err_Type pac_Entry(
        pac_Type * Pac,
        unsigned Mode,
        char * Name,		// 0 or Interface name
        pac_EntryType * pEntry	// IN/OUT
        );
/*----------------------------------------------------------------------*
                        Entry list
 *----------------------------------------------------------------------*/
typedef
  err_Type pac_EntryFuncType(
          pac_Type * Pac,
          unsigned Mode,
          char * Name, 		// Interface name (0,"": first in list))
          pac_EntryType * pEntry	// In/OUT : Entry 
          );
/*----------------------------------------------------------------------*
                        Add entry to list
 *----------------------------------------------------------------------*/
extern 
err_Type pac_EntryListAdd(
        pac_Type * Pac, 	// 0 for Current
        unsigned Mode, 
        char * Name,		// Interface Name
        pac_EntryFuncType * EntryGet
        );
/*----------------------------------------------------------------------*
                        Remove entry from list
 *----------------------------------------------------------------------*/
extern 
err_Type pac_EntryListRemove(
        pac_Type * Pac, 	// 0 for current
        unsigned Mode, 
        char * Name		// Interface Name
        );
/*----------------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif
#endif
