/**********************************************************************
                CARD TEST AND MEASUREMENTS C-INTERFACE
                Dual Interface Synchronization Extension
 **********************************************************************
 Copyright (c) SMARTWARE, 2005 - 2013 All Rights Reserved.
 **********************************************************************
 12/07/2013 - DM v2r10a : From v2r05a. CARDTM is an independant package
 17/01/2007 - DM v2r05a : Add CmdOnTriggerDisable version
 17/01/2007 - DM v2r04a : Integrate DIS in CARDTM package
 21/11/2005 - DM v2r03c : Creation
  **********************************************************************/
#ifndef cardtmDIS_h
#define cardtmDIS_h

#ifdef __cplusplus
extern "C" {
#endif

#include <err.h>

/************************************************************************
 ************************************************************************
                TRIGGERED INTERFACE METHODS
 ************************************************************************
 ************************************************************************/

/*----------------------------------------------------------------------*
  card_CmdOnTriggerSet : Load Command in triggered interface

  Command is encapsulated in a TLV format block, to indicate which 
  CARD API is used to process the command. See TLV tag table below 
  to define the command.
 *----------------------------------------------------------------------*/
extern
err_Type card_CmdOnTriggerSet(
        card_Ref Obj,	// (In) Card Object of triggered interface
        uchar *pBufIn,	// (In) Command Buffer in TLV format
        ulong LngIn	// (In) Buffer Length
        );


/*----------------------------------------------------------------------*
  card_CmdOnTriggerGet : Check/Get Command Result on triggered interface

  * "cardtm__Busy" error code is returned if result is not available 
    (triggered interface has not been triggered yet, or exchange is not 
    over).
  * Reponse is encapsulated in a TLV format block, to code card API 
    answer : normal answer is data, invalid answer is an error code.
 *----------------------------------------------------------------------*/
extern
err_Type card_CmdOnTriggerGet(
        card_Ref Obj,	// (In) Card Object of triggered interface
        uchar *pBufOut,	// (Out) Response data buffer in TLV format
        ulong *pLngOut	// (In/Out) Max. response length / Current length
        );

/*----------------------------------------------------------------------*
  card_CmdOnTriggerDisable : Release interface which waits for the 
                             trigger to process a command
 *----------------------------------------------------------------------*/
extern
err_Type card_CmdOnTriggerDisable(
        card_Ref Obj	// (In) Card Object of triggered interface
        );


/*----------------------------------------------------------------------*
                TLV TAGS FOR ICC INTERFACE

Value	Name		Data Length	Description
0x01	Erno		4	Exchange Sequence Error Value (unsigned long value)
0x03	LgOut		4	Expected Output Data Length for RAW exchanges (unsigned long value)

0x05	ATR		N	Answer To Reset with bytes length value.

0x10	T=0 In Cmd	N	T=0 Input Command with bytes length value (card_InX).
0x11	T=0 Out Cmd	N	T=0 Output Command with bytes length value (card_OutX).
0x13	T=0 RAW Cmd	N	RAW Command with bytes length value (card_Transceive).
0x15	PPS Cmd		N	PPS Command with bytes length value (card_PPSX ).
0x16	T=1 Cmd		N	T=1 Command with bytes length value (card_PipeX).

0x20	T=0 In Cmd Ans	2	T=0 Input Command Status Word.
0x21	T=0 Out Cmd Ans	N	T=0 Output Command Answer including the Status Word, with bytes length value.
0x23	RAW Cmd Ans	N	RAW Command Answer with bytes length value.
0x25	PPS Answer	N	PPS Answer with bytes length value.
0x26	T=1 Cmd Ans	N	T=1 Command Answer with bytes length value.

0x40	Cold Reset	0	Cold Reset Sequence (card_Reset).
0x41	Warm Reset	0	Warm Reset Sequence (card_ResetWarm).
0x45	Off		0	Off Sequence (card_Off).

0x73	C3 Contact	4	Drive C3 contact, with configuration (unsigned long value) - (card_C3).

 *----------------------------------------------------------------------*/


/*----------------------------------------------------------------------*
                TLV TAGS FOR PICC INTERFACE

Value	Name		Data Length	Description
0x01	Erno		4	Exchange Sequence Error Value (unsigned long value)

0x16	T=CL Cmd	N	Input Command with bytes length value (card_PipeX).

0x26	T=CL Cmd Ans	N	Command Answer with bytes length value.

0x44	On		0	On Sequence (card_On).
0x45	Off		0	Off Sequence (card_Off).

 *----------------------------------------------------------------------*/


#ifdef __cplusplus
}
#endif
#endif


