/**********************************************************************
                CARD TEST AND MEASUREMENTS C-INTERFACE
 **********************************************************************
 Copyright (c) SMARTWARE, 2003 - 2013 All Rights Reserved.
 **********************************************************************
 12/07/2013 - DM v2r10a : From v2r06a. CARDTM is an independant package;
		Remove obsolete card_ParityErrSet and card_IOTestSet methods
 25/10/2007 - DM v2r06a : Add card_PerTransceive method
 17/01/2007 - DM v2r05a : Add Data Acquisition Bit level defines and Parity error information 
                for a contact interface.
 17/01/2007 - DM v2r04a : From v2r03c
 21/11/2005 - DM v2r03c : Update define card_EvtExtOutput for both ICC & PICC. Add Error codes
 20/09/2005 - DM v2r03b : Add card_AcqEnvelope
 28/06/2005 - DM v2r03a : Add card_TestCase and cardtm_CfgSet, Update cardtm_CfgType
                Fix all defines using old hwicp declaration
 01/12/2004 - DM v2r02a : Add card_IOTestSet and cardtm_Init; Add Defines for Innovatron Cards
 16/08/2004 - DM v2r01a : Change uchar to ulong for main arguments of methods;
                Replace TypeC defines by FeliCa defines; Add Acquisition defines for US-PICC;
                Remove _ExtIoSet, _DrvInfoGet, _ErrMsg methods; Create from previous CardEx files; 

 10/06/2004 - DM v1r05 : Add comments in card_PERBLockSet Function
 17/05/2004 - DM v1r04 : Add PerBlockIter parameter in card_PERBLockSet Function
 10/05/2004 - DM v1r03 : Add Data Aquisition Methods, Update Parity Errors Methods
 11/02/2004 - DM v1r02 : Add Event Generator Defines: card_EvtClkOff, card_EvtTxStart, card_EvtRxStart 
 14/11/2003 - FH v1r01 : Creation
  **********************************************************************/
#ifndef cardtm_h
#define cardtm_h

#ifdef __cplusplus
extern "C" {
#endif

#include "../MLOS/err.h"


/*----------------------------------------------------------------------*
                CARDTM Error Code
 *----------------------------------------------------------------------*/

#define cardtm__Err		1400    // CARDTM base Error. DO NOT MODIFY
#define cardtm__CdTestLd	(cardtm__Err + 1)  // CDTEST not loaded
#define cardtm__CardObj		(cardtm__Err + 2)  // CDTEST Card Object Mismatch
#define cardtm__LgIn		(cardtm__Err + 3)  // Input Length incorrect
#define cardtm__Arg		(cardtm__Err + 4)  // Invalid Argument 
#define cardtm__Tag		(cardtm__Err + 8)  // Invalid TLV Tag
#define cardtm__Busy		(cardtm__Err + 10) // CDTEST Task on working
#define cardtm__TrigDisable	(cardtm__Err + 11) // CDTEST Task Disable


/************************************************************************
 ************************************************************************
	CARDTM INITIALIZATION AND CONFIGURATION METHODS
 ************************************************************************
 ************************************************************************/

/*----------------------------------------------------------------------*
  cardtm_Init : Initialize CARDTM application.
 *----------------------------------------------------------------------*/
typedef struct {
  unsigned SizeOf;		// == sizeof(cardtm_CfgType)
  char CardDllPath[256+1]; 	// .CARD DLL file or "" 
  unsigned long Mode;		// Mode and parameter mask
  void * Params;		// Specific parameters
  unsigned ParamsSize;		// Size in bytes or 0
} cardtm_CfgType;


err_Type cardtm_Init(
        cardtm_CfgType * Cfg
        );

/*----------------------------------------------------------------------*
  cardtm_CfgSet : Configure CARDTM application
 *----------------------------------------------------------------------*/
//#define cardtm_CfgCdTestPath	1
#define cardtm_CfgCdTestTO 	2
//#define cardtm_CfgCdTestEnd	3

extern
err_Type cardtm_CfgSet(
        ulong CfgDef,	// (In) Configuration parameter
        uchar *pBuf,	// (In) Parameter's buffer
        ulong BufLg	// (In) Parameter's buffer length
        );



/************************************************************************
 ************************************************************************
	TIME MEASUREMENT
 ************************************************************************
 ************************************************************************/

/*----------------------------------------------------------------------*
  card_TMeasSet: Set Time Measurement

  Measure the Time in clock counts between 2 conditions
  A condition is a reached signal's occurence value.
 *----------------------------------------------------------------------*/
// Contact interface enable condition signals
#define card_TMEnTxStart   	1  // Leading-edge of a transmitted character
#define card_TMEnTxEnd     	0  // End of a transmitted character (end of parity bit)
#define card_TMEnRxStart   	3  // Leading-edge of a received character
#define card_TMEnReset      	2  // Rising-edge of Reset signal (C2 contact)

// Contactless interface enable condition signals
#define card_TMEnFramePulses	0  // Significant pulses during a frame

// Contact interface disable condition signals
#define card_TMDisTxStart  	0  // Leading-edge of a transmitted character
#define card_TMDisTxEnd    	2  // End of a transmitted character (end of parity bit)
#define card_TMDisRxStart  	1  // Leading-edge of a received character

// Contactless interface disable condition signals
#define card_TMDisFramePulses	0  // Significant pulses during a frame

// High level pulse naming for US-PICC tearing and time measurement,
// to use as the occurence value of the frame pulse condition signals
#define card_TypeA_TxSOCStart	1  // Start of SOC in transmission
#define card_TypeA_TxSOCEnd	2  // End of SOC in transmission
#define card_TypeA_TxEOCStart	3  // Start of EOC in transmission
#define card_TypeA_TxEOCEnd	4  // End of EOC in transmission
#define card_TypeA_RxSOCStart	5  // Start of SOC in reception
#define card_TypeA_RxEOCEnd	6  // End of SOC in reception

#define card_TypeB_TxSOFStart	1  // Start of SOF in transmission
#define card_TypeB_TxSOFEnd	2  // End of SOF in transmission
#define card_TypeB_TxEOFStart	3  // Start of EOF in transmission
#define card_TypeB_TxEOFEnd	4  // End of EOF in transmission
#define card_TypeB_RxTR1Start	5  // Start of TR1 in reception
#define card_TypeB_RxSOFStart	6  // Start of SOF in reception
#define card_TypeB_RxSOFEnd	7  // End of SOF in reception
#define card_TypeB_RxEOFEnd	8  // End of EOF in reception

#define card_FeliCa_TxPacketStart  1  // Start of packet in transmission
#define card_FeliCa_TxSynchStart   2  // Start of Sync word "0xB24D" in transmission
#define card_FeliCa_TxPacketEnd    3  // End of packet in transmission
#define card_FeliCa_RxPacketStart  4  // Start of packet in reception
#define card_FeliCa_RxSynchStart   5  // Start of Sync word "0xB24D" in reception
#define card_FeliCa_RxPacketEnd    6  // End of packet in reception

#define card_Inno_TxSOFStart	1  // Start of SOF in transmission
#define card_Inno_TxSOFEnd	2  // End of SOF in transmission
#define card_Inno_TxEOFStart	3  // Start of EOF in transmission
#define card_Inno_TxEOFEnd 	4  // End of EOF in transmission
#define card_Inno_RxTR1Start	5  // Start of TR1 in reception
#define card_Inno_RxDataStart	6  // Start of Data in reception
#define card_Inno_RxDataEnd	7  // End of Data in reception


extern
err_Type card_TMeasSet( 
        card_Ref Obj,
        ulong EnSig,	// (In) Enable condition 
        ulong EnCntVal,	// (In) Enable condition occurence
        ulong DisSig,	// (In) Disable condition
        ulong DisCntVal	// (In) Disable condition occurence
        );

/*----------------------------------------------------------------------*
  card_TMeasSet: Get Time Measurement

  Get measurement result in clock counts
 *----------------------------------------------------------------------*/
extern
err_Type card_TMeasGet(
        card_Ref Obj,
        ulong *Result	// (Out) Time measurement result
        );


/************************************************************************
 ************************************************************************
	EVENT GENERATOR
 ************************************************************************
 ************************************************************************/

/*----------------------------------------------------------------------*
  card_EvtGenSet: Set Event Generator

  Generate some events during a card communication.
  The activation' condition is a reached signal's occurence value.
  A delay can be set between the activated condition and the generation 
  of the event.
 *----------------------------------------------------------------------*/
// Event Selection
#define card_EvtPwrDn      1  // Power Down the card (ICC & PICC)
#define card_EvtClkOff     2  // Stop the card clock on C3 contact (ICC)
#define card_EvtExtOutput  8  // Activation of an external output (ICC & PICC)

// Contact interface activation signals
#define card_EvtTxStart	1   // Leading-edge of a transmitted character
#define card_EvtTxEnd	0   // end of a transmitted character (end of parity bit)
#define card_EvtRxStart	2   // Leading-edge of a received character

// Contactless interface activation signal
#define card_EvtFramePulses  0  // Significant pulses during a frame

extern
err_Type card_EvtGenSet(
        card_Ref Obj,
        ulong EvtSel,	// (In) Event selection
        ulong ActSig,	// (In) Activation signal 
        ulong ActCnt,	// (In) Activation signal occurence
        ulong TimerVal	// (In) Delay in clock counts
        );

/*----------------------------------------------------------------------*
  card_EvtGenDisable: Disable Event Generator
 *----------------------------------------------------------------------*/
extern
err_Type card_EvtGenDisable(
        card_Ref Obj
        );



/************************************************************************
 ************************************************************************
	DATA AQUISITION
 ************************************************************************
 ************************************************************************/

/*----------------------------------------------------------------------*
  card_AcqDataSet: Enable Data Acquisition
 *----------------------------------------------------------------------*/

// Aquisition Selection
#define card_AcqIO      0x01   // I/O signal state on C7       (ICC)
#define card_AcqVcc     0x02   // Voltage switch on/off on C1  (ICC)
#define card_AcqRst     0x04   // Reset signal state on C2     (ICC)
#define card_AcqClk     0x08   // Clock switch on/off on C3    (ICC)
#define card_AcqByte    0x20   // Leading-Edge of Start of Bit (ICC)

#define card_AcqEnvelope     0x01  // Modulated envelope in Tx and Rx (PICC)
#define card_AcqFramePulses  0x20  // Leading-Edge of Frame Pulses    (PICC)

#define card_AcqInfPer   0x40  // Info: Parity Error in Tx or Rx (ICC)
#define card_AcqInfTxRx  0x80  // Info: Tx (0) or Rx (1) acquisition (ICC & PICC)

extern
err_Type card_AcqDataSet( 
        card_Ref Obj,
        ulong AcqSel	// (In) Acquisition selection
        );

/*----------------------------------------------------------------------*
  card_AcqDataGet: Get Data Acquisition
 *----------------------------------------------------------------------*/
extern
err_Type card_AcqDataGet( 
        card_Ref Obj,
        ulong *LngInOut, // (In) Max. length, (Out) returned length
        uchar *pBufOut   // (Out) Acquired data
        );

/*----------------------------------------------------------------------*
  card_AcqDataDisable: Disable Data Acquisition
 *----------------------------------------------------------------------*/
extern
err_Type card_AcqDataDisable( 
        card_Ref Obj
        );


/************************************************************************
 ************************************************************************
	TEST CASES : EMBEDDED SCENARIOS
 ************************************************************************
 ************************************************************************/

/*----------------------------------------------------------------------*
  card_TestCase: Process embedded scenarios
 *----------------------------------------------------------------------*/
extern
err_Type card_TestCase(
        card_Ref Obj,
        ulong TestNb,    // (In) Test Case number
        uchar *pBufIn,   // (In) Additional data for test
        ulong LngIn,     // (In) Additional data length
        uchar *pBufOut,  // (Out) Response data buffer
        ulong *pLngOut   // (In) Max. length, (Out) Response length
        );


/************************************************************************
 ************************************************************************
	PARITY ERRORS GENERATION
 ************************************************************************
 ************************************************************************/

/*----------------------------------------------------------------------*
  card_PerTransceive: Transceive command with parity errors

  ISO14443-A contactless interface inly
 *----------------------------------------------------------------------*/
#define card_ParityCorrect  0
#define card_ParityError    1

extern
err_Type card_PerTransceive(
        card_Ref Obj,
        ulong Mode,	// (In) Mode
        uchar *DBufIn,	// (In) Data buffer to send
        uchar *PBufIn,	// (In) Associate Parity state buffer
        ulong LgIn,	// (In) Data length to send
        uchar *BufOut,	// (Out) Received data buffer
        ulong *pLgOut	// (In) Max. length, (Out) returned length
        );

/*----------------------------------------------------------------------*
  card_PERByteSet: Set Parity Error on Tx/Rx Bytes

  ISO7816-3 contact interface only - Protocol T=0

  This Method is used in T=0 to generate TxPer Errors on all bytes 
  transmitted and send Rxper Error Signals on all bytes received.
  In Transmission, each byte is sent TxPer times with a wrong Parity Bit 
  before sending it correctly.
  In Reception, for each byte the reader will simulate a parity error 
  by asking RxPer retries before accepting it.
 *----------------------------------------------------------------------*/
extern
err_Type card_PERByteSet (
        card_Ref Obj,
        ulong RxPer,	// (In) Number of parity error in reception
        ulong TxPer	// (In) Number of parity error in transmission
        );

/*----------------------------------------------------------------------*
  card_PERBlockSet: Set Parity Errors in a transmitted Block

  ISO7816-3 contact interface only - Protocol T=1

  This Method is used in T=1 to insert some parity errors in a 
  transmitted Block.
  Parity Errors is activated after "TxEnOcc" bytes in the Block and only 
  for the next "TxPerIter" Bytes.
  The Block with Parity Errors is repeating "PerBlockIter" times, before 
  being sent without errors.
 *----------------------------------------------------------------------*/
extern
err_Type card_PERBlockSet (
        card_Ref Obj,
        ulong TxEnOcc,	   // (In) Number of 1st good bytes in the block
        ulong TxPerIter,   // (In) Number of following bad bytes in the block
        ulong PerBlockIter // (In) Number of bad transmission of the block
        );

/*----------------------------------------------------------------------*
  card_PERDisable: Disable Parity Error Generation
 *----------------------------------------------------------------------*/
extern
err_Type card_PERDisable (
        card_Ref Obj
        );


/*----------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif
#endif
