/***********************************************************************
		SYStem parameters
		Object identifiers
		For card
 ***********************************************************************
 Copyright (c) SMARTWARE, 1999 - 2015 All Rights Reserved.
 ***********************************************************************
 21/01/2015 - DM v2r20m: Update list of contact and contactless interfaces
 22/06/2011 - DM v2r20a: From v2r09a
 22/06/2005 - DM v2r09a: Shift all sysobj Ops in syscx.h
 22/02/2005 - DM v2r08c:Add sysc_ModelNull;
 29/11/2004 - DM v2r08b:Add sys_CdCfgCdCk;
 20/10/2004 - DM v2r08a: Add sys_CdCfgPICCIDGet, sys_CdCfgSysInfoGet;
                Remove unused defines;
 16/06/2004 - DM v2r07a: Add Card Object Codes, sys_CdCfgDrvName,
                                            Add sys_CdCfgT1APDU, remove sys_CdCfgPICCATSCmd
 26/04/2004 - RA v2r07a: Add sys_CdCfgPICCTuneCfg and sys_CdCfgPICCBaurateCfg
 25/03/2004 - DM v2r06a: Add cdisof_ModelId, sys_CdCfgTransceive, sys_CdCfgProtoX, 
                                            Add sys_CdCfgHwiCfg, sys_CdCfgFreqGet
 16/12/2003 - RA v2r05n : Add sys_CdCfgTrace
 20/10/2003 - RA v2r05l : Add sys_CdCfgPICCPPSX,sys_CdCfgPICCRFOnWait sys_CdCfgPICCRFOffWait
 07/06/2003 - RA v2r05k : Add sys_CdCfgPICCFreqX and cdtypeap_ModelId , ModelId	A',15693,ICode
 07/06/2003 - ML v2r05i : Add card models
 27/06/2003 - RA v2r05f : Add sys_CdCfgPICCTuneMode 
 17/06/2003 - RA v2r05e : Add sys_CdCfgPICCTuneGain
 05/06/2003 - RA v2r05c : sys_CdpiccId 0x40 (before 0x30)
 22/02/2003 - SD v2r02q : Add sys_xxxx sub code for PICC
 08/11/2002 - SD v2r02m : Add sys_CdCfgByteErr
 22/07/2002 - SD v2r02k : Add sys_CdCfgParity, sys_CdCfgFlowCtrl
 04/12/2001 - SD v2r02g : Add sys_CdCfgCardDetect
 13/03/2001 - SD v2r02c : Add BGT for EMV
 28/12/2000 - SD v2r01  : Add sys_CdCfgETUReset
 15/06/2000 - SD v1r17a : Add sys_CdCfgVppIdle, sys_CdCfgInitDef
 14/04/1999 - SD        : Add sys_CdCfgProto,sys_CdCfgLastErr
 ***********************************************************************/
#ifndef sysc_h
#define sysc_h

#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------*
		Card Object Codes
 *----------------------------------------------------------------------*/

/* Contact Interfaces */
#define sys_CdId     	0x10	// Secu card
#define sys_CdpId   	0x18	// Perso card

#define sys_Cd1Id  	0x10	// Contact Card 1
#define sys_Cd2Id  	0x18	// Contact Card 2
#define sys_Cd3Id  	0x20	// Contact Card 3
#define sys_Cd4Id  	0x28	// Contact Card 4
#define sys_Cd5Id  	0xD0	// Contact Card 5
#define sys_Cd6Id  	0xD8	// Contact Card 6
#define sys_Cd7Id  	0xC0	// Contact Card 7
#define sys_Cd8Id  	0xC8	// Contact Card 8

/* Contactless Interfaces */
#define sys_CdP1Id	0x40	// Proximity Card 1
#define sys_CdP2Id	0x48	// Proximity Card 2
#define sys_CdP3Id	0xB0	// Proximity Card 3
#define sys_CdP4Id	0xB8	// Proximity Card 4
#define sys_CdP5Id	0x60	// Proximity Card 5
#define sys_CdP6Id	0x68	// Proximity Card 6
#define sys_CdP7Id	0xE8	// Proximity Card 7
#define sys_CdP8Id	0xF8	// Proximity Card 8


#ifdef __cplusplus
}
#endif

#endif
