/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * SCR2 specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>
#include <phhalHwContact.h>
#include <ph_RefDefs.h>
#include <phTools.h>

#ifdef NXPBUILD__PHHAL_HW_CONTACT_RDSCR2

#include "phhalHwContact_RdScr2_Cmd.h"
#include "phhalHwContact_RdScr2_Int.h"

phStatus_t phhalHwContact_RdScr2_Cmd_Trigger(
    phhalHwContact_RdScr2_DataParams_t * pDataParams,
    uint8_t bTriggerPort,
    uint32_t dwConfig,
    float64_t dValue
    )
{
    phStatus_t  PH_MEMLOC_REM statusTmp;

    /* Parameter Check */
    if (bTriggerPort != 1 && bTriggerPort != 2)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_PARAMETER, PH_COMP_HAL);
    }
    /* Other parameter are checked within the SCR2 API and will return error SCR2_E_PARAM_ERROR */

    if (bTriggerPort == 1)
    {
        PH_CHECK_SUCCESS_FCT(statusTmp, phhalHwContact_RdScr2_Int_ConvertError(pDataParams->pBalDataParams->pfTriggerSetPort1(dwConfig)));
    }
    else
    {
        PH_CHECK_SUCCESS_FCT(statusTmp, phhalHwContact_RdScr2_Int_ConvertError(pDataParams->pBalDataParams->pfTriggerSetPort2(dwConfig)));
    }

    if (dwConfig == SCR2_TRIG_ICC_LEVEL)
    {
        PH_CHECK_SUCCESS_FCT(statusTmp, phhalHwContact_RdScr2_Int_ConvertError(pDataParams->pBalDataParams->pfTriggerSetIccValue(dValue)));
    }
    if (dwConfig == SCR2_TRIG_VTP_LEVEL)
    {
        PH_CHECK_SUCCESS_FCT(statusTmp, phhalHwContact_RdScr2_Int_ConvertError(pDataParams->pBalDataParams->pfTriggerSetVtpValue(dValue)));
    }
    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_HAL);
}

phStatus_t phhalHwContact_RdScr2_Cmd_ConfigTriggeredExchange(
    phhalHwContact_RdScr2_DataParams_t * pDataParams,
    uint8_t bTriggerPort,
    uint32_t dwHwInterface,
    uint32_t dwTriggerMode
    )
{
    phStatus_t  PH_MEMLOC_REM statusTmp;

    /* Parameter Check */
    if (bTriggerPort != 1 && bTriggerPort != 2)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_PARAMETER, PH_COMP_HAL);
    }
    /* Other parameter are checked within the SCR2 API and will return error SCR2_E_PARAM_ERROR */

    if (bTriggerPort == 1)
    {
        PH_CHECK_SUCCESS_FCT(statusTmp, phhalHwContact_RdScr2_Int_ConvertError(pDataParams->pBalDataParams->pfTriggerSetHwInterfaceWait1(dwHwInterface, dwTriggerMode)));
    }
    else
    {
        PH_CHECK_SUCCESS_FCT(statusTmp, phhalHwContact_RdScr2_Int_ConvertError(pDataParams->pBalDataParams->pfTriggerSetHwInterfaceWait2(dwHwInterface, dwTriggerMode)));
    }
    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_HAL);
}

phStatus_t phhalHwContact_RdScr2_Cmd_TdaClearTriggers(
    phhalHwContact_RdScr2_DataParams_t * pDataParams
    )
{
    PH_ASSERT_NULL (pDataParams);
    return phhalHwContact_RdScr2_Int_ConvertError(pDataParams->pBalDataParams->pfTdaClearTriggers());
}

phStatus_t phhalHwContact_RdScr2_Cmd_TdaSetTrigger(
    phhalHwContact_RdScr2_DataParams_t * pDataParams,
    uint32_t dwTriggerSelect,
    uint32_t dwTriggerSource,
    uint32_t dwTriggerDelay,
    uint32_t dwTriggerAction
    )
{
    PH_ASSERT_NULL (pDataParams);
    return phhalHwContact_RdScr2_Int_ConvertError(pDataParams->pBalDataParams->pfTdaSetTrigger(dwTriggerSelect, dwTriggerSource, dwTriggerDelay, dwTriggerAction));
}

phStatus_t phhalHwContact_RdScr2_Cmd_TdaStart(
    phhalHwContact_RdScr2_DataParams_t * pDataParams,
    uint32_t dwTimeoutUs,
    uint32_t dwAbortConditions
    )
{
    PH_ASSERT_NULL (pDataParams);
    return phhalHwContact_RdScr2_Int_ConvertError(pDataParams->pBalDataParams->pfTdaStart(dwTimeoutUs, dwAbortConditions));
}

phStatus_t phhalHwContact_RdScr2_Cmd_TdaStop(
    phhalHwContact_RdScr2_DataParams_t * pDataParams
    )
{
    PH_ASSERT_NULL (pDataParams);
    return phhalHwContact_RdScr2_Int_ConvertError(pDataParams->pBalDataParams->pfTdaStop());
}

phStatus_t phhalHwContact_RdScr2_Cmd_TdaGetStatus(
    phhalHwContact_RdScr2_DataParams_t * pDataParams,
    uint32_t * pTdaStatus
    )
{
    PH_ASSERT_NULL (pDataParams);
    return phhalHwContact_RdScr2_Int_ConvertError(pDataParams->pBalDataParams->pfTdaGetStatus(pTdaStatus));
}
#endif /* NXPBUILD__PHHAL_HW_CONTACT_RDSCR2 */
