/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * RC523 specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phhalHwContact.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHHAL_HW_CONTACT_CALLBACK

#include "phhalHwContact_Callback.h"

phStatus_t phhalHwContact_Callback_Init(
                                        phhalHwContact_Callback_DataParams_t * pDataParams,
                                        uint16_t wSizeOfDataParams,
                                        cbExchange pExchangeCb,
                                        cbApplyProtocolSettingsAtr pApplyProtocolSettingsCb,
                                        cbSetConfig32 pSetConfig32Cb,
                                        cbGetConfig32 pGetConfig32Cb,
                                        cbActivate pActivateCb,
                                        cbDeactivate pDeactivateCb,
                                        cbClockStop pClockStopCb,
                                        cbWait pWaitCb,
                                        cbInitContactReader pInitContactReader,
                                        void * pCallbackContext
                                        )
{
    if (sizeof(phhalHwContact_Callback_DataParams_t) != wSizeOfDataParams)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
    }
    PH_ASSERT_NULL (pDataParams);

    pDataParams->wId                        = PH_COMP_HAL | PHHAL_HW_CONTACT_CALLBACK_ID;
    pDataParams->pExchangeCb                = pExchangeCb;
    pDataParams->pApplyProtocolSettingsCb   = pApplyProtocolSettingsCb;
    pDataParams->pSetConfig32Cb             = pSetConfig32Cb;
    pDataParams->pGetConfig32Cb             = pGetConfig32Cb;
    pDataParams->pActivateCb                = pActivateCb;
    pDataParams->pDeactivateCb              = pDeactivateCb;
    pDataParams->pClockStopCb               = pClockStopCb;
    pDataParams->pWaitCb                    = pWaitCb;
    pDataParams->pInitContactReader         = pInitContactReader;
    pDataParams->pCbContext                 = pCallbackContext;

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_HAL);
}

phStatus_t phhalHwContact_Callback_Exchange(
    phhalHwContact_Callback_DataParams_t * pDataParams,
    uint16_t wOption,
    uint8_t * pTxBuffer,
    uint16_t wTxLength,
    uint8_t ** ppRxBuffer,
    uint16_t * pRxLength
    )
{
    uint16_t    PH_MEMLOC_REM RxLength;
    uint8_t *   PH_MEMLOC_REM pRxBuffer;

    /* Check if caller has provided valid RxBuffer */
    if (ppRxBuffer == NULL)
    {
        ppRxBuffer = &pRxBuffer;
    }
    if (pRxLength == NULL)
    {
        pRxLength = &RxLength;
    }

    if (pDataParams->pExchangeCb == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_HAL);
    }

    return (*pDataParams->pExchangeCb)(wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength, pDataParams->pCbContext);
}

phStatus_t phhalHwContact_Callback_ApplyProtocolSettings(
    phhalHwContact_Callback_DataParams_t * pDataParams,
    uint8_t * pAtr,
    uint16_t dwAtrLength,
    uint8_t bProtocolType
    )
{
    if (pDataParams->pApplyProtocolSettingsCb)
    {
        return (*pDataParams->pApplyProtocolSettingsCb)(pAtr, dwAtrLength, bProtocolType, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_HAL);
    }
}

phStatus_t phhalHwContact_Callback_SetConfig32(
    phhalHwContact_Callback_DataParams_t * pDataParams,
    uint16_t wConfig,
    uint32_t dwValue
    )
{
    if (pDataParams->pSetConfig32Cb)
    {
        return (*pDataParams->pSetConfig32Cb)(wConfig, dwValue, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_HAL);
    }
}

phStatus_t phhalHwContact_Callback_GetConfig32(
    phhalHwContact_Callback_DataParams_t * pDataParams,
    uint16_t wConfig,
    uint32_t * pdwValue
    )
{
    if (pDataParams->pGetConfig32Cb)
    {
        return (*pDataParams->pGetConfig32Cb)(wConfig, pdwValue, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_HAL);
    }
}

phStatus_t phhalHwContact_Callback_Activate(
    phhalHwContact_Callback_DataParams_t * pDataParams,
    uint8_t * pATRBuffer,
    uint16_t * pwATRLength
    )
{
    if (pDataParams->pActivateCb)
    {
        return (*pDataParams->pActivateCb)(pATRBuffer, pwATRLength, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_HAL);
    }
}

phStatus_t phhalHwContact_Callback_Deactivate(
    phhalHwContact_Callback_DataParams_t * pDataParams
    )
{
    if (pDataParams->pDeactivateCb)
    {
        return (*pDataParams->pDeactivateCb)(pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_HAL);
    }
}

phStatus_t phhalHwContact_Callback_ClockStop(
    phhalHwContact_Callback_DataParams_t * pDataParams,
    uint16_t wTgClockCount,
    uint16_t wThClockCount,
    uint32_t dwPinState
    )
{
    if (pDataParams->pClockStopCb)
    {
        return (*pDataParams->pClockStopCb)(wTgClockCount, wThClockCount, dwPinState, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_HAL);
    }
}

phStatus_t phhalHwContact_Callback_Wait(
    phhalHwContact_Callback_DataParams_t * pDataParams,
    uint8_t bUnit,
    uint16_t wTimeout
    )
{
    if (pDataParams->pWaitCb)
    {
        return (*pDataParams->pWaitCb)(bUnit, wTimeout, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_HAL);
    }
}

phStatus_t phhalHwContact_Callback_InitContactReader(
                                                     phhalHwContact_Callback_DataParams_t * pDataParams
                                                     )
{
    if (pDataParams->pInitContactReader)
    {
        return (*pDataParams->pInitContactReader)(pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_HAL);
    }
}

#endif /* NXPBUILD__PHHAL_HW_CONTACT_CALLBACK */
