/*
 * Copyright 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for ProxiLAB Reader specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#pragma once
#ifndef PHHALHW_PROXILAB_INT_H
#define PHHALHW_PROXILAB_INT_H

#include <ph_Status.h>

#ifdef __cplusplus
extern "C" {
#endif

phStatus_t phhalHw_ProxiLAB_Int_FieldOn(
                                    phhalHw_ProxiLAB_DataParams_t * pDataParams
                                    );

phStatus_t phhalHw_ProxiLAB_Int_FieldOff(
                                     phhalHw_ProxiLAB_DataParams_t * pDataParams
                                     );

phStatus_t phhalHw_ProxiLAB_Int_FieldReset(
                                       phhalHw_ProxiLAB_DataParams_t * pDataParams
                                       );

phStatus_t phhalHw_ProxiLAB_Int_SetConfig(
                                      phhalHw_ProxiLAB_DataParams_t * pDataParams,
                                      uint16_t wConfig,
                                      uint16_t wValue
                                      );

phStatus_t phhalHw_ProxiLAB_Int_GetConfig(
                                      phhalHw_ProxiLAB_DataParams_t * pDataParams,
                                      uint16_t wConfig,
                                      uint16_t * pValue
                                      );

phStatus_t phhalHw_ProxiLAB_Int_ConvertError(phhalHw_ProxiLAB_DataParams_t * pDataParams,
                                             uint32_t status);

phStatus_t phhalHw_ProxiLAB_Int_Wait(
                                 phhalHw_ProxiLAB_DataParams_t * pDataParams,
                                 uint8_t bUnit,
                                 uint16_t wTimeout
                                 );

phStatus_t phhalHw_ProxiLAB_Int_Exchange(
                                      phhalHw_ProxiLAB_DataParams_t * pDataParams,
                                      uint8_t * pTxBuffer,
                                      uint16_t wTxLength,
                                      uint16_t wRxBufSize,
                                      uint8_t * pRxBuffer,
                                      uint16_t * pRxLength
                                      );

phStatus_t phhalHw_ProxiLAB_Int_GetTxBuffer(
                                     phhalHw_ProxiLAB_DataParams_t * pDataParams,
                                     uint8_t ** pTxBuffer,
                                     uint16_t * pTxBufferLen,
                                     uint16_t * pTxBufferSize
                                     );

phStatus_t phhalHw_ProxiLAB_Int_GetRxBuffer(
                                     phhalHw_ProxiLAB_DataParams_t * pDataParams,
                                     uint8_t ** pRxBuffer,
                                     uint16_t * pRxBufferLen,
                                     uint16_t * pRxBufferSize
                                     );

phStatus_t phhalHw_ProxiLAB_Int_CheckCrc(
                                  phhalHw_ProxiLAB_DataParams_t * pDataParams,
                                  uint8_t * pRxBuffer, uint16_t *pRxLength
                                  );
#ifdef __cplusplus
}
#endif
#endif /* PHHALHW_PROXILAB_INT_H */
