/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Hal DUT specific definition of Contact Card (CC) commands.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7463 $
 * $Date: 2025-08-29 15:56:52 +0530 (Fri, 29 Aug 2025) $
 *
 * History:
 *   Created On 8 July, 2022
 *
 */

#include <ph_Status.h>

#ifdef NXPBUILD__PHHAL_HW_DUT_CMD_CC

#include <ph_RefDefs.h>
#include <phhalHw_DUT_Cmd.h>

#include "../phhalHw_DUT.h"

phStatus_t phhalHw_DUT_Cmd_CC_Activate(phhalHw_DUT_DataParams_t * pDataParams, uint8_t * pAtr, uint16_t * pAtrLen)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;
    uint8_t *   PH_MEMLOC_REM pResponse = NULL;

    PH_CHECK_SUCCESS_FCT(wStatus, PHHALHW_DUT_INT(
        pDataParams,
        PHHAL_HW_DUT_CMD_CC_ACTIVATE,
        PH_EXCHANGE_DEFAULT,
        NULL,
        0,
        &pResponse,
        pAtrLen));

    (void) memcpy(pAtr, pResponse, *pAtrLen);

    return PH_ERR_SUCCESS;
}

phStatus_t phhalHw_DUT_Cmd_CC_ColdReset(phhalHw_DUT_DataParams_t * pDataParams, uint8_t * pAtr, uint16_t * pAtrLen)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;
    uint8_t *   PH_MEMLOC_REM pResponse = NULL;

    PH_CHECK_SUCCESS_FCT(wStatus, PHHALHW_DUT_INT(
        pDataParams,
        PHHAL_HW_DUT_CMD_CC_COLD_RESET,
        PH_EXCHANGE_DEFAULT,
        NULL,
        0,
        &pResponse,
        pAtrLen));

    (void) memcpy(pAtr, pResponse, *pAtrLen);

    return PH_ERR_SUCCESS;
}

phStatus_t phhalHw_DUT_Cmd_CC_WarmReset(phhalHw_DUT_DataParams_t * pDataParams, uint8_t * pAtr, uint16_t * pAtrLen)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;
    uint8_t *   PH_MEMLOC_REM pResponse = NULL;

    PH_CHECK_SUCCESS_FCT(wStatus, PHHALHW_DUT_INT(
        pDataParams,
        PHHAL_HW_DUT_CMD_CC_WARM_RESET,
        PH_EXCHANGE_DEFAULT,
        NULL,
        0,
        &pResponse,
        pAtrLen));

    (void) memcpy(pAtr, pResponse, *pAtrLen);

    return PH_ERR_SUCCESS;
}

phStatus_t phhalHw_DUT_Cmd_CC_StopClock(phhalHw_DUT_DataParams_t * pDataParams)
{
    return PHHALHW_DUT_INT(
        pDataParams,
        PHHAL_HW_DUT_CMD_CC_STOP_CLOCK,
        PH_EXCHANGE_DEFAULT,
        NULL,
        0,
        NULL,
        NULL);
}

phStatus_t phhalHw_DUT_Cmd_CC_StartClock(phhalHw_DUT_DataParams_t * pDataParams)
{
    return PHHALHW_DUT_INT(
        pDataParams,
        PHHAL_HW_DUT_CMD_CC_START_CLOCK,
        PH_EXCHANGE_DEFAULT,
        NULL,
        0,
        NULL,
        NULL);
}

phStatus_t phhalHw_DUT_Cmd_CC_Deactivate(phhalHw_DUT_DataParams_t * pDataParams)
{
    return PHHALHW_DUT_INT(
        pDataParams,
        PHHAL_HW_DUT_CMD_CC_DEACTIVATE,
        PH_EXCHANGE_DEFAULT,
        NULL,
        0,
        NULL,
        NULL);
}

phStatus_t phhalHw_DUT_Cmd_CC_PresenceCheck(phhalHw_DUT_DataParams_t * pDataParams, uint8_t * pCardInserted)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;
    uint8_t *   PH_MEMLOC_REM pResponse = NULL;
    uint16_t    PH_MEMLOC_REM wRspLen = 0;

    PH_CHECK_SUCCESS_FCT(wStatus, PHHALHW_DUT_INT(
        pDataParams,
        PHHAL_HW_DUT_CMD_CC_PRESENCE_CHECK,
        PH_EXCHANGE_DEFAULT,
        NULL,
        0,
        &pResponse,
        &wRspLen));

    if(wRspLen != 1U)
    {
        return PH_ADD_COMPCODE(PH_ERR_PROTOCOL_ERROR, PH_COMP_HAL);
    }

    *pCardInserted = pResponse[0];

    return PH_ERR_SUCCESS;
}

phStatus_t phhalHw_DUT_Cmd_CC_TransmitData(phhalHw_DUT_DataParams_t * pDataParams, uint8_t * pTxBuff, uint16_t wTxLen,
    uint8_t ** ppRxBuff, uint16_t * pRxLen)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;
    uint8_t *   PH_MEMLOC_REM pResponse = NULL;
    uint16_t    PH_MEMLOC_REM wRspLen = 0;

    if(ppRxBuff == NULL)
    {
        ppRxBuff = &pResponse;
    }
    if(pRxLen == NULL)
    {
        pRxLen = &wRspLen;
    }

    PH_CHECK_SUCCESS_FCT(wStatus, PHHALHW_DUT_INT(
        pDataParams,
        PHHAL_HW_DUT_CMD_CC_TRANSMIT_DATA,
        PH_EXCHANGE_DEFAULT,
        pTxBuff,
        wTxLen,
        ppRxBuff,
        pRxLen));

    if(*pRxLen < 2U)
    {
        return PH_ADD_COMPCODE(PH_ERR_PROTOCOL_ERROR, PH_COMP_HAL);
    }

    *ppRxBuff = &((*ppRxBuff)[2]);              /* Omit the first two bytes */
    *pRxLen = *pRxLen - 2;

    return PH_ERR_SUCCESS;
}

phStatus_t phhalHw_DUT_Cmd_CC_SendPPS(phhalHw_DUT_DataParams_t * pDataParams, uint8_t bOption, uint8_t * pPPS, uint8_t * pRxBuff,
    uint16_t * pRxLen)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;
    uint16_t    PH_MEMLOC_REM wPPSLen = 0;
    uint8_t     PH_MEMLOC_REM pTxBuff[5];
    uint8_t *   PH_MEMLOC_REM ppRxBuff = NULL;
    uint16_t    PH_MEMLOC_REM wRspLen = 0;

    /* 0x00 = send PPS,
     * 0x01 = send only the reader speed
     */
    pTxBuff[0] = bOption;

    /* Calculate length */
    wPPSLen = 1;

    /* Check if we also want to send the PPS */
    if((0U == ((bOption & 0x01U))))
    {
        /* PPS1 present */
        if(0U != (pPPS[0] & 0x10U))
        {
            ++wPPSLen;
        }

        /* PPS2 present */
        if(0U != (pPPS[0] & 0x20U))
        {
            ++wPPSLen;
        }

        /* PPS4 present */
        if(0U != (pPPS[0] & 0x40U))
        {
            ++wPPSLen;
        }
    }
    (void) memcpy(pTxBuff + 1U, pPPS, wPPSLen);

    ++wPPSLen; /* include the option byte in the length */

    PH_CHECK_SUCCESS_FCT(wStatus, PHHALHW_DUT_INT(
        pDataParams,
        PHHAL_HW_DUT_CMD_CC_SEND_PPS,
        PH_EXCHANGE_DEFAULT,
        pTxBuff,
        wPPSLen,
        &ppRxBuff,
        &wRspLen));

    if(wPPSLen != wRspLen + 1U)
    {
        return PH_ADD_COMPCODE(PH_ERR_PROTOCOL_ERROR, PH_COMP_HAL);
    }

    (void) memcpy(pRxBuff, ppRxBuff, wRspLen);
    *pRxLen = wRspLen;

    return PH_ERR_SUCCESS;
}

#endif /* NXPBUILD__PHHAL_HW_DUT_CMD_CC */
