/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Hardware Thermostream ATS545 Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLTHSTRM_ATS545_H
#define PHDLTHSTRM_ATS545_H

#include <ph_Status.h>
#include <phdlThstrm.h>

phStatus_t phdlThstrm_ATS545_SetConfig(
                                        phdlThstrm_ATS545_DataParams_t * pDataParams,
                                        uint16_t wIdentifier,
                                        uint16_t dwValue
                                        );

phStatus_t phdlThstrm_ATS545_GetConfig(
                                        phdlThstrm_ATS545_DataParams_t * pDataParams,
                                        uint16_t wIdentifier,
                                        uint16_t * dwValue
                                        );

phStatus_t phdlThstrm_ATS545_PowerOff(
                                       phdlThstrm_ATS545_DataParams_t * pDataParams
                                       );

phStatus_t phdlThstrm_ATS545_SoftReset(
                                        phdlThstrm_ATS545_DataParams_t * pDataParams
                                        );

phStatus_t phdlThstrm_ATS545_InitThstrm(
    phdlThstrm_ATS545_DataParams_t * pDataParams
    );

phStatus_t phdlThstrm_ATS545_WaitTemp(
                                       phdlThstrm_ATS545_DataParams_t * pDataParams
                                       );

#endif /* PHDLTHSTRM_ATS545_H */
