/*
 * Copyright 2019 - 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Stepper Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLSTEPPER_WACHLER_INT_H
#define PHDLSTEPPER_WACHLER_INT_H

#include <ph_Status.h>

phStatus_t phdlStepper_Wachler_Int_Reset(
                                        phdlStepper_Wachler_DataParams_t * pDataParams
                                        );

phStatus_t phdlStepper_Wachler_Int_SetMode(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        uint8_t bMode
                                        );

phStatus_t phdlStepper_Wachler_Int_GetMode(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        uint8_t * pbMode
                                        );

phStatus_t phdlStepper_Wachler_Int_MoveUp(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        uint8_t bBlocking
                                        );

phStatus_t phdlStepper_Wachler_Int_MoveDown(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        uint8_t bBlocking
                                        );

phStatus_t phdlStepper_Wachler_Int_SetPos(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        float fPosition,
                                        uint8_t bBlocking
                                        );

phStatus_t phdlStepper_Wachler_Int_GetPos(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        float *pFloatPosition
                                        );

phStatus_t phdlStepper_Wachler_Int_GetPosMin(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        float *pFloatPosition
                                        );

phStatus_t phdlStepper_Wachler_Int_GetPosMax(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        float *pFloatPosition
                                        );

phStatus_t phdlStepper_Wachler_Int_GetState(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        int32_t *pIntValue
                                        );

phStatus_t phdlStepper_Wachler_Int_SetDelay(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        uint16_t wDelay
                                        );

phStatus_t phdlStepper_Wachler_Int_GetDelay(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        uint16_t * pwDelay
                                        );

phStatus_t phdlStepper_Wachler_Int_SetPwm(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        uint8_t bPwmEnabled
                                        );

phStatus_t phdlStepper_Wachler_Int_SetPwmSpeed(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        uint8_t bPwmSpeed
                                        );

phStatus_t phdlStepper_Wachler_Int_SetPwmCalibration(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        uint8_t bPwmCalibration
                                        );

phStatus_t phdlStepper_Wachler_Int_SetLevel(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        float fLevel
                                        );

phStatus_t phdlStepper_Wachler_Int_GetLevel(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        float * pfLevel
                                        );

phStatus_t phdlStepper_Wachler_Int_GetCounter(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        uint32_t * pdwCounter
                                        );

phStatus_t phdlStepper_Wachler_Int_ResetCounter(
                                        phdlStepper_Wachler_DataParams_t * pDataParams
                                        );

phStatus_t phdlStepper_Wachler_Int_SetRemote(
                                        phdlStepper_Wachler_DataParams_t * pDataParams,
                                        uint8_t bRemote
                                        );

phStatus_t phdlStepper_Wachler_Int_GetIdn(
                                        phdlStepper_Wachler_DataParams_t * pDataParams
                                        );

phStatus_t phdlStepper_Wachler_Int_WaitMoveFinished(
                                        phdlStepper_Wachler_DataParams_t * pDataParams
                                        );

phStatus_t phdlStepper_Wachler_Int_CheckResponseStatus(
                                       uint8_t * pResponse
                                       );

phStatus_t phdlStepper_Wachler_Int_CheckResponseString(
                                       uint8_t * pResponse
                                       );

phStatus_t phdlStepper_Wachler_Int_CheckResponseInt(
                                       uint8_t * pResponse,
                                       int32_t *pInt32Value
                                       );

phStatus_t phdlStepper_Wachler_Int_CheckResponseFloat(
                                       uint8_t * pResponse,
                                       float *pfValue
                                       );

/* Commands for the stepper */
#define PHDL_STEPPER_WACHLER_INT_CMD_MODE                       (uint8_t *)"MODE %s"
#define PHDL_STEPPER_WACHLER_INT_CMD_GET_MODE                   (uint8_t *)"MODE?\r\n"
#define PHDL_STEPPER_WACHLER_INT_MODE_RUN                       (uint8_t *)"RUN\r\n"
#define PHDL_STEPPER_WACHLER_INT_MODE_STOP                      (uint8_t *)"STOP\r\n"
#define PHDL_STEPPER_WACHLER_INT_MODE_CAL                       (uint8_t *)"CAL\r\n"
#define PHDL_STEPPER_WACHLER_INT_MODE_PWMCAL                    (uint8_t *)"PWMCAL\r\n"
#define PHDL_STEPPER_WACHLER_INT_MODE_AUTO                      (uint8_t *)"AUTO\r\n"
#define PHDL_STEPPER_WACHLER_INT_MODE_BSTOP                     (uint8_t *)"BSTOP\r\n"
#define PHDL_STEPPER_WACHLER_INT_MODE_POS                       (uint8_t *)"POS\r\n"

#define PHDL_STEPPER_WACHLER_INT_CMD_POS                        (uint8_t *)"POS %.2f\r\n"
#define PHDL_STEPPER_WACHLER_INT_CMD_POS_UP                     (uint8_t *)"POS UP\r\n"
#define PHDL_STEPPER_WACHLER_INT_CMD_POS_DOWN                   (uint8_t *)"POS DOWN\r\n"
#define PHDL_STEPPER_WACHLER_INT_CMD_GET_POS                    (uint8_t *)"POS?\r\n"
#define PHDL_STEPPER_WACHLER_INT_CMD_GET_POS_MAX                (uint8_t *)"POS:MAX?\r\n"
#define PHDL_STEPPER_WACHLER_INT_CMD_GET_POS_MIN                (uint8_t *)"POS:MIN?\r\n"
#define PHDL_STEPPER_WACHLER_INT_CMD_GET_POS_UP                 (uint8_t *)"POS:UP?\r\n"
#define PHDL_STEPPER_WACHLER_INT_CMD_GET_POS_DOWN               (uint8_t *)"POS:DOWN?\r\n"

#define PHDL_STEPPER_WACHLER_INT_CMD_GET_STATE                  (uint8_t *)"STATE?\r\n"

#define PHDL_STEPPER_WACHLER_INT_CMD_DELAY                      (uint8_t *)"DELAY %d\r\n"
#define PHDL_STEPPER_WACHLER_INT_CMD_GET_DELAY                  (uint8_t *)"DELAY?\r\n"

#define PHDL_STEPPER_WACHLER_INT_CMD_PWM                        (uint8_t *)"PWM %d\r\n"
#define PHDL_STEPPER_WACHLER_INT_CMD_PWM_SPEED                  (uint8_t *)"PWMS %d\r\n"
#define PHDL_STEPPER_WACHLER_INT_CMD_PWM_CALIBRATION            (uint8_t *)"PWMC %d\r\n"

#define PHDL_STEPPER_WACHLER_INT_CMD_LEVEL                      (uint8_t *)"LEVEL %.2f\r\n"
#define PHDL_STEPPER_WACHLER_INT_CMD_GET_LEVEL                  (uint8_t *)"LEVEL?\r\n"

#define PHDL_STEPPER_WACHLER_INT_CMD_GET_COUNTER                (uint8_t *)"COUNTER?\r\n"
#define PHDL_STEPPER_WACHLER_INT_CMD_COUNTER_RESET              (uint8_t *)"COUNTER:RESET\r\n"

#define PHDL_STEPPER_WACHLER_INT_CMD_REMOTE                     (uint8_t *)"REMOTE %d\r\n"

#define PHDL_STEPPER_WACHLER_INT_CMD_GET_IDN                    (uint8_t *)"*IDN?\r\n"

#define PHDL_STEPPER_WACHLER_INT_RESP_OK                        (char *)"OK\r\n"
#define PHDL_STEPPER_WACHLER_INT_RESP_ERR                       (char *)"ERR\r\n"
#define PHDL_STEPPER_WACHLER_INT_RESP_INV                       (char *)"INV\r\n"

#endif /* PHDLSTEPPER_WACHLER_INT_H */
