/*
 * Copyright 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Hardware Steppper HighZ Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLSTEPPER_HIGHZ_H
#define PHDLSTEPPER_HIGHZ_H

#include <ph_Status.h>
#include <phdlStepper.h>

phStatus_t  phdlStepper_HighZ_Initialize(
                                      phdlStepper_HighZ_DataParams_t * pDataParams
                                      );

phStatus_t phdlStepper_HighZ_MoveSteps(
                                    phdlStepper_HighZ_DataParams_t * pDataParams,
                                    uint16_t wSpeed,
                                    uint8_t bDirection,
                                    uint32_t dwSteps,
                                    uint8_t bBlocking
                                    );

phStatus_t phdlStepper_HighZ_MoveDistance(
                                       phdlStepper_HighZ_DataParams_t * pDataParams,
                                       uint16_t wSpeed,
                                       uint8_t bDirection,
                                       uint32_t dwDistance,
                                       uint8_t bBlocking
                                       );

phStatus_t phdlStepper_HighZ_GoToPosition(
                                       phdlStepper_HighZ_DataParams_t * pDataParams,
                                       uint16_t wSpeed,
                                       uint32_t dwPosition,
                                       uint8_t bBlocking
                                       );

phStatus_t phdlStepper_HighZ_SetConfig(
                                    phdlStepper_HighZ_DataParams_t * pDataParams,
                                    uint16_t wConfig,
                                    uint16_t wValue
                                    );

phStatus_t phdlStepper_HighZ_SetConfig32(
                                      phdlStepper_HighZ_DataParams_t * pDataParams,
                                      uint16_t wConfig,
                                      uint32_t dwValue
                                      );

phStatus_t phdlStepper_HighZ_GetConfig(
                                    phdlStepper_HighZ_DataParams_t * pDataParams,
                                    uint16_t wConfig,
                                    uint16_t * pValue
                                    );

phStatus_t phdlStepper_HighZ_GetConfig32(
                                      phdlStepper_HighZ_DataParams_t * pDataParams,
                                      uint16_t wConfig,
                                      uint32_t * pValue
                                      );

#endif /* PHDLSTEPPER_HIGHZ_H */
