/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Hardware Steppper DensoVS60 Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLSTEPPER_DENSOVS60_H
#define PHDLSTEPPER_DENSOVS60_H

#include <ph_Status.h>
#include <phdlStepper.h>


/**
* \brief  Initialize the robot object
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t  phdlStepper_DensoVS60_Initialize(
                                      phdlStepper_DensoVS60_DataParams_t * pDataParams          /**< [In] Pointer to this layer's parameter structure. */
                                      );

/**
* \brief  Move robot by provided number of steps
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlStepper_DensoVS60_MoveSteps(
                                            phdlStepper_DensoVS60_DataParams_t * pDataParams,       /**< [In] Pointer to this layer's parameter structure. */
                                            uint16_t wSpeed,                                        /**< [In] External speed of the robot. */
                                            uint8_t bDirection,                                     /**< [In] ??? */
                                            uint32_t dwSteps,                                       /**< [In] Steps number of the robot. */
                                            uint8_t bBlocking                                       /**< [In] Blocking flag. */
                                          );

/**
* \brief  Move selected distnace with choosen speed,direction and blocking type
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlStepper_DensoVS60_MoveDistance(
                                               phdlStepper_DensoVS60_DataParams_t * pDataParams,    /**< [In] Pointer to this layer's parameter structure. */
                                               uint16_t wSpeed,                                     /**< [In] External speed of the robot. */
                                               uint8_t bDirection,                                  /**< [In] ???. */
                                               uint32_t dwDistance,                                 /**< [In] Length of the distance */
                                               uint8_t bBlocking                                    /**< [In] Blocking flag. */
                                       );

/**
* \brief  Move robot to the particular position
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlStepper_DensoVS60_GoToPosition(
                                               phdlStepper_DensoVS60_DataParams_t * pDataParams,    /**< [In] Pointer to this layer's parameter structure. */
                                               uint16_t wSpeed,                                     /**< [In] External speed of the robot. */
                                               uint32_t dwPosition,                                 /**< [In] Position of the choosen axis */
                                               uint8_t bBlocking                                    /**< [In] Blocking flag. */
                                       );

/**
* \brief  Set config of the specific input
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlStepper_DensoVS60_SetConfig(
                                            phdlStepper_DensoVS60_DataParams_t * pDataParams,       /**< [In] Pointer to this layer's parameter structure. */
                                            uint16_t wConfig,			                            /**< [In] Config type */
                                            uint16_t wValue                                         /**< [In] Config value */
                                          );

/**
* \brief  Set config ot the specific input
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlStepper_DensoVS60_SetConfig32(
                                              phdlStepper_DensoVS60_DataParams_t * pDataParams,		/**< [In] Pointer to this layer's parameter structure. */
                                              uint16_t wConfig,			                            /**< [In] Config type */
                                              uint32_t dwValue                                      /**< [In] Config value */
                                            );

/**
* \brief  Get config of the specific input
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlStepper_DensoVS60_GetConfig(
                                              phdlStepper_DensoVS60_DataParams_t * pDataParams,     /**< [In] Pointer to this layer's parameter structure. */
                                              uint16_t wConfig,				                        /**< [In] Config type */
                                              uint16_t * pValue                                     /**< [In] Config value */
                                          );

/**
* \brief  Get config 32 of the specific input
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phdlStepper_DensoVS60_GetConfig32(
                                              phdlStepper_DensoVS60_DataParams_t * pDataParams,      /**< [In] Pointer to this layer's parameter structure. */
                                              uint16_t wConfig,	   	                                 /**< [In] Config type */
                                              uint32_t * pValue                                      /**< [In] Config value */
                                            );

#endif /* PHDLSTEPPER_DENSOVS60_H */
