/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Generic Spectrum Analyzer R&S FSV Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLSPA_INT_H
#define PHDLSPA_INT_H

#include <ph_Status.h>
#include <phbalReg.h>
#include "phdlSPA.h"


#define PHDL_SPA_INT_TRIGGER_SLOPE_POSITIVE_STR         (uint8_t *)"POS"
#define PHDL_SPA_INT_TRIGGER_SLOPE_NEGATIVE_STR         (uint8_t *)"NEG"
#define PHDL_SPA_INT_TRIGGER_MODE_CONTINOUS_STR         (uint8_t *)"CONT"
#define PHDL_SPA_INT_TRIGGER_MODE_STOP_STR              (uint8_t *)"STOP"
#define PHDL_SPA_MODE_SPECTRUM_STR                      (uint8_t *)"SAN"
#define PHDL_SPA_MODE_REALTIME_STR                      (uint8_t *)"RTIM"
#define PHDL_SPA_MODE_ANALOGDEMOD_STR                   (uint8_t *)"ADEM"
#define PHDL_SPA_OUTPUT_FORMAT_ASCII_STR                (uint8_t *)"ASC"
#define PHDL_SPA_OUTPUT_FORMAT_REAL_STR                 (uint8_t *)"REAL"
#define PHDL_SPA_FREQUENCY_MODE_CW_STR                  (uint8_t *)"CW"
#define PHDL_SPA_FREQUENCY_MODE_FIXED_STR               (uint8_t *)"FIX"
#define PHDL_SPA_FREQUENCY_MODE_SWEEP_STR               (uint8_t *)"SWE"
#define PHDL_SPA_AVERAGE_TYPE_VIDEO_STR                 (uint8_t *)"VID"
#define PHDL_SPA_AVERAGE_TYPE_LINEAR_STR                (uint8_t *)"LIN"
#define PHDL_SPA_AVERAGE_TYPE_POWER_STR                 (uint8_t *)"POW"
#define PHDL_SPA_POWER_UNIT_DBM_STR                     (uint8_t *)"DBM"
#define PHDL_SPA_POWER_UNIT_DBMV_STR                    (uint8_t *)"DBMV"
#define PHDL_SPA_POWER_UNIT_DBMUV_STR                   (uint8_t *)"DBUV"
#define PHDL_SPA_POWER_UNIT_DBMUA_STR                   (uint8_t *)"DBUA"
#define PHDL_SPA_POWER_UNIT_DBPW_STR                    (uint8_t *)"DBPW"
#define PHDL_SPA_POWER_UNIT_VOLT_STR                    (uint8_t *)"Volt"
#define PHDL_SPA_POWER_UNIT_AMPE_STR                    (uint8_t *)"Ampere"
#define PHDL_SPA_POWER_UNIT_WATT_STR                    (uint8_t *)"Watt"
#define PHDL_SPA_RS_ID_STR                              (uint8_t *)"Rohde&Schwarz"
#define PHDL_SPA_AGILENT_ID_STR                         (uint8_t *)"AGILENT TECHNOLOGIES"

phStatus_t phdlSPA_Int_Send(
                            phbalReg_Visa_DataParams_t * pBalRegDataParam,
                            uint8_t * pCommand,
                            uint8_t bWaitFinished
                           );

phStatus_t phdlSPA_Int_ExchangeGetUInt(
                                       phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                       uint8_t * pCommand,
                                       uint32_t * dwResponse,
                                       uint8_t numberDigits
                                      );

phStatus_t phdlSPA_Int_ExchangeGetUIntWithoutRespLeng(
                                                      phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                                      uint8_t * pCommand,
                                                      uint32_t * dwResponse
                                                     );

phStatus_t phdlSPA_Int_ExchangeGetUInt16WithoutRespLeng(
                                                        phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                                        uint8_t * pCommand,
                                                        uint16_t * pwResponse
                                                       );

phStatus_t phdlSPA_Int_ExchangeGetUInt64WithoutRespLeng(
                                                       phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                                       uint8_t * pCommand,
                                                       uint64_t * pqResponse
                                                      );

phStatus_t phdlSPA_Int_ExchangeGetInt64WithoutRespLeng(
                                                       phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                                       uint8_t * pCommand,
                                                       uint8_t  bIsFloat,
                                                       int64_t * pqResponse
                                                      );

phStatus_t phdlSPA_Int_ExchangeGetResp(
                                       phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                       uint8_t * pCommand,
                                       uint8_t * pResponse,
                                       uint16_t wRespSize
                                      );

phStatus_t phdlSPA_Int_CheckError(
                                  phbalReg_Visa_DataParams_t * pBalRegDataParam
                                 );

phStatus_t phdlSPA_Int_FindInstrumentId(
                                        phdlSPA_FSV_DataParams_t * pDataParams,
                                        int8_t * pbIdBuff,
                                        uint8_t bIdBuffSize,
                                        int8_t * pbSeperator
                                       );

phStatus_t phdlSPA_Int_GetInstrumentCalData(
                                            uint8_t * pbIdBuff,
                                            uint16_t bIdBuffSize,
                                            uint8_t * pbRefIdString,
                                            uint8_t bRefIdSize,
                                            uint8_t * pbSeperator,
                                            uint8_t * pbIdFound
                                           );

phStatus_t phdlSPA_Int_BalReg_VisaExchangeLarge(
                                                phdlSPA_FSV_DataParams_t * pDataParams,
                                                uint8_t * pbTxBuffer,
                                                uint16_t wTxLength,
                                                uint32_t dwRxBufSize,
                                                uint8_t * pbRxBuffer,
                                                uint32_t * pdwRxLength
                                               );

/* Setter functions */
phStatus_t phdlSPA_Int_SetTriggerSource(
                                        phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                        uint16_t wValue
                                       );

phStatus_t phdlSPA_Int_SetTriggerSlope(
                                       phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                       uint16_t wValue
                                      );

phStatus_t phdlSPA_Int_SetTriggerLevelIfP(
                                          phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                          uint16_t wValue
                                         );

phStatus_t phdlSPA_Int_SetExtTriggerLevelMV(
                                            phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                            uint16_t wValue
                                           );

phStatus_t phdlSPA_Int_SetTriggerLevelRfPower(
                                              phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                              uint16_t wValue
                                             );

phStatus_t phdlSPA_Int_SetTriggerLevelVideo(
                                            phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                            uint16_t wValue
                                           );

phStatus_t phdlSPA_Int_SetTriggerMaskCondition(
                                               phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                               uint16_t wValue
                                              );

phStatus_t phdlSPA_Int_SetSPAMode(
                                  phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                  uint16_t wValue,
                                  uint8_t * pbDevId
                                 );

phStatus_t phdlSPA_Int_SetOutputFormat(
                                       phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                       uint16_t wValue,
                                       uint8_t * pbUseHeaderForTrace
                                      );

phStatus_t phdlSPA_Int_SetCenterFreq_HZ(
                                        phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                        uint64_t qValue,
                                        uint64_t qMaxFreq
                                       );

phStatus_t phdlSPA_Int_SetFreqMode(
                                   phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                   uint16_t wValue
                                  );

phStatus_t phdlSPA_Int_SetFreqSpan_HZ(
                                      phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                      uint64_t qValue
                                     );

phStatus_t phdlSPA_Int_SetFreqOffSet_HZ(
                                        phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                        int64_t qValue
                                       );

phStatus_t phdlSPA_Int_SetFreqStart_HZ(
                                       phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                       uint64_t qValue
                                      );

phStatus_t phdlSPA_Int_SetFreqStop_HZ(
                                      phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                      uint64_t qValue
                                     );

phStatus_t phdlSPA_Int_SetSweepMode(
                                    phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                    uint16_t wValue
                                   );

phStatus_t phdlSPA_Int_SetSweepType(
                                    phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                    uint16_t wValue
                                   );

phStatus_t phdlSPA_Int_SetSweepCount(
                                     phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                     uint16_t wValue
                                    );

phStatus_t phdlSPA_Int_SetSweepPoints(
                                      phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                      uint16_t wValue
                                     );

phStatus_t phdlSPA_Int_SetAverageState(
                                       phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                       uint16_t wValue
                                      );

phStatus_t phdlSPA_Int_SetAverageCount(
                                       phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                       uint16_t wValue
                                      );

phStatus_t phdlSPA_Int_SetAverageType(
                                      phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                      uint16_t wValue
                                     );

phStatus_t phdlSPA_Int_SetInputCoupling(
                                        phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                        uint16_t wValue
                                       );

phStatus_t phdlSPA_Int_SetInputImpedance(
                                         phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                         uint16_t wValue
                                        );

phStatus_t phdlSPA_Int_SetInputAttVal(
                                      phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                      uint16_t wValue,
                                      uint16_t wMaxAttValue
                                     );

phStatus_t phdlSPA_Int_SetInputAttAuto(
                                       phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                       uint16_t wValue
                                      );

phStatus_t phdlSPA_Int_SetBandwidthRes_HZ(
                                          phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                          uint64_t qValue
                                         );

phStatus_t phdlSPA_Int_SetBandwidthFilter(
                                          phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                          uint16_t wValue
                                         );

phStatus_t phdlSPA_Int_SetBandwidthResVideo_HZ(
                                               phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                               uint64_t qValue,
                                               uint64_t qMaxVideoBandwidth
                                              );

phStatus_t phdlSPA_Int_SetTraceDetectorMode(
                                            phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                            uint16_t wValue
                                           );

phStatus_t phdlSPA_Int_SetTraceMode(
                                    phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                    uint16_t wValue
                                   );

phStatus_t phdlSPA_Int_SetPowerUnit(
                                    phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                    uint16_t wValue
                                   );

phStatus_t phdlSPA_Int_SetReferenceLevel(
                                         phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                         int64_t wValue,
                                         int64_t maxRefLevelValue
                                        );

phStatus_t phdlSPA_Int_SetReferenceLevelOffset(
                                               phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                               int64_t wValue
                                              );

phStatus_t phdlSPA_Int_SetRunMode(
                                  phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                  uint16_t wValue
                                 );

phStatus_t phdlSPA_Int_SetRunModeContinue(
                                          phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                          uint16_t wValue
                                         );

phStatus_t phdlSPA_Int_SetTriggerHoldoff_NS(
                                            phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                            int64_t qValue
                                           );

phStatus_t phdlSPA_Int_SetSweepTime_NS(
                                       phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                       int64_t qValue
                                      );

phStatus_t phdlSPA_Int_Preset(
                              phbalReg_Visa_DataParams_t * pBalRegDataParam,
                              uint16_t wValue
                             );

phStatus_t phdlSPA_Int_SetMeasuremntType(
                                         phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                         uint16_t wValue
                                        );
/* Getter functions */
phStatus_t phdlSPA_Int_GetTriggerSlope(
                                       phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                       uint16_t * pwValue
                                      );

phStatus_t phdlSPA_Int_GetSPAMode(
                                  phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                  uint16_t * pwValue
                                 );

phStatus_t phdlSPA_Int_GetOutputFormat(
                                       phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                       uint16_t * pwValue,
                                       uint8_t bUseHeaderForTrace
                                      );

phStatus_t phdlSPA_Int_GetFreqMode(
                                   phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                   uint16_t * pwValue
                                  );

phStatus_t phdlSPA_Int_GetCenterFreq_HZ(
                                        phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                        int64_t * pqValue
                                       );

phStatus_t phdlSPA_Int_GetFreqSpan_HZ(
                                      phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                      int64_t * pqValue
                                     );

phStatus_t phdlSPA_Int_GetFreqStart_HZ(
                                       phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                       int64_t * pqValue
                                      );

phStatus_t phdlSPA_Int_GetFreqStop_HZ(
                                      phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                      int64_t * pqValue
                                     );

phStatus_t phdlSPA_Int_GetSweepCount(
                                     phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                     uint16_t * pwValue
                                    );

phStatus_t phdlSPA_Int_GetSweepPoints(
                                      phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                      uint16_t * pwValue
                                     );

phStatus_t phdlSPA_Int_GetAverageState(
                                       phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                       uint16_t * pwValue
                                      );

phStatus_t phdlSPA_Int_GetAverageCount(
                                       phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                       uint16_t * pwValue
                                      );

phStatus_t phdlSPA_Int_GetAverageType(
                                      phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                      uint16_t * pwValue
                                     );

phStatus_t phdlSPA_Int_GetBandwidthRes_HZ(
                                          phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                          int64_t * pqValue
                                         );

phStatus_t phdlSPA_Int_GetBandwidthResVideo_HZ(
                                               phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                               int64_t * pqValue
                                              );

phStatus_t phdlSPA_Int_GetInputAttVal(
                                      phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                      uint16_t * pwValue
                                     );

phStatus_t phdlSPA_Int_GetTriggerHoldoff_NS(
                                            phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                            int64_t * pqValue
                                           );

phStatus_t phdlSPA_Int_GetSweepTime_NS(
                                       phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                       int64_t * pqValue
                                      );

phStatus_t phdlSPA_Int_GetMeasurementData(
                                          phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                          uint8_t * pCommand,
                                          float64_t * pfValue
                                         );

phStatus_t phdlSPA_Int_GetOperationCompleted(
                                             phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                             uint16_t * bCompleted
                                            );

phStatus_t phdlSPA_Int_GetPowerUnit(
                                    phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                    uint16_t * pwValue
                                   );

phStatus_t phdlSPA_Int_GetReferenceLevel(
                                         phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                         int64_t * pqValue
                                        );

phStatus_t phdlSPA_Int_GetReferenceLevelOffset(
                                               phbalReg_Visa_DataParams_t * pBalRegDataParam,
                                               int64_t * pqValue
                                              );

void removeWhiteSpaceConvertToUpper(
                                    uint8_t * pbConvBuff,
                                    uint8_t * pbReturnBuff
                                   );

void convertFloatToInt(
                       uint8_t * pbRxBuff,
                       int64_t * pqConvertedNum
                      );
#endif /* PHDLSPA_INT_H */
