/*
 * Copyright 2013, 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Generic Osciloscope Device Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLOSCI_INT_H
#define PHDLOSCI_INT_H

#include <ph_Status.h>
#include <phbalReg.h>
#include "phdlOsci.h"

#define FLT_MAX (1E+37)

#ifndef min
#define min(a,b)            (((a) < (b)) ? (a) : (b))
#endif

#ifndef max
#define max(a,b)            (((a) > (b)) ? (a) : (b))
#endif

phStatus_t phdlOsci_Int_Send(
                             phdlOsci_LW64Xi_DataParams_t * pDataParams,
                             uint8_t * pTxBuffer,
                             uint16_t wTxLength
                             );

phStatus_t phdlOsci_Int_SendWait(
                                 phdlOsci_LW64Xi_DataParams_t * pDataParams,
                                 uint8_t * pTxBuffer,
                                 uint16_t wTxLength,
                                 uint16_t wWaittime
                                 );

phStatus_t phdlOsci_Int_CheckClearError(
                                 phdlOsci_LW64Xi_DataParams_t * pDataParams,
                                 phStatus_t status
                                 );

phStatus_t phdlOsci_Int_Atoui16(
                                int8_t * pAsci,
                                uint16_t * wURetVal
                                );

phStatus_t phdlOsci_Int_Atoi16(
                               int8_t * pAsci,
                               int16_t * wIRetVal
                               );

phStatus_t phdlOsci_Int_Atoui32(
                                int8_t * pAsci,
                                uint32_t * dwURetVal
                                );

phStatus_t phdlOsci_Int_Atoi32(
                               int8_t * pAsci,
                               int32_t * dwIRetVal
                               );

phStatus_t phdlOsci_Int_FindChar(
                                 int8_t * pAsci,
                                 int8_t bRef,
                                 uint8_t * bRetVal
                                 );

phStatus_t phdlOsci_Int_FindStr(int8_t * pAsci,
                                int8_t * pRef,
                                uint8_t bRefSize,
                                uint8_t * pbStrFound
                                );

phStatus_t  phdlOsci_Int_Atof(
                              int8_t * pAsci,
                              float32_t * fRetVal
                              );

phStatus_t  phdlOsci_Int_Atof64(
                              int8_t * pAsci,
                              float64_t * qwRetVal
                              );

#endif /* PHDLOSCI_INT_H */
