/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLMSTAMPOSC_MP300_INT_H
#define PHDLMSTAMPOSC_MP300_INT_H

#include <ph_Status.h>

#ifndef abs
#define abs(a)            (((a) >= 0) ? (a) : -(a))
#endif

phStatus_t phdlMstAmpOsc_Mp300_Int_CalcGainValues(
    phdlMstAmpOsc_Mp300_DataParams_t * pDataParams,
    uint16_t wFieldStrength,
    uint16_t * pwGain,
    uint16_t * wMp300GainValueThousand
    );

/*
The function for spline interpolation is a addaped vorvion from:
http://www.mech.uq.edu.au/staff/jacobs/nm_lib/cmathsrc/spline.c
*/
/* Purpose ...
   -------
   Evaluate the coefficients b[i], c[i], d[i], i = 0, 1, .. n-1 for
   a cubic interpolating spline

   S(xx) = Y[i] + b[i] * w + c[i] * w**2 + d[i] * w**3
   where w = xx - x[i]
   and   x[i] <= xx <= x[i+1]

   The n supplied data points are x[i], y[i], i = 0 ... n-1.

   Input :
   -------
   n       : The number of data points or knots (n >= 2)
   end1,
   end2    : = 1 to specify the slopes at the end points
             = 0 to obtain the default conditions
   slope1,
   slope2  : the slopes at the end points x[0] and x[n-1]
             respectively
   x[]     : the abscissas of the knots in strictly
             increasing order
   y[]     : the ordinates of the knots

   Output :
   --------
   b, c, d : arrays of spline coefficients as defined above
             (See note 2 for a definition.)
   iflag   : status flag
            = 0 normal return
            = 1 less than two data points; cannot interpolate
            = 2 x[] are not in ascending order

   This C code written by ...  Peter & Nigel,
   ----------------------      Design Software,
                               42 Gubberley St,
                               Kenmore, 4069,
                               Australia.

   Version ... 1.1, 30 September 1987
   -------     2.0, 6 April 1989    (start with zero subscript)
                                     remove ndim from parameter list
               2.1, 28 April 1989   (check on x[])
               2.2, 10 Oct   1989   change number order of matrix

   Notes ...
   -----
   (1) The accompanying function seval() may be used to evaluate the
       spline while deriv will provide the first derivative.
   (2) Using p to denote differentiation
       y[i] = S(X[i])
       b[i] = Sp(X[i])
       c[i] = Spp(X[i])/2
       d[i] = Sppp(X[i])/6  ( Derivative from the right )
   (3) Since the zero elements of the arrays ARE NOW used here,
       all arrays to be passed from the main program should be
       dimensioned at least [n].  These routines will use elements
       [0 .. n-1].
   (4) Adapted from the text
       Forsythe, G.E., Malcolm, M.A. and Moler, C.B. (1977)
       "Computer Methods for Mathematical Computations"
       Prentice Hall
   (5) Note that although there are only n-1 polynomial segments,
       n elements are requird in b, c, d.  The elements b[n-1],
       c[n-1] and d[n-1] are set to continue the last segment
       past x[n-1].
*/
phStatus_t phdlMstAmpOsc_Mp300_Int_Spline (uint16_t n, int end1, int end2,
            double slope1, double slope2,
            double x[], double y[],
            double b[], double c[], double d[],
            uint16_t *iflag);


/*Purpose ...
  -------
  Evaluate the cubic spline function

  S(xx) = y[i] + b[i] * w + c[i] * w**2 + d[i] * w**3
  where w = u - x[i]
  and   x[i] <= u <= x[i+1]
  Note that Horner's rule is used.
  If u < x[0]   then i = 0 is used.
  If u > x[n-1] then i = n-1 is used.

  Input :
  -------
  n       : The number of data points or knots (n >= 2)
  u       : the abscissa at which the spline is to be evaluated
  Last    : the segment that was last used to evaluate U
  x[]     : the abscissas of the knots in strictly increasing order
  y[]     : the ordinates of the knots
  b, c, d : arrays of spline coefficients computed by spline().

  Output :
  --------
  result  : the value of the spline function at u
  Last    : the segment in which u lies

  Notes ...
  -----
  (1) If u is not in the same interval as the previous call then a
      binary search is performed to determine the proper interval.

*/
phStatus_t phdlMstAmpOsc_Mp300_Int_seval (uint16_t n, double u,
              double x[], double y[],
              double b[], double c[], double d[],
              uint16_t *last, double * result);

phStatus_t phdlMstAmpOsc_Mp300_Int_SetSecureState(
    phdlMstAmpOsc_Mp300_DataParams_t * pDataParams
    );

phStatus_t phdlMstAmpOsc_Mp300_Int_GetFieldStrengthRangeChecked(
    phdlMstAmpOsc_Mp300_DataParams_t * pDataParams,
    uint16_t wLimitLow,
    uint16_t wLimitHigh,
    uint16_t *pwFieldStrengthMeas
    );

phStatus_t phdlMstAmpOsc_Mp300_Int_SetOutputGain(
    void * pDlRdGainDataParams,
    uint16_t wGain
    );

phStatus_t phdlMstAmpOsc_Mp300_Int_GetMaxOutputGain(
    void * pDlRdGainDataParams,
    uint16_t * pwMaxGain
    );

phStatus_t phdlMstAmpOsc_Mp300_Int_GetMinOutputGain(
    void * pDlRdGainDataParams,
    uint16_t * pwMinGain
    );

phStatus_t phdlMstAmpOsc_Mp300_Int_SetRxGain(
    void * pDlRdGainDataParams,
    uint16_t wGain
    );

phStatus_t phdlMstAmpOsc_Mp300_Int_GetMaxRxGain(
    void * pDlRdGainDataParams,
    uint16_t * pwMaxGain
    );

phStatus_t phdlMstAmpOsc_Mp300_Int_GetMinRxGain(
    void * pDlRdGainDataParams,
    uint16_t * pwMinGain
    );

phStatus_t phdlMstAmpOsc_Mp300_Int_AdjustReaderRxGain(
    phdlMstAmpOsc_Mp300_DataParams_t * pDataParams,
    uint16_t wFieldStrength
    );

phStatus_t phdlMstAmpOsc_Mp300_Int_ReCalibrate(
    phdlMstAmpOsc_Mp300_DataParams_t * pDataParams,
    uint16_t wFieldStrength,
    uint8_t bRecalCounter);

phStatus_t phdlMstAmpOsc_Mp300_Int_ReCalibrateFast(
    phdlMstAmpOsc_Mp300_DataParams_t * pDataParams,
    uint16_t wFieldStrength);

phStatus_t phdlMstAmpOsc_Mp300_Int_CalcSplineValues(
    uint8_t bMaxMeasuredInterpolationPoint,
    double pdFieldstrength[], double pdGainValues[],
    double pdbH2Gain[], double pdcH2Gain[], double pddH2Gain[],
    double pdbGain2H[], double pdcGain2H[], double pddGain2H[]);

phStatus_t phdlMstAmpOsc_Mp300_Int_MeasureCalibrationPoint(
    phdlMstAmpOsc_Mp300_DataParams_t * pDataParams,
    uint16_t wGain,
    uint16_t * pwFieldStrengthMeas);

#endif /* PHDLMSTAMPOSC_SW_INT_H */
