/*
 * Copyright 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Hardware Amplifier BBA150 Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLAMP_BBA150_INT_H
#define PHDLAMP_BBA150_INT_H

#include <ph_Status.h>

phStatus_t phdlAmp_BBA150_Int_CalcWaitTime(
    phdlAmp_BBA150_DataParams_t * pDataParams,
    uint16_t wNewGain,
    uint16_t * wWaitTime
    );

phStatus_t phdlAmp_BBA150_Int_SendWaitFinished(
    phdlAmp_BBA150_DataParams_t * pDataParams,
    uint8_t * pCommand
    );

phStatus_t phdlAmp_BBA150_Int_ExchangeGetUInt(
    phdlAmp_BBA150_DataParams_t * pDataParams,
    uint8_t * pCommand,
    uint32_t * dwResponse,
    uint8_t numberDigits
    );

phStatus_t phdlAmp_BBA150_Int_ExchangeGetResp(
    phdlAmp_BBA150_DataParams_t * pDataParams,
    uint8_t * pCommand,
    uint8_t * pResponse,
    uint16_t wRespSize
    );

phStatus_t phdlAmp_BBA150_Int_CheckError(
    phdlAmp_BBA150_DataParams_t * pDataParams
    );

#endif /* PHDLAMP_BBA150_INT_H */
