/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Hardware Amplifier AR75A250 Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <phbalReg.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHDL_AMP_AR75A250

#include <phdlAmp.h>
#include "phdlAmp_AR75A250.h"
#include "phdlAmp_AR75A250_Int.h"
#include "../phdlAmp_Int.h"

phStatus_t phdlAmp_AR75A250_Int_CalcWaitTime(
    phdlAmp_AR75A250_DataParams_t * pDataParams,
    uint16_t wNewGain,
    uint16_t * wWaitTime
    )
{
    uint16_t wGainDiff;

    /* calculate difference */
    if (pDataParams->wCurrentGain > wNewGain)
    {
        wGainDiff = pDataParams->wCurrentGain - wNewGain;
    }
    else
    {
        wGainDiff = wNewGain - pDataParams->wCurrentGain;
    }
    /* copy new value */
    pDataParams->wCurrentGain = wNewGain;

    if (wGainDiff > 1500)
    {
        *wWaitTime = 2000;
    }
    else if (wGainDiff > 1000)
    {
        *wWaitTime = 1000;
    }
    else if (wGainDiff > 500)
    {
        *wWaitTime = 500;
    }
    else
    {
        *wWaitTime = 100;
    }
    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_DL_AMP);
}

#endif /* NXPBUILD__PHDL_AMP_AR75A250 */
