/*
 * Copyright 2013, 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * RDFPGA BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_RefDefs.h>

#ifdef _WIN32
#include <string.h>
#endif

#ifdef NXPBUILD__PHBAL_REG_RDFPGAV6

#include "phbalReg_RdFpgaV6_Ex.h"

#pragma warning(push)                   /* PRQA S 3116 */
#pragma warning(disable:4200)           /* PRQA S 3116 */
#pragma warning(disable:4201)           /* PRQA S 3116 */
#include <windows.h>
#pragma warning(pop)                    /* PRQA S 3116 */

phStatus_t phbalReg_RdFpgaV6_Ex_LoadFunctions(
    phbalReg_RdFpgaV6_DataParams_t * pDataParams
    )
{
#ifdef _WIN32
    /* load library */
    pDataParams->pHandle = LoadLibrary(PHBAL_REG_RDFPGAV6_EX_DLL_NAME);

    /* check if loading succeded */
    if (pDataParams->pHandle == NULL)
    {
        /* failed to load the phCDllReaderLib.dll */
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    /* get all function pointers */
    pDataParams->pfRdFpga_Open = (PHBAL_REG_RDFPGAV6_OPEN) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_OPEN_FNAME);
    if (pDataParams->pfRdFpga_Open == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_Close = (PHBAL_REG_RDFPGAV6_CLOSE) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_CLOSE_FNAME);
    if (pDataParams->pfRdFpga_Close == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_Init = (PHBAL_REG_RDFPGAV6_INIT) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_INIT_FNAME);
    if (pDataParams->pfRdFpga_Init == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_SetParam = (PHBAL_REG_RDFPGAV6_SETPARAM) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_SETPARAM_FNAME);
    if (pDataParams->pfRdFpga_SetParam == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_GetParam = (PHBAL_REG_RDFPGAV6_GETPARAM) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_GETPARAM_FNAME);
    if (pDataParams->pfRdFpga_GetParam == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_ExchangeBits = (PHBAL_REG_RDFPGAV6_EXCHANGEBITS) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_EXCHANGEBITS_FNAME);
    if (pDataParams->pfRdFpga_ExchangeBits == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_SetTargetJoiner = (PHBAL_REG_RDFPGAV6_SETTARGETJOINER) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_SETTARGETJOINER_FNAME);
    if (pDataParams->pfRdFpga_SetTargetJoiner == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_SetJoinerReg = (PHBAL_REG_RDFPGAV6_SETJOINERREG) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_SETJOINERREG_FNAME);
    if (pDataParams->pfRdFpga_SetJoinerReg == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_GetJoinerReg = (PHBAL_REG_RDFPGAV6_GETJOINERREG) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_GETJOINERREG_FNAME);
    if (pDataParams->pfRdFpga_GetJoinerReg == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_LoadJoinerIniFile = (PHBAL_REG_RDFPGAV6_LOADJOINERINIFILE) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_LOADJOINERINIFILE_FNAME);
    if (pDataParams->pfRdFpga_LoadJoinerIniFile == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_ActivateField = (PHBAL_REG_RDFPGAV6_ACTFIELD) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_ACTFIELD_FNAME);
    if (pDataParams->pfRdFpga_ActivateField == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_DeactivateField = (PHBAL_REG_RDFPGAV6_DEACTIVATEFIELD) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_DEACTIVATEFIELD_FNAME);
    if (pDataParams->pfRdFpga_DeactivateField == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_HFPause = (PHBAL_REG_RDFPGAV6_HFPAUSE) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_HFPAUSE_FNAME);
    if (pDataParams->pfRdFpga_HFPause == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_SetPotiPos = (PHBAL_REG_RDFPGAV6_SET_POTIPOS) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_SET_POTIPOS_FNAME);
    if (pDataParams->pfRdFpga_SetPotiPos == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_SetDefaultPotiPos = (PHBAL_REG_RDFPGAV6_SET_DEFAULTPOTIPOS) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_SET_DEFAULTPOTIPOS_FNAME);
    if (pDataParams->pfRdFpga_SetDefaultPotiPos == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_GetPotiPos = (PHBAL_REG_RDFPGAV6_GET_POTIPOS) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_GET_POTIPOS_FNAME);
    if (pDataParams->pfRdFpga_GetPotiPos == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_IncPotiPos = (PHBAL_REG_RDFPGAV6_INC_POTIPOS) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_INC_POTIPOS_FNAME);
    if (pDataParams->pfRdFpga_IncPotiPos == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_DecPotiPos = (PHBAL_REG_RDFPGAV6_DEC_POTIPOS) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_DEC_POTIPOS_FNAME);
    if (pDataParams->pfRdFpga_DecPotiPos == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_SetTimeoutValue = (PHBAL_REG_RDFPGAV6_SET_TIMEOUTVALUE) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_SET_TIMEOUTVALUE_FNAME);
    if (pDataParams->pfRdFpga_SetTimeoutValue == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_GetTimeoutValue = (PHBAL_REG_RDFPGAV6_GET_TIMEOUTVALUE) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_GET_TIMEOUTVALUE_FNAME);
    if (pDataParams->pfRdFpga_GetTimeoutValue == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_LoadPattern = (PHBAL_REG_RDFPGAV6_LOAD_PATTERN) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_LOAD_PATTERN_FNAME);
    if (pDataParams->pfRdFpga_LoadPattern == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_PlayPattern = (PHBAL_REG_RDFPGAV6_PLAY_PATTERN) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_PLAY_PATTERN_FNAME);
    if (pDataParams->pfRdFpga_PlayPattern == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_PlaySeqA = (PHBAL_REG_RDFPGAV6_PLAYSEQA) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_PLAYSEQA_FNAME);
    if (pDataParams->pfRdFpga_PlaySeqA == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_PlaySeqB = (PHBAL_REG_RDFPGAV6_PLAYSEQB) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_PLAYSEQB_FNAME);
    if (pDataParams->pfRdFpga_PlaySeqB == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_PlaySinus = (PHBAL_REG_RDFPGAV6_PLAYSINUS) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_PLAYSINUS_FNAME);
    if (pDataParams->pfRdFpga_PlaySinus == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_SelectTrigger = (PHBAL_REG_RDFPGAV6_SELECT_TRIGGER) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_SELECT_TRIGGER_FNAME);
    if (pDataParams->pfRdFpga_SelectTrigger == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_LabelReset = (PHBAL_REG_RDFPGAV6_LBLRST) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_LBLRST_FNAME);
    if (pDataParams->pfRdFpga_LabelReset == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_LabelResetCounterReset = (PHBAL_REG_RDFPGAV6_LBLRST_COUNTERRESET) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_LBLRST_COUNTERRESET_FNAME);
    if (pDataParams->pfRdFpga_LabelResetCounterReset == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_LabelResetCounterResetSingleShot = (PHBAL_REG_RDFPGAV6_LBLRST_SSCOUNTERRESET) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_LBLRST_SSCOUNTERRESET_FNAME);
    if (pDataParams->pfRdFpga_LabelResetCounterResetSingleShot == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_LabelResetSingleShot = (PHBAL_REG_RDFPGAV6_LBLRST_SINGLESHOT) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_LBLRST_SINGLESHOT_FNAME);
    if (pDataParams->pfRdFpga_LabelResetSingleShot == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_LabelResetWithCommand = (PHBAL_REG_RDFPGAV6_LBLRST_WITHCOMMAND) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_LBLRST_WITHCOMMAND_FNAME);
    if (pDataParams->pfRdFpga_LabelResetWithCommand == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_ActivateFDTMeasurement = (PHBAL_REG_RDFPGAV6_ACT_FDT_MEASUREMENT) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_ACT_FDT_MEASUREMENT_FNAME);
    if (pDataParams->pfRdFpga_ActivateFDTMeasurement == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_GetFDT = (PHBAL_REG_RDFPGAV6_GET_FDT) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_GET_FDT_FNAME);
    if (pDataParams->pfRdFpga_GetFDT == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_GetFDTFast = (PHBAL_REG_RDFPGAV6_GET_FDT_FAST) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_GET_FDT_FAST_FNAME);
    if (pDataParams->pfRdFpga_GetFDTFast == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_ActivateAntiTearingMode = (PHBAL_REG_RDFPGAV6_ACT_ANTITEARINGMODE) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_ACT_ANTITEARINGMODE_FNAME);
    if (pDataParams->pfRdFpga_ActivateAntiTearingMode == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_ResonanceFrequenceTest = (PHBAL_REG_RDFPGAV6_RESONANCE_FREQ_TEST) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_RESONANCE_FREQ_TEST_FNAME);
    if (pDataParams->pfRdFpga_ResonanceFrequenceTest == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_ActivateFDTMeasurementPICCtoPCD = (PHBAL_REG_RDFPGAV6_ACT_FDT_PICC_TO_PCD_MEASUREMENT) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_ACT_FDT_PICC_TO_PCD_MEASUREMENT_FNAME);
    if (pDataParams->pfRdFpga_ActivateFDTMeasurementPICCtoPCD == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_ActivateLMAMeasurement = (PHBAL_REG_RDFPGAV6_ACT_LMA_MEASUREMENT) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_ACT_LMA_MEASUREMENT_FNAME);
    if (pDataParams->pfRdFpga_ActivateLMAMeasurement == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_ActivateSequencerMode = (PHBAL_REG_RDFPGAV6_ACT_SEQUENCERMODE) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_ACT_SEQUENCERMODE_FNAME);
    if (pDataParams->pfRdFpga_ActivateSequencerMode == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_DeactivateModes = (PHBAL_REG_RDFPGAV6_DEACTIVATE_MODES) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_DEACTIVATE_MODES_FNAME);
    if (pDataParams->pfRdFpga_DeactivateModes == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_SetJoinerRxGain = (PHBAL_REG_RDFPGAV6_SET_JOINER_RXGAIN) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_SET_JOINER_RXGAIN_FNAME);
    if (pDataParams->pfRdFpga_SetJoinerRxGain == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_GetJoinerRxGain = (PHBAL_REG_RDFPGAV6_GET_JOINER_RXGAIN) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_GET_JOINER_RXGAIN_FNAME);
    if (pDataParams->pfRdFpga_GetJoinerRxGain == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_SetFDTPCDforActiveDS = (PHBAL_REG_RDFPGAV6_ACTIVEDS_SET_FDT) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_ACTIVEDS_SET_FDT_FNAME);
    if (pDataParams->pfRdFpga_SetFDTPCDforActiveDS == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_SetFDTPCDforDS = (PHBAL_REG_RDFPGAV6_DS_SET_FDT) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_DS_SET_FDT_FNAME);
    if (pDataParams->pfRdFpga_SetFDTPCDforDS == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_GetVersion = (PHBAL_REG_RDFPGAV6_GET_VERSION) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_GET_VERSION_FNAME);
    if (pDataParams->pfRdFpga_GetVersion == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_GetRevision = (PHBAL_REG_RDFPGAV6_GET_REVISION) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_GET_REVISION_FNAME);
    if (pDataParams->pfRdFpga_GetRevision == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_GetErrorCodes = (PHBAL_REG_RDFPGAV6_GET_ERROR_CODES) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_GET_ERROR_CODES_FNAME);
    if (pDataParams->pfRdFpga_GetErrorCodes == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_SetClockSource = (PHBAL_REG_RDFPGAV6_SET_CLOCK_SOURCE) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_SET_CLOCK_SOURCE_FNAME);
    if (pDataParams->pfRdFpga_SetClockSource == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_GetFirstResponse = (PHBAL_REG_RDFPGAV6_GET_FIRST_RESPONSE) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_GET_FIRST_RESPONSE_FNAME);
    if (pDataParams->pfRdFpga_GetFirstResponse == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_GetResponse = (PHBAL_REG_RDFPGAV6_GET_RESPONSE) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_GET_RESPONSE_FNAME);
    if (pDataParams->pfRdFpga_GetResponse == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_GetIQTimeoutValue = (PHBAL_REG_RDFPGAV6_GET_IQ_TIMEOUTVALUE) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_GET_IQ_TIMEOUTVALUE_FNAME);
    if (pDataParams->pfRdFpga_GetIQTimeoutValue == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_SetIQTimeoutValue = (PHBAL_REG_RDFPGAV6_SET_IQ_TIMEOUTVALUE) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_SET_IQ_TIMEOUTVALUE_FNAME);
    if (pDataParams->pfRdFpga_SetIQTimeoutValue == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_GetTerminalId = (PHBAL_REG_RDFPGAV6_GET_TERMINALID) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_GET_TERMINALID_FNAME);
    if (pDataParams->pfRdFpga_GetTerminalId == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_ResetJoiner = (PHBAL_REG_RDFPGAV6_RESET_JOINER) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_RESET_JOINER_FNAME);
    if (pDataParams->pfRdFpga_ResetJoiner == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_LoadFilterFile = (PHBAL_REG_RDFPGAV6_LOADFILTERFILE) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_LOADFILTERFILE_FNAME);
    if (pDataParams->pfRdFpga_LoadFilterFile == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_ExchangeFPGACommand = (PHBAL_REG_RDFPGAV6_EXCHANGEFPGACOMMAND) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_EXCHANGEFPGACOMMAND_FNAME);
    if (pDataParams->pfRdFpga_ExchangeFPGACommand == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfRdFpga_ActivateTypeBMode = (PHBAL_REG_RDFPGAV6_ACT_TYPEBMODE) GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_RDFPGAV6_EX_ACTIVATETYPEBMODE_FNAME);
    if (pDataParams->pfRdFpga_ActivateTypeBMode == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
#else
    return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
#endif
}

phStatus_t phbalReg_RdFpgaV6_Ex_UnLoadFunctions(
    phbalReg_RdFpgaV6_DataParams_t * pDataParams
    )
{
#ifdef _WIN32
    uint8_t bResult;

    /* check if the library is loaded */
    if (pDataParams->pHandle != NULL)
    {
        /* unload the library */
        bResult = (uint8_t)FreeLibrary((HMODULE)pDataParams->pHandle);

        /* check the success of the command */
        if (bResult == PH_OFF)
        {
            return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
        }

        /* set all function pointers to NULL */
        pDataParams->pfRdFpga_Open = NULL;
        pDataParams->pfRdFpga_Close = NULL;
        pDataParams->pfRdFpga_Init = NULL;
        pDataParams->pfRdFpga_SetParam = NULL;
        pDataParams->pfRdFpga_GetParam = NULL;
        pDataParams->pfRdFpga_ExchangeBits = NULL;
        pDataParams->pfRdFpga_SetTargetJoiner = NULL;
        pDataParams->pfRdFpga_SetJoinerReg = NULL;
        pDataParams->pfRdFpga_GetJoinerReg = NULL;
        pDataParams->pfRdFpga_LoadJoinerIniFile = NULL;
        pDataParams->pfRdFpga_ActivateField = NULL;
        pDataParams->pfRdFpga_DeactivateField = NULL;
        pDataParams->pfRdFpga_HFPause = NULL;
        pDataParams->pfRdFpga_SetPotiPos = NULL;
        pDataParams->pfRdFpga_SetDefaultPotiPos = NULL;
        pDataParams->pfRdFpga_GetPotiPos = NULL;
        pDataParams->pfRdFpga_IncPotiPos = NULL;
        pDataParams->pfRdFpga_DecPotiPos = NULL;
        pDataParams->pfRdFpga_SetTimeoutValue = NULL;
        pDataParams->pfRdFpga_GetTimeoutValue = NULL;
        pDataParams->pfRdFpga_LoadPattern = NULL;
        pDataParams->pfRdFpga_PlayPattern = NULL;
        pDataParams->pfRdFpga_PlaySeqA = NULL;
        pDataParams->pfRdFpga_PlaySeqB = NULL;
        pDataParams->pfRdFpga_PlaySinus = NULL;
        pDataParams->pfRdFpga_SelectTrigger = NULL;
        pDataParams->pfRdFpga_LabelReset = NULL;
        pDataParams->pfRdFpga_LabelResetCounterReset = NULL;
        pDataParams->pfRdFpga_LabelResetCounterResetSingleShot = NULL;
        pDataParams->pfRdFpga_LabelResetSingleShot = NULL;
        pDataParams->pfRdFpga_LabelResetWithCommand = NULL;
        pDataParams->pfRdFpga_ActivateFDTMeasurement = NULL;
        pDataParams->pfRdFpga_GetFDT = NULL;
        pDataParams->pfRdFpga_GetFDTFast = NULL;
        pDataParams->pfRdFpga_ActivateAntiTearingMode = NULL;
        pDataParams->pfRdFpga_ResonanceFrequenceTest = NULL;
        pDataParams->pfRdFpga_ActivateFDTMeasurementPICCtoPCD = NULL;
        pDataParams->pfRdFpga_ActivateLMAMeasurement = NULL;
        pDataParams->pfRdFpga_ActivateSequencerMode = NULL;
        pDataParams->pfRdFpga_DeactivateModes = NULL;
        pDataParams->pfRdFpga_SetJoinerRxGain = NULL;
        pDataParams->pfRdFpga_GetJoinerRxGain = NULL;
        pDataParams->pfRdFpga_SetFDTPCDforActiveDS = NULL;
        pDataParams->pfRdFpga_SetFDTPCDforDS = NULL;
        pDataParams->pfRdFpga_GetVersion = NULL;
        pDataParams->pfRdFpga_GetRevision = NULL;
        pDataParams->pfRdFpga_GetErrorCodes = NULL;
        pDataParams->pfRdFpga_SetClockSource = NULL;
        pDataParams->pfRdFpga_GetFirstResponse = NULL;
        pDataParams->pfRdFpga_GetResponse = NULL;
        pDataParams->pfRdFpga_GetIQTimeoutValue = NULL;
        pDataParams->pfRdFpga_SetIQTimeoutValue = NULL;
        pDataParams->pfRdFpga_GetTerminalId = NULL;
        pDataParams->pfRdFpga_ResetJoiner = NULL;
        pDataParams->pfRdFpga_LoadFilterFile = NULL;
        pDataParams->pfRdFpga_ExchangeFPGACommand = NULL;
        pDataParams->pfRdFpga_ActivateTypeBMode = NULL;

        /* set the handle to NULL */
        pDataParams->pHandle = NULL;
        /* return success */
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
#else
    return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
#endif
}
#endif /* NXPBUILD__PHBAL_REG_RDFPGAV6 */
