/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal P40 CmdLib Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>

#ifdef NXPBUILD__PHAL_P40CMDPRIV

#include "phalP40CmdPriv_Int.h"
#include <phalP40CmdPriv.h>

/***************************************************************************************/
phStatus_t phalP40CmdPriv_Int_TranslateError (
	uint8_t    bErrorCode)
{
	switch (bErrorCode)
	{
	case PHAL_P40CMDPRIV_INT_ERR_OK:
		return PH_ERR_SUCCESS;

	case PHAL_P40CMDPRIV_INT_ERR_BAD_CMD:
		return PHAL_P40CMDPRIV_ERR_COMMAND;

	case PHAL_P40CMDPRIV_INT_ERR_PARAM:
		return PHAL_P40CMDPRIV_ERR_PARAM;

	case PHAL_P40CMDPRIV_INT_ERR_FORMAT:
		return PHAL_P40CMDPRIV_ERR_FORMAT;

	case PHAL_P40CMDPRIV_INT_ERR_INTERNAL:
		return PHAL_P40CMDPRIV_ERR_EXECUTION;

	case PHAL_P40CMDPRIV_INT_ERR_NOT_AUTH:
		return PHAL_P40CMDPRIV_ERR_NOT_AUTH;

	default:
		return PHAL_P40CMDPRIV_ERR_UNKNOWN;
	}
}

#endif /* NXPBUILD__PHAL_P40CMDPRIV */

