/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Generic P40 CmdPriv Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <ph_RefDefs.h>
#include <phhalHw.h>

#ifdef NXPBUILD__PHAL_P40CMDPRIV_SW
#include "Sw/phalP40CmdPriv_Sw.h"
#endif /* NXPBUILD__PHAL_P40CMDPRIV_SW */

#ifdef NXPBUILD__PHAL_P40CMDPRIV

#include <phalP40CmdPriv.h>
#include "phalP40CmdPriv_Int.h"

/***************************************************************************************/
phStatus_t phalP40CmdPriv_GetVersionP( void * pDataParams,
                                      uint8_t * pVersionData )
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phalP40CmdPriv_GetVersionP");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pVersionData);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);
    PH_ASSERT_NULL (pVersionData);

    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_AL_P40CMDPRIV)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_P40CMDPRIV);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_P40CMDPRIV_SW
    case PHAL_P40CMDPRIV_SW_ID:
        status = phalP40CmdPriv_Sw_GetVersionP((phalP40CmdPriv_Sw_DataParams_t *)pDataParams, pVersionData);
        break;
#endif /* NXPBUILD__PHAL_P40CMDPRIV_SW */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_P40CMDPRIV);
        break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
#ifdef NXPBUILD__PH_LOG
    if ( (status & PH_ERR_MASK) == PH_ERR_SUCCESS)
    {
        PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG,
            pVersionData_log,
            pVersionData,
            PHAL_P40CMDPRIV_VERSIONINFO_SIZE);
    }
#endif

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

/***************************************************************************************/
phStatus_t phalP40CmdPriv_WriteMemoryP( void *     pDataParams,
                                                                           uint16_t  wStartAddr,
                                                                           uint8_t    bUseRandom,
                                                                           uint8_t    bDataLength,
                                                                           uint8_t *  pData)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phalP40CmdPriv_WriteMemoryP");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(Addr);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(UseRandom);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(DataLength);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(Data);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
	PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, Addr_log,&wStartAddr);
	PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, UseRandom_log,&bUseRandom);
	PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, DataLength_log,&bDataLength);
	PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, Data_log, pData, bDataLength);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_AL_P40CMDPRIV)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_P40CMDPRIV);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_P40CMDPRIV_SW
    case PHAL_P40CMDPRIV_SW_ID:
        status = phalP40CmdPriv_Sw_WriteMemoryP((phalP40CmdPriv_Sw_DataParams_t *)pDataParams,
            wStartAddr, bUseRandom, bDataLength, pData );
        break;
#endif /* NXPBUILD__PHAL_P40CMDPRIV_SW */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_P40CMDPRIV);
        break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

/***************************************************************************************/
phStatus_t phalP40CmdPriv_ReadMemoryP( void *pDataParams,
                                                                           uint16_t	   wStartAddr,
                                                                           uint8_t     bDataLength,
                                                                           uint8_t *   pData,
                                                                           uint16_t * pReadLength)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phalP40CmdPriv_ReadMemoryP");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(Addr);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(DataLength);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(Data);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
	PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, Addr_log,&wStartAddr);
	PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, DataLength_log,&bDataLength);
	PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, Data_log, pData, bDataLength);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_AL_P40CMDPRIV)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_P40CMDPRIV);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_P40CMDPRIV_SW
    case PHAL_P40CMDPRIV_SW_ID:
        status = phalP40CmdPriv_Sw_ReadMemoryP((phalP40CmdPriv_Sw_DataParams_t *)pDataParams,
            wStartAddr, bDataLength, pData, pReadLength    );
        break;
#endif /* NXPBUILD__PHAL_P40CMDPRIV_SW */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_P40CMDPRIV);
        break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

/***************************************************************************************/
phStatus_t phalP40CmdPriv_CalculateChecksumP( void *      pDataParams,
                                                                                      uint16_t  wStartAddr,
                                                                                      uint16_t  wLength,
                                                                                      uint8_t    bCksumType,
                                                                                      uint16_t  wDestAddress,
                                                                                      uint8_t *  pCrc )
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phalP40CmdPriv_CalculateChecksumP");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(Addr);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(Length);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(CksumType);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(DestAddress);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(CRC);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
	PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, Addr_log,&wStartAddr);
	PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, Length_log,&wLength);
	PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, CksumType_log,&bCksumType);
	PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, DestAddress_log,&wDestAddress);
	PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, CRC_log, pCrc, 4);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_AL_P40CMDPRIV)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_P40CMDPRIV);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_P40CMDPRIV_SW
    case PHAL_P40CMDPRIV_SW_ID:
        status = phalP40CmdPriv_Sw_CalculateChecksumP((phalP40CmdPriv_Sw_DataParams_t *)pDataParams,
            wStartAddr, wLength, bCksumType, wDestAddress, pCrc );
        break;
#endif /* NXPBUILD__PHAL_P40CMDPRIV_SW */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_P40CMDPRIV);
        break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

/***************************************************************************************/
phStatus_t phalP40CmdPriv_ExecuteP( void *       pDataParams,
                                                                   uint16_t    wExeAddr,
                                                                   uint8_t      bMagic,
                                                                   uint8_t      bParamLength,
                                                                   uint8_t *    pParamBuffer,
                                                                   uint16_t    bRespSize,
                                                                   uint8_t *    pRespBuffer,
                                                                   uint16_t *  pRespLength  )
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phalP40CmdPriv_ExecuteP");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_AL_P40CMDPRIV)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_P40CMDPRIV);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_P40CMDPRIV_SW
    case PHAL_P40CMDPRIV_SW_ID:
        status = phalP40CmdPriv_Sw_ExecuteP((phalP40CmdPriv_Sw_DataParams_t *)pDataParams,
            wExeAddr, bMagic, bParamLength, pParamBuffer,
            bRespSize, pRespBuffer, pRespLength);
        break;
#endif /* NXPBUILD__PHAL_P40CMDPRIV_SW */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_P40CMDPRIV);
        break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

/***************************************************************************************/
phStatus_t phalP40CmdPriv_AuthenticateP( void *     pDataParams,
                                                                        uint8_t     bKeyId,
                                                                        uint16_t   wKeyNumber,
                                                                        uint16_t   wKeyVersion)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phalP40CmdPriv_AuthenticateP");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(KeyId);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(KeyNumber);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(KeyVersion);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
	PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, KeyId_log,&bKeyId);
	PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, KeyNumber_log,&wKeyNumber);
	PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, KeyVersion_log,&wKeyVersion);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_AL_P40CMDPRIV)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_P40CMDPRIV);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_P40CMDPRIV_SW
    case PHAL_P40CMDPRIV_SW_ID:
        status = phalP40CmdPriv_Sw_AuthenticateP((phalP40CmdPriv_Sw_DataParams_t *)pDataParams,
            bKeyId, wKeyNumber, wKeyVersion);
        break;
#endif /* NXPBUILD__PHAL_P40CMDPRIV_SW */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_P40CMDPRIV);
        break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}



/***************************************************************************************/
phStatus_t phalP40CmdPriv_FastTestP( void *    pDataParams,
                                     uint8_t    bTestCode)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phalP40CmdPriv_FastTestP");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_AL_P40CMDPRIV)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_P40CMDPRIV);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_P40CMDPRIV_SW
    case PHAL_P40CMDPRIV_SW_ID:
        status = phalP40CmdPriv_Sw_FastTestP((phalP40CmdPriv_Sw_DataParams_t *)pDataParams, bTestCode );
        break;
#endif /* NXPBUILD__PHAL_P40CMDPRIV_SW */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_P40CMDPRIV);
        break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}


phStatus_t phalP40CmdPriv_SwitchLifeCycleP( void *    pDataParams,
                                            uint8_t    bLifeCycle)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phalP40CmdPriv_SwitchLifeCycleP");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(LifeCycle);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
	PH_LOG_HELPER_ADDPARAM_UINT8(PH_LOG_LOGTYPE_DEBUG, LifeCycle_log,&bLifeCycle);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_AL_P40CMDPRIV)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_P40CMDPRIV);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_P40CMDPRIV_SW
    case PHAL_P40CMDPRIV_SW_ID:
        status = phalP40CmdPriv_Sw_SwitchLifeCycleP(
                                                (phalP40CmdPriv_Sw_DataParams_t *)pDataParams,
                                                bLifeCycle );
        break;
#endif /* NXPBUILD__PHAL_P40CMDPRIV_SW */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_P40CMDPRIV);
        break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}
#endif  /* NXPBUILD__PHAL_P40CMDPRIV */
