/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
* Software implementation of P40 CmdPriv layer. Uses I.PrivateCommands  in P40
* $Author: Rajendran Kumar (nxp99556) $
* $Revision: 7467 $
* $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
*/

#ifndef PHALP40CMDPRIV_SW_H
#define PHALP40CMDPRIV_SW_H

#include <phalP40CmdPriv.h>

phStatus_t phalP40CmdPriv_Sw_GetVersionP (
    phalP40CmdPriv_Sw_DataParams_t * pDataParams,
    uint8_t *                                                  pVersionData
    );

phStatus_t phalP40CmdPriv_Sw_WriteMemoryP (
    phalP40CmdPriv_Sw_DataParams_t *  pDataParams,
    uint16_t                                                   wStartAddr,
    uint8_t                                                     bUseRandom,
    uint8_t                                                     bDataLength,
    uint8_t *                                                   pData
    );

phStatus_t phalP40CmdPriv_Sw_ReadMemoryP (
    phalP40CmdPriv_Sw_DataParams_t * pDataParams,
    uint16_t                                                  wStartAddr,
    uint8_t                                                    bDataLength,
    uint8_t *                                                  pData,
    uint16_t *                                                pReadLength
    );

phStatus_t phalP40CmdPriv_Sw_CalculateChecksumP (
    phalP40CmdPriv_Sw_DataParams_t * pDataParams,
    uint16_t                                                   wStartAddr,
    uint16_t                                                   wLength,
    uint8_t                                                     bCksumType,
    uint16_t                                                   wDestAddress,
    uint8_t*                                                    pCrc
    );

phStatus_t phalP40CmdPriv_Sw_ExecuteP (
    phalP40CmdPriv_Sw_DataParams_t * pDataParams,
    uint16_t                                                   wExeAddr,
    uint8_t                                                     bMagic,
    uint8_t                                                     bParamLength,
    uint8_t *                                                   pParamBuffer,
    uint16_t                                                   bRespSize,
    uint8_t *                                                   pRespBuffer,
    uint16_t *                                                 pRespLength
    );

phStatus_t phalP40CmdPriv_Sw_AuthenticateP (
    phalP40CmdPriv_Sw_DataParams_t * pDataParams,
    uint8_t                                                     bKeyId,
    uint16_t                                                   wKeyNumber,
    uint16_t                                                   wKeyVersion
    );

phStatus_t phalP40CmdPriv_Sw_FastTestP (
    phalP40CmdPriv_Sw_DataParams_t * pDataParams,
    uint8_t                                                     bTestCode
    );

phStatus_t phalP40CmdPriv_Sw_SwitchLifeCycleP (
    phalP40CmdPriv_Sw_DataParams_t * pDataParams,
    uint8_t                                                     bLifeCycle
    );


#endif /* PHALP40CMDPRIV_SW_H */
