/*
 * Copyright 2018, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef MFPRIMENTAG_SAM_X_INT_H
#define MFPRIMENTAG_SAM_X_INT_H

#include <phalMfprimeNtag.h>

#define PHAL_MFPRIMENTAG_MAX_WRITE_LEN		124	/* The default frame size is 124 bytes. So if the Write related commands need to transmitted to the PICC via SAM,
												 * the command including the data to be written and excluding PICC header comes to 124 bytes.
												 */

#define PHAL_MFPRIMENTAG_SAM_X_SESSION_MAC	2	/**< Optionto perform generate the SDM session MAC keys. */

/* Resolves the component to be used. */
#define PHAL_MFPRIMENTAG_RESOLVE_DATAPARAMS(DataParams)	((phalMfPrimeNtag_SamAV3_X_DataParams_t *) DataParams)

/* Resolves the Hal component to be used for communicating with Sam hardware in X mode. */
#define PHAL_MFPRIMENTAG_RESOLVE_HAL_DATAPARAMS(DataParams)																								\
			(PH_GET_COMPID(DataParams) == PHAL_MFPRIMENTAG_SAMAV3_X_ID) ? ((phalMfPrimeNtag_SamAV3_X_DataParams_t *) DataParams)->pHalSamDataParams :	\
			NULL

phStatus_t phalMfPrimeNtag_Sam_X_Int_ValidateResponse(void * pDataParams, uint16_t wStatus, uint8_t * pPiccRetCode);

phStatus_t phalMfPrimeNtag_Sam_X_Int_Iso7816Wrap(uint8_t bLengthPresent, uint8_t bLengthLen, uint8_t bLePresent, uint32_t dwTotDataLen,
	uint8_t * pPlainData, uint16_t * pDataLen);

phStatus_t phalMfPrimeNtag_Sam_X_Int_ResetAuthentication(void * pDataParams);

phStatus_t phalMfPrimeNtag_Sam_X_Int_ComputeSDMSessionVectors(void * pDataParams, uint8_t bSdmOption, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer,
	uint16_t wDstKeyNo, uint8_t * pUid, uint8_t bUidLen, uint8_t * pSDMReadCtr);
#endif /* MFPRIMENTAG_SAM_X_INT_H */
