/*
 * Copyright 2013, 2017 - 2018, 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */


/** \file
 * Internal functions of Software implementation of MIFARE DESFIRE EV1 application layer.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  SA: Generated 09. Mar 2010
 *
 */

#ifndef PHALMFDF_INT_H
#define PHALMFDF_INT_H

#include <ph_Status.h>
#include <phalMfdf.h>

/** \name MIFARE Desfire Native Commands */
/** @{ */
#define PHAL_MFDF_CMD_AUTHENTICATE						0x0A	/**< MF DF Authenticate command. */
#define PHAL_MFDF_CMD_AUTHENTICATE_ISO					0x1A	/**< MF DF Authenticate ISO command. */
#define PHAL_MFDF_CMD_AUTHENTICATE_AES					0xAA	/**< MF DF Authenticate AES command. */
#define PHAL_MFDF_CMD_CHANGE_KEY_SETTINGS				0x54	/**< MF DF Change key settings cmd. */
#define PHAL_MFDF_CMD_GET_KEY_SETTINGS					0x45	/**< MF DF Get Key Settings Cmd.  */
#define PHAL_MFDF_CMD_CHANGE_KEY						0xC4	/**< MF DF Change key cmd. */
#define PHAL_MFDF_CMD_GET_KEY_VERSION					0x64	/**< MF DF Get Key Version. */

#define PHAL_MFDF_CMD_CREATE_APPLN						0xCA	/**< MF DF Create Application cmd. */
#define PHAL_MFDF_CMD_DELETE_APPLN						0xDA	/**< MF DF Delete Application cmd. */
#define PHAL_MFDF_CMD_GET_APPLN_IDS						0x6A	/**< MF DF Get Application Ids cmd. */
#define PHAL_MFDF_CMD_GET_DF_NAMES						0x6D	/**< MF DF Get Dedicated Fine names cmd. */
#define PHAL_MFDF_CMD_SELECT_APPLN						0x5A	/**< MF DF Select Application Cmd. */
#define PHAL_MFDF_CMD_FORMAT_PICC						0xFC	/**< MF DF Format PICC Cmd. */
#define PHAL_MFDF_CMD_GET_VERSION						0x60	/**< MF DF Get Version cmd. */


#define PHAL_MFDF_CMD_FREE_MEM							0x6E	/**< MF DF Free Memory cmd. */
#define PHAL_MFDF_CMD_SET_CONFIG						0x5C	/**< MF DF Set Configuration Cmd. */
#define PHAL_MFDF_CMD_GET_CARD_UID						0x51	/**< MF DF Get Card UID cmd. */
#define PHAL_MFDF_CMD_GET_FILE_IDS						0x6F	/**< MF DF Get File IDs cmd. */
#define PHAL_MFDF_CMD_GET_ISO_FILE_IDS					0x61	/**< MF DF Get ISO File IDs cmd. */
#define PHAL_MFDF_CMD_GET_FILE_SETTINGS					0xF5	/**< MF DF Get File settings cmd. */
#define PHAL_MFDF_CMD_CHANGE_FILE_SETTINGS				0x5F	/**< MF DF Change file settings cmd. */
#define PHAL_MFDF_CMD_CREATE_STD_DATAFILE				0xCD	/**< MF DF Create Standard data file cmd. */

#define PHAL_MFDF_CMD_CREATE_BKUP_DATAFILE				0xCB	/**< MF DF Create Backup data file cmd. */
#define PHAL_MFDF_CMD_CREATE_VALUE_FILE					0xCC	/**< MF DF Create Value File cmd. */
#define PHAL_MFDF_CMD_CREATE_LINEAR_RECFILE				0xC1	/**< MF DF Create Linear record file cmd. */
#define PHAL_MFDF_CMD_CREATE_CYCLIC_RECFILE				0xC0	/**< MF DF Create Cyclic record file cmd. */
#define PHAL_MFDF_CMD_DELETE_FILE						0xDF	/**< MF DF Delete File cmd. */
#define PHAL_MFDF_CMD_READ_DATA							0xBD	/**< MF DF Read Data cmd. */

#define PHAL_MFDF_CMD_WRITE_DATA						0x3D	/**< MF DF Write data cmd. */

#define PHAL_MFDF_CMD_GET_VALUE							0x6C	/**< MF DF Get Value cmd. */
#define PHAL_MFDF_CMD_CREDIT							0x0C	/**< MF DF Credit cmd. */
#define PHAL_MFDF_CMD_DEBIT								0xDC	/**< MF DF Debit cmd. */
#define PHAL_MFDF_CMD_LIMITED_CREDIT					0x1C	/**< MF DF Limited Credit cmd. */
#define PHAL_MFDF_CMD_WRITE_RECORD						0x3B	/**< MF DF Write Record cmd. */
#define PHAL_MFDF_CMD_READ_RECORDS						0xBB	/**< MF DF Read Records cmd. */
#define PHAL_MFDF_CMD_CLEAR_RECORDS_FILE				0xEB	/**< MF DF Clear records file cmd. */
#define PHAL_MFDF_CMD_COMMIT_TXN						0xC7	/**< MF DF Commit transaction cmd. */
#define PHAL_MFDF_CMD_ABORT_TXN							0xA7	/**< MF DF Abort transaction cmd. */
#define PHAL_MFDF_CMD_CHAINING							0xAF	/**< MF DF chaining command. */
/** @} */

/** \name ISO 7816 Instructions */
/** @{ */
#define PHAL_MFDF_CMD_ISO7816_SELECT_FILE				0xA4	/**< ISO Select File. */
#define PHAL_MFDF_CMD_ISO7816_READ_RECORDS				0xB2	/**< ISO Read records. */
#define PHAL_MFDF_CMD_ISO7816_READ_BINARY				0xB0	/**< ISO Read Binary. */
#define PHAL_MFDF_CMD_ISO7816_UPDATE_BINARY				0xD6	/**< ISO UPDATE Binary. */
#define PHAL_MFDF_CMD_ISO7816_APPEND_RECORD				0xE2	/**< ISO Append record. */
#define PHAL_MFDF_CMD_ISO7816_UPDATE_RECORD				0xD2	/**< ISO Update record. */
#define PHAL_MFDF_CMD_ISO7816_GET_CHALLENGE				0x84	/**< ISO Get challenge. */
#define PHAL_MFDF_CMD_ISO7816_EXT_AUTHENTICATE			0x82	/**< ISO Ext. Authenticate. */
#define PHAL_MFDF_CMD_ISO7816_INT_AUTHENTICATE			0x88	/**< ISO Int. Authenticate. */
/** @} */

/** \name Authentication Modes */
/** @{ */
#define PHAL_MFDF_NOT_AUTHENTICATED						0xFFU   /**< No authentication. */
#define PHAL_MFDF_AUTHENTICATE							0x0AU	/**< Backwards compatible Authentication; Mode = 0x0A. */
#define PHAL_MFDF_AUTHENTICATEISO						0x1AU	/**< ISO Authentication; 0x1A. */
#define PHAL_MFDF_AUTHENTICATEAES						0xAAU	/**< AES Authentication; 0xAA. */
/** @} */

/** \name MIFARE Desfire specific defines */
/** @{ */
#define PHAL_MFDF_MAXWRAPPEDAPDU_SIZE					0x37u	/**< Maximum size of wrapped APDU 55 bytes. */
#define PHAL_MFDF_MAXDFAPDU_SIZE						0x3Cu	/**< Maximum size of DESFire APDU 60 bytes. */
#define PHAL_MFDF_DFAPPID_SIZE							0x03u	/**< Size of MF DF application Id. */
#define PHAL_MFDF_DATA_BLOCK_SIZE						0x10u	/**< Data block size need for internal purposes. */
#define PHAL_MFDF_MAX_FRAME_SIZE						0x40u	/**< Max size in a ISO 14443-4 frame. */
/** @} */

#define PHAL_MFDF_WRAP_HDR_LEN							0x05U	/* Wrapped APDU header length */
#define PHAL_MFDF_WRAPPEDAPDU_CLA						0x90U	/* Wrapped APDU default class. */
#define PHAL_MFDF_WRAPPEDAPDU_P1						0x00U	/* Wrapped APDU default P1. */
#define PHAL_MFDF_WRAPPEDAPDU_P2						0x00U	/* Wrapped APDU default P2. */
#define PHAL_MFDF_WRAPPEDAPDU_LE						0x00U	/* Wrapped APDU default LE. */

/* To avoid unused variable warnings. */
#define PHAL_MFDF_UNUSED_VARIABLE(x)  {for( ( x ) = ( x ) ; ( x ) != ( x ) ; );}
#define PHAL_MFDF_UNUSED_ARRAY(x)  {for( ( (x)[0] ) = ( (x)[0] ) ; ( (x)[0] ) != ( (x)[0] ) ; );}

phStatus_t phalMfdf_Int_ComputeErrorResponse(void * pDataParams, uint16_t wStatus);

phStatus_t phalMfdf_ExchangeCmd(void * pDataParams, void * pPalMifareDataParams, uint8_t bWrappedMode, uint8_t * pSendBuff,
	uint16_t wCmdLen, uint8_t ** ppResponse, uint16_t * pRxlen);

phStatus_t phalMfdf_Int_Send7816Apdu(void * pDataParams, void * pPalMifareDataParams, uint8_t bOption, uint8_t bIns, uint8_t bP1,
	uint8_t bP2, uint8_t bLc, uint8_t * pDataIn, uint8_t bLe, uint8_t ** ppDataOut, uint16_t *pDataLen);

#endif /* PHALMFDF_INT_H */
