/*
 * Copyright 2010 - 2013, 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software ISO18000-3 Mode3 Application Layer (Internals).
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  CHu: Generated 20. July 2010
 *
 */

#include <ph_Status.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHAL_I18000P3M3_SW

#include <phalI18000p3m3.h>
#include "phalI18000p3m3_Sw_Int.h"

phStatus_t phalI18000p3m3_Sw_ParseError(
                                        phalI18000p3m3_Sw_DataParams_t * pDataParams,
                                        uint8_t * pRxData,
                                        uint16_t wRxDataLength,
                                        uint8_t bRxLastBits
                                        )
{
    phStatus_t  PH_MEMLOC_REM status;
    uint8_t     PH_MEMLOC_REM bError;
    uint8_t     PH_MEMLOC_REM bHandle[2];

    /* Parameter check */
    if (pRxData == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_INTERNAL_ERROR, PH_COMP_AL_I18000P3M3);
    }

    /* Check received length */
    if ((wRxDataLength != 4) || (bRxLastBits != 1))
    {
        return PH_ADD_COMPCODE(PH_ERR_PROTOCOL_ERROR, PH_COMP_AL_I18000P3M3);
    }

    /* Check for Error-Bit */
    if (!(pRxData[0] & 0x80))
    {
        return PH_ADD_COMPCODE(PH_ERR_PROTOCOL_ERROR, PH_COMP_AL_I18000P3M3);
    }

    /* Check Handle */
    bHandle[0] = (uint8_t)((pRxData[1] << 1) | (pRxData[2] >> 7));
    bHandle[1] = (uint8_t)((pRxData[2] << 1) | (pRxData[3] >> 7));
    if ((bHandle[0] != pDataParams->abHandle[0]) ||
        (bHandle[1] != pDataParams->abHandle[1]))
    {
        return PH_ADD_COMPCODE(PH_ERR_PROTOCOL_ERROR, PH_COMP_AL_I18000P3M3);
    }

    /* Retrieve and map error code */
    bError = (uint8_t)((pRxData[0] << 1) | (pRxData[1] >> 7));
    switch (bError)
    {
    case PHAL_I18000P3M3_ERRCODE_OTHER:
        status = PH_ADD_COMPCODE(PHAL_I18000P3M3_ERR_OTHER, PH_COMP_AL_I18000P3M3);
        break;
    case PHAL_I18000P3M3_ERRCODE_MEMORY_OVERRUN:
        status = PH_ADD_COMPCODE(PHAL_I18000P3M3_ERR_MEMORY_OVERRUN, PH_COMP_AL_I18000P3M3);
        break;
    case PHAL_I18000P3M3_ERRCODE_MEMORY_LOCKED:
        status = PH_ADD_COMPCODE(PHAL_I18000P3M3_ERR_MEMORY_LOCKED, PH_COMP_AL_I18000P3M3);
        break;
    case PHAL_I18000P3M3_ERRCODE_INSUFFICIENT_POWER:
        status = PH_ADD_COMPCODE(PHAL_I18000P3M3_ERR_INSUFFICIENT_POWER, PH_COMP_AL_I18000P3M3);
        break;
    case PHAL_I18000P3M3_ERRCODE_NON_SPECIFIC:
        status = PH_ADD_COMPCODE(PHAL_I18000P3M3_ERR_NON_SPECIFIC, PH_COMP_AL_I18000P3M3);
        break;
    default:
        status = PH_ADD_COMPCODE(PH_ERR_PROTOCOL_ERROR, PH_COMP_AL_I18000P3M3);
        break;
    }

    return status;
}

#endif /* NXPBUILD__PHAL_I18000P3M3_SW */
