/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * DUT specific Symmetric Cryptography Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHCRYPTOSYM_DUT_H
#define PHCRYPTOSYM_DUT_H

#include <ph_Status.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PH_CRYPTOSYM_DUT

#include <setjmp.h>
#include <phCryptoSym.h>

#define PH_CRYPTOSYM_INTERNAL_BUFFER_SIZE 256U

#define TRY                                                                                 \
    do                                                                                      \
    {                                                                                       \
        jmp_buf ex_buf__;                                                                   \
        switch( setjmp(ex_buf__) )                                                          \
        {                                                                                   \
            case 0:                                                                         \
                while (1)                                                                   \
                {

#define CATCH(x)                                                                            \
                break;                                                                      \
            case x:

#define FINALLY                                                                             \
                break;                                                                      \
                }                                                                           \
            default:

#define END                                                                                 \
        }                                                                                   \
    } while(0);

#define END_EXT                                                                             \
                break;                                                                      \
                }                                                                           \
            default:                                                                        \
                break;                                                                      \
        }                                                                                   \
    } while(0);

#define THROW(x) longjmp(ex_buf__, x)

#define EXCEPTION           (1)
#define RDLIB_EXCEPTION     (2)

#define PH_CHECK_SUCCESS_FCT_EXT(Status, Fct)                                               \
    {                                                                                       \
        (Status) = (Fct);                                                                   \
        if (Status != 0)                                                                    \
        {                                                                                   \
            THROW(RDLIB_EXCEPTION);                                                         \
        }                                                                                   \
    }

phStatus_t phCryptoSym_DUT_GetLastStatus(phCryptoSym_DUT_DataParams_t * pDataParams, uint16_t wStatusMsgLen, int8_t * pStatusMsg,
    int32_t * pStatusCode);

phStatus_t phCryptoSym_DUT_InvalidateKey(phCryptoSym_DUT_DataParams_t * pDataParams);

phStatus_t phCryptoSym_DUT_SetConfig(phCryptoSym_DUT_DataParams_t * pDataParams, uint16_t wConfig, uint16_t wValue);

phStatus_t phCryptoSym_DUT_GetConfig(phCryptoSym_DUT_DataParams_t * pDataParams, uint16_t wConfig, uint16_t * pValue);





phStatus_t phCryptoSym_DUT_Encrypt(phCryptoSym_DUT_DataParams_t * pDataParams, uint16_t wOption, const uint8_t * pPlainBuff,
    uint16_t wPlainBuffLen, uint8_t * pEncBuff);

phStatus_t phCryptoSym_DUT_Decrypt(phCryptoSym_DUT_DataParams_t * pDataParams, uint16_t wOption, const uint8_t * pEncBuff,
    uint16_t  wEncBuffLen, uint8_t * pPlainBuff);

phStatus_t phCryptoSym_DUT_CalculateMac(phCryptoSym_DUT_DataParams_t * pDataParams, uint16_t wOption, const uint8_t * pData,
    uint16_t  wDataLen, uint8_t * pMac, uint8_t * pMacLen);

phStatus_t phCryptoSym_DUT_LoadIv(phCryptoSym_DUT_DataParams_t * pDataParams, const uint8_t * pIV, uint8_t bIVLen);

phStatus_t phCryptoSym_DUT_LoadKey(phCryptoSym_DUT_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wKeyVer, uint16_t wKeyType);

phStatus_t phCryptoSym_DUT_LoadKeyDirect(phCryptoSym_DUT_DataParams_t * pDataParams, const uint8_t * pKey, uint16_t wKeyType);

phStatus_t phCryptoSym_DUT_DiversifyKey(phCryptoSym_DUT_DataParams_t * pDataParams, uint16_t wOption, uint16_t wKeyNo, uint16_t wKeyVer,
    uint8_t * pDivInput, uint8_t  bDivInputLen, uint8_t * pDiversifiedKey, uint8_t * pDivKeyLen);

phStatus_t phCryptoSym_DUT_DiversifyDirectKey(phCryptoSym_DUT_DataParams_t * pDataParams, uint16_t wOption, uint8_t * pKey, uint16_t wKeyType,
    uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pDiversifiedKey, uint8_t * pDivKeyLen);





void phCryptoSym_DUT_BackupHalInfo(phCryptoSym_DUT_DataParams_t * pDataParams, uint8_t **ppTxBuff_Hal, uint16_t *pTxBuffSize_Hal,
    uint16_t *pTxBuffLen_Hal, uint16_t *pTxBuffStart_Hal, uint16_t *pTxBuffStartPos_Hal, uint8_t **ppRxBuff_Hal, uint16_t *pRxBuffSize_Hal,
    uint16_t *pRxBuffLen_Hal, uint16_t *pRxBuffStartPos_Hal);

void phCryptoSym_DUT_RestoreHalInfo(phCryptoSym_DUT_DataParams_t * pDataParams, uint8_t **ppTxBuff_Hal, uint16_t *pTxBuffSize_Hal,
    uint16_t *pTxBuffLen_Hal, uint16_t *pTxBuffStart_Hal, uint16_t *pTxBuffStartPos_Hal, uint8_t **ppRxBuff_Hal, uint16_t *pRxBuffSize_Hal,
    uint16_t *pRxBuffLen_Hal, uint16_t *pRxBuffStartPos_Hal);

#endif /* NXPBUILD__PH_CRYPTOSYM_DUT */

#endif /* PHCRYPTOSYM_DUT_H */
