/*
 * Copyright 2022 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * DUT specific Random Number Component of the Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  Generated 24. Aug 2022
 *
 */

#ifndef PHCRYPTORNG_DUT_H
#define PHCRYPTORNG_DUT_H

#include <ph_Status.h>

#ifdef NXPBUILD__PH_CRYPTORNG_DUT
#include <phCryptoRng.h>


phStatus_t phCryptoRng_DUT_Seed(phCryptoRng_DUT_DataParams_t * pDataParams, uint8_t * bSeed, uint8_t bSeedLen);

phStatus_t phCryptoRng_DUT_Rnd(phCryptoRng_DUT_DataParams_t * pDataParams, uint16_t  wNoOfRndBytes, uint8_t * pRnd);

phStatus_t phCryptoRng_DUT_GetLastStatus(phCryptoRng_DUT_DataParams_t * pDataParams, uint16_t wStatusMsgLen, int8_t * pStatusMsg,
    int32_t * pStatusCode);
#endif /* NXPBUILD__PH_CRYPTORNG_DUT */

#endif /* PHCRYPTORNG_DUT_H */
