/*
 * Copyright 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Symmetric and ASymmertic Authentication Keys for MIFARE DUOX example.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7230 $
 * $Date: 2025-03-14 10:27:23 +0530 (Fri, 14 Mar 2025) $
 */

#ifndef EXAMPLE_MIFAREDUOX_KEYS_H
#define EXAMPLE_MIFAREDUOX_KEYS_H

#include <ph_Status.h>

/* CA Root Key (P-256) ------------------------------------------------------------------------------------------------------- */
#define ECC_P256_HOST_CA_PUBLIC_KEY_ADDRESS                 10
#define ECC_P256_HOST_CA_PUBLIC_KEY_POSITION                1
uint8_t aP256_HOST_CA_PublicKey[] =
{
    0x04, 0xD0, 0x0D, 0x76, 0x39, 0x09, 0xDE, 0x80, 0x17, 0x37, 0x6D, 0xF1, 0x43, 0x12, 0x4A, 0xB2,
    0x51, 0xD9, 0x26, 0xB0, 0x40, 0xE1, 0x17, 0x3D, 0x04, 0xC6, 0x2F, 0xE8, 0xC1, 0xAD, 0xA0, 0xF2,
    0xBC, 0x20, 0x86, 0x5E, 0x60, 0x5C, 0x69, 0x71, 0xF3, 0x29, 0x3D, 0xEE, 0xBD, 0x93, 0x01, 0x97,
    0x12, 0xBD, 0xF1, 0xAD, 0x1E, 0xEC, 0x5C, 0x9C, 0x39, 0xE2, 0x5C, 0x7D, 0x05, 0x00, 0x5B, 0x49,
    0xF5
};

#define ECC_P256_DEVICE_CA_PUBLIC_KEY_ADDRESS               (ECC_P256_HOST_CA_PUBLIC_KEY_ADDRESS + 1)
#define ECC_P256_DEVICE_CA_PUBLIC_KEY_POSITION              1
uint8_t aP256_DEVICE_CA_PublicKey[] =
{
    0x04, 0x4B, 0xBA, 0xC7, 0x1F, 0x81, 0x12, 0x99, 0x31, 0xDD, 0x18, 0xBA, 0x7D, 0x96, 0xEC, 0xB0,
    0x4A, 0x04, 0xFC, 0x55, 0x9C, 0xCA, 0xFD, 0x9E, 0x1B, 0x6C, 0xEB, 0xBC, 0xBA, 0x08, 0x79, 0x18,
    0xED, 0xDB, 0x99, 0xAC, 0x8C, 0xFF, 0x4A, 0xF1, 0x7F, 0x8D, 0x61, 0x47, 0xAA, 0xFC, 0x5A, 0x98,
    0x38, 0xE1, 0x2E, 0x1A, 0xFA, 0x15, 0xC1, 0x28, 0x45, 0x15, 0x91, 0xDF, 0xF4, 0x89, 0xB7, 0x19,
    0x69
};

/* Host Key (P-256) ---------------------------------------------------------------------------------------------------------- */
#define ECC_P256_HOST_PRIVATE_KEY_ADDRESS                   (ECC_P256_DEVICE_CA_PUBLIC_KEY_ADDRESS + 1)
#define ECC_P256_HOST_PRIVATE_KEY_POSITION                  0
uint8_t aP256_HOST_PrivateKey[] =
{
    0x70, 0x94, 0x6A, 0x76, 0x58, 0x75, 0x30, 0x36, 0x65, 0xA4, 0x69, 0x78, 0x23, 0x13, 0x52, 0xAD,
    0x6B, 0x8F, 0x33, 0x08, 0x4A, 0xB2, 0x0C, 0x24, 0x76, 0x6C, 0x13, 0xEF, 0x2D, 0xC3, 0x32, 0xDD
};

/* Device Key (P-256) -------------------------------------------------------------------------------------------------------- */
#define ECC_P256_DEVICE_PRIVATE_KEY_ADDRESS                 (ECC_P256_HOST_PRIVATE_KEY_ADDRESS + 1)
#define ECC_P256_DEVICE_PRIVATE_KEY_POSITION                0
uint8_t aP256_DEVICE_PrivateKey[] =
{
    0x5E, 0xA5, 0xC4, 0xD0, 0x8C, 0x33, 0xB7, 0xE4, 0xCA, 0xFD, 0x64, 0xEE, 0x37, 0x2D, 0x89, 0x0A,
    0x55, 0xCC, 0xB5, 0x8E, 0x7D, 0xCF, 0xBB, 0x66, 0x25, 0xD8, 0xAF, 0xE8, 0x84, 0xE2, 0x65, 0x8B
};

/* AES Key ------------------------------------------------------------------------------------------------------------------- */
#define AES128_KEY_ADDRESS                                  (ECC_P256_DEVICE_PRIVATE_KEY_ADDRESS + 1)
#define AES128_KEY_VERSION                                  0
uint8_t aAES128_Key[] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

#define AES256_KEY_ADDRESS                                  (AES128_KEY_ADDRESS + 1)
#define AES256_KEY_VERSION                                  0
uint8_t aAES256_Key[] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

#define SDM_PUBLIC_KEY_ADDRESS                              (AES256_KEY_ADDRESS + 1)
#define SDM_PUBLIC_KEY_PSOITION                             0

#endif /* EXAMPLE_MIFAREDUOX_KEYS_H */
