/*
 * Copyright 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Host and Device NIST-256 Certificates for MIFARE DUOX example.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7230 $
 * $Date: 2025-03-14 10:27:23 +0530 (Fri, 14 Mar 2025) $
 */

#ifndef EXAMPLE_MIFAREDUOX_CERT_H
#define EXAMPLE_MIFAREDUOX_CERT_H

#include <ph_Status.h>

/* Host (P-256) Certificates ------------------------------------------------------------------------------------------------- */
uint8_t aP256_HOST_Cert[] =
{
    /* Actual Certificatie information. */
    0x30, 0x82, 0x01, 0x2E, 0x30, 0x81, 0xD5, 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x04, 0xCC, 0xCC,
    0xCC, 0xCC, 0x30, 0x0A, 0x06, 0x08, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x04, 0x03, 0x02, 0x30, 0x0F,
    0x31, 0x0D, 0x30, 0x0B, 0x06, 0x03, 0x55, 0x04, 0x2D, 0x03, 0x04, 0x00, 0x01, 0x23, 0x47, 0x30,
    0x22, 0x18, 0x0F, 0x31, 0x39, 0x37, 0x30, 0x30, 0x31, 0x30, 0x31, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x5A, 0x18, 0x0F, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32, 0x33, 0x35, 0x39,
    0x35, 0x39, 0x5A, 0x30, 0x0F, 0x31, 0x0D, 0x30, 0x0B, 0x06, 0x03, 0x55, 0x04, 0x2D, 0x03, 0x04,
    0x00, 0x01, 0x23, 0x45, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x02,
    0x01, 0x06, 0x08, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x16,
    0x6A, 0xC3, 0x2F, 0xED, 0xF0, 0xA5, 0xA1, 0xBE, 0x6C, 0x8D, 0x3B, 0x19, 0x1A, 0x73, 0x9D, 0x0B,
    0xE7, 0x58, 0x48, 0x25, 0x1C, 0x7D, 0x09, 0x4E, 0x39, 0x1E, 0xA7, 0x90, 0x4C, 0x7A, 0x97, 0x70,
    0x87, 0x5B, 0xEB, 0xE1, 0xCA, 0xCC, 0xA2, 0x14, 0x6D, 0x9A, 0xE6, 0xA6, 0x5B, 0x72, 0xFB, 0x4D,
    0x8E, 0x8F, 0x59, 0x22, 0x7B, 0x16, 0x0E, 0xE2, 0xA3, 0x9E, 0x9E, 0x58, 0x09, 0x47, 0x09, 0xA3,
    0x1B, 0x30, 0x19, 0x30, 0x17, 0x06, 0x0A, 0x3B, 0x06, 0x01, 0x04, 0x01, 0x81, 0xDB, 0x69, 0x40,
    0x01, 0x01, 0x01, 0x00, 0x04, 0x06, 0x81, 0xDF, 0x00, 0x11, 0x00, 0x00, 0x30, 0x0A, 0x06, 0x08,
    0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x04, 0x03, 0x02, 0x03, 0x48, 0x00, 0x30, 0x45, 0x02, 0x20, 0x2F,
    0x40, 0x78, 0x27, 0xAD, 0x0F, 0x13, 0xF0, 0xCA, 0x5F, 0x8C, 0xAD, 0xF4, 0x6A, 0x8A, 0x51, 0x95,
    0xAE, 0x1C, 0xFB, 0x5C, 0x9D, 0xA1, 0x1B, 0x49, 0x12, 0xAF, 0x42, 0x2B, 0xE7, 0xB2, 0x5E, 0x02,
    0x21, 0x00, 0xEE, 0x5F, 0x99, 0xEB, 0xBD, 0x64, 0xAC, 0xD5, 0x12, 0x44, 0x57, 0xBA, 0xE1, 0xB8,
    0xD2, 0xB8, 0xC9, 0x34, 0xC8, 0x82, 0x1D, 0x15, 0xD5, 0xA3, 0xC2, 0x65, 0xA3, 0x6F, 0xAB, 0x08,
    0x3D, 0x0A
};




/* Device (P-256) Certificates ----------------------------------------------------------------------------------------------- */
uint8_t aP256_DEVICE_Cert[] =
{
    /* Actual Certificatie information. */
    0x30, 0x82, 0x01, 0x18, 0x30, 0x81, 0xBF, 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x04, 0x01, 0x02,
    0x03, 0x04, 0x30, 0x0A, 0x06, 0x08, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x04, 0x03, 0x02, 0x30, 0x14,
    0x31, 0x12, 0x30, 0x10, 0x06, 0x03, 0x55, 0x04, 0x2D, 0x03, 0x09, 0x00, 0x43, 0x41, 0x5F, 0x52,
    0x6F, 0x6F, 0x74, 0x30, 0x30, 0x1E, 0x17, 0x0D, 0x32, 0x34, 0x31, 0x31, 0x31, 0x34, 0x30, 0x34,
    0x32, 0x38, 0x30, 0x30, 0x5A, 0x17, 0x0D, 0x32, 0x34, 0x31, 0x31, 0x31, 0x34, 0x30, 0x34, 0x32,
    0x38, 0x30, 0x30, 0x5A, 0x30, 0x15, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x2D, 0x03,
    0x0A, 0x00, 0x4C, 0x65, 0x61, 0x66, 0x5F, 0x43, 0x65, 0x72, 0x74, 0x30, 0x59, 0x30, 0x13, 0x06,
    0x07, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x02, 0x01, 0x06, 0x08, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x03,
    0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xBF, 0xDC, 0x64, 0x46, 0x74, 0xC6, 0x6F, 0x27, 0x97, 0x30,
    0xBF, 0x76, 0x55, 0x01, 0x8C, 0x3F, 0x4D, 0x99, 0xDD, 0x8E, 0xD3, 0x59, 0xAE, 0x2F, 0x33, 0x02,
    0xDF, 0x22, 0xF4, 0xB2, 0x3F, 0x99, 0x6F, 0x14, 0x61, 0xAF, 0x29, 0x41, 0x17, 0x70, 0xDB, 0xAB,
    0xBC, 0x7C, 0x2C, 0x07, 0x4A, 0xC8, 0xF1, 0x8C, 0x87, 0xD0, 0x05, 0xCF, 0x15, 0xD4, 0x22, 0x03,
    0xA7, 0xF3, 0xB2, 0xBB, 0x18, 0x11, 0x30, 0x0A, 0x06, 0x08, 0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x04,
    0x03, 0x02, 0x03, 0x48, 0x00, 0x30, 0x45, 0x02, 0x20, 0x13, 0xD7, 0x8B, 0xB6, 0x80, 0xBF, 0x4F,
    0x46, 0x5A, 0x09, 0x6A, 0xCE, 0xC5, 0x8E, 0x9B, 0x81, 0x5C, 0x66, 0x51, 0xBB, 0x81, 0xA0, 0x60,
    0x58, 0x2C, 0xFE, 0x4C, 0xD6, 0x17, 0x5D, 0x8A, 0x3D, 0x02, 0x21, 0x00, 0xEB, 0xA0, 0x19, 0xB9,
    0x6F, 0x17, 0x44, 0x7F, 0x35, 0xB0, 0xF5, 0xE4, 0x5B, 0x4C, 0xEA, 0x8F, 0xA8, 0xE9, 0x64, 0x61,
    0x2A, 0x85, 0xD5, 0x26, 0x77, 0x40, 0xAB, 0x63, 0x65, 0xDF, 0x69, 0x44
};

#endif /* EXAMPLE_MIFAREDUOX_CERT_H */
