/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for SamAV2 ISO14443-4A Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHPALI14443P4A_SAMAV2_X_INT_H
#define PHPALI14443P4A_SAMAV2_X_INT_H

#include <ph_Status.h>

/** \addtogroup ph_Private
* @{
*/

/** PPS Command code. */
#define PHPAL_I14443P4A_SAMAV2_X_PPSS   0xD0U

/** PPS0 code. */
#define PHPAL_I14443P4A_SAMAV2_X_PPS0   0x11U

/** Position of LEN within ATS. */
#define PHPAL_I14443P4A_SAMAV2_X_ATS_LEN    0

/** Position of T0 within ATS. */
#define PHPAL_I14443P4A_SAMAV2_X_ATS_T0     1

/** Bit which signals TA(1) presence. */
#define PHPAL_I14443P4A_SAMAV2_X_ATS_TA1_PRESENT    0x10U

/** Bit which signals TB(1) presence. */
#define PHPAL_I14443P4A_SAMAV2_X_ATS_TB1_PRESENT    0x20U

/** Bit which signals TC(1) presence. */
#define PHPAL_I14443P4A_SAMAV2_X_ATS_TC1_PRESENT    0x40U

/** Bit within TC(1) which signals NAD support. */
#define PHPAL_I14443P4A_SAMAV2_X_ATS_TC1_NAD_SUPPORT    0x01U

/** Bit within TC(1) which signals CID support. */
#define PHPAL_I14443P4A_SAMAV2_X_ATS_TC1_CID_SUPPORT    0x02U

/** FWI default value. */
#define PHPAL_I14443P4A_SAMAV2_X_FWI_DEFAULT    0x04U

/** FSCI default value. */
#define PHPAL_I14443P4A_SAMAV2_X_FSCI_DEFAULT   0x02U

/** @}
* end of ph_Private
*/

#endif /* PHPALI14443P4A_SAMAV2_X_INT_H */
